//+------------------------------------------------------------------+
//|                                                      ProjectName |
//|                                      Copyright 2012, CompanyName |
//|                                       http://www.companyname.net |
//+------------------------------------------------------------------+
/*+-------------------------------------------------------------------+
  |                                                         iMAX3.mq4 |
  |                                                                   |
  | iMAX3 is a "hybrid" indicator based upon my prior works...        |
  | The original "iMAX" indicator and the follow on "iMAXhp"          |
  | indicator.  Both indicators phase shift a "Modified Optimum       |
  | Elliptic Filter" ref:                                             |
  |                                                                   |
  | Source of calculations:                                           |
  | Stocks & Commodities vol 18:7 p20-29                              |
  | Optimal Detrending by John F. Ehlers                              |
  |                                                                   |
  | Original iMAX indicator:                                          |
  |                                                                   |
  | The MOEF signal was phase shifted by 1 bar period... The base     |
  | phase and shifted phase cross are used to detect fast trends in   |
  | price action.  The MOEF signal as used iMAX has extremely useful  |
  | characteristics... it provides fast trend information with        |
  | no adjustments in parameters in all timeframes, and currencies.   |
  | It is extremely resistant to price spikes and holds a valid       |
  | trend in all market conditions... from extemely volatile, until   |
  | price action goes flat. It is not the fastest trend detection     |
  | system, but one of best overall for both speed and stability.     |
  | It is an ideal indicator for general purpose applications         |
  | such as trend change detection/alerts, MTF displays, and          |
  | filters.                                                          |
  |                                                                   |
  | The original iMAX indicator was published by me without copyright |
  | for use in the public domain.  Subsequent publications of iMAXhp, |
  | iMAXhpx, and iMAX3 are copyrighted works.                         |
  |                                                                   |
  | iMAXhp (high performance)                                         |
  |                                                                   |
  | To improve responsiveness or speed of detection of the iMAX       |
  | indicator the iMAXhp (high perfomance) indicator, swiched from    |
  | frequecy or bar/phase shifting the MOEF signal, to amplitude      |
  | phase shifting.  This improves response time by about two bars,   |
  | at the expense of some filtering characteristics, and it          |
  | requires the second phase amplitude be specified... A general     |
  | purpose set of amplitude values is built into this indicator for  |
  | ease of application, and can be adjusted if needed.               |
  |                                                                   |
  | For example:  Adjustment of the general purpose set of amplitude  |
  | values would be necessary when you are applying the indicator to  |
  | JPY currency pairs, because the JPY currency is so very different |
  | in it's price compared to other currencies. Amplitude is          |
  | adjusted by varying the Ph1step variable values in the code below.|
  | An approximate change in value to compensate for price            |
  | difference in the JPY currency would be to multiply the preset    |
  | Ph1step variable values by 100.  You can change a Ph1step value,  |
  | recompile the code, and observe the amplitude change using the    |
  | phase lines generated by the indicator in the chart price area.   |
  |                                                                   |
  | iMAXhpx                                                           |
  |                                                                   |
  | Not publically introduced before... I change the formula for      |
  | Ehlers' calculations slightly, and again boost speed in trend     |
  | detection.                                                        |
  |                                                                   |
  | All three modes are built into this indicator, and any, or all    |   
  | modes can be used simultaneously.  Welcome to iMAX3...            |
  |                                                                   |
  | iMAX3 attempts to standardize application of the prior indicators,|
  | offering the utility of either frequency, or amplitude phase      |
  | shifting.  By default this indicator will operate in the original |
  | bar/phase shifted mode... just drop in on a chart and it works    |
  | well in any timeframe and any currency.  For higher speed         |
  | amplitude phase shifted modes, the preset amplitude settings can  |
  | be used, or unique settings specified.                            |
  |                                                                   |
  | Another good reason for creating this hybrid version is that the  |
  | former frequency and amplitude shifted versions are intrinsically |
  | 180 degrees out of phase with each other.  So, in this version,   |
  | which I intend to base all future work upon,  both methods of     |
  | phase shifting are compensated for in terms of phase              |
  | differences... so all future applications can use either method   |
  | of phase shifting interchangeably.  If you build an application   |
  | using one method of phase shifting and decide later to change it, |
  | either for speed advantages, or better filtering characteristics, |
  | you can use this single indicator without potentially confusing   |
  | phase differences between them.                                   |
  |                                                                   |
  | This indicator changes it's values on the open bar with no other  |
  | modifications to it's bar/price history.                          |
  |                                                                   |
  | Indicator buffers are not read unless a particular mode is        |
  | specified, so execution speed of this hybrid indicator is on par  |
  | with a dedicated indicator executing a single mode.               |
  |                                                                   |
  |                                              Crafted by Wylie     |
  |                                              Copyright  2009     |
  |                                              dazzle.html@live.com |
  +-------------------------------------------------------------------+*/

#property copyright "Copyright  2009, Wylie"
#property link      "dazzle.html@live.com"

#property indicator_chart_window
#property indicator_buffers 6
#property indicator_color1  Lime
#property indicator_color2  HotPink
#property indicator_color3  White
#property indicator_color4  Orange
#property indicator_color5  Aqua
#property indicator_color6  Red

/*+-------------------------------------------------------------------+
  | iMAX3 Parameters                                                  |
  +-------------------------------------------------------------------+*/

extern string   _0               = "Select Mode";
extern bool     iMAXmode         = true;
extern bool     hpMode           = false;
extern bool     hpxMode          = false;
extern string   _1               = "";

extern string   _2               = "Display on chart";
extern bool     iMAXPhases       = true;
extern bool     hpPhases         = false;
extern bool     hpxPhases        = false;
extern string   _3               = "";

extern string   _4               = "Amplitude shift for hp modes.";
extern string   _5               = "0.0 = Use internal presets.";
extern double   Ph1stepHPmodes   = 0.0;

extern string   _6               = "";
extern color    hpxPh1color      = Lime;
extern color    hpxPh2color      = HotPink;

extern string   _7               = "";
extern color    hpPh1color       = White;
extern color    hpPh2color       = Orange;

extern string   _8               = "";
extern color    iMAXph1color     = Aqua;
extern color    iMAXph2color     = Red;

double iMAX0[],iMAX1[],hp0[],hp1[],hpx0[],hpx1[],Ph1step,x,xhp0,xhp1;

int    MinBars,c,countedBars;
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
/*+-------------------------------------------------------------------+
  | iMAX3 Initialization                                              |
  +-------------------------------------------------------------------+*/

int init()
  {
   IndicatorBuffers(6);

   if(hpxMode)
     {
      SetIndexBuffer(0,hpx0);
      SetIndexBuffer(1,hpx1);
      if(hpxPhases)
        {
         SetIndexStyle(0,DRAW_LINE,STYLE_SOLID,1,hpxPh1color);
         SetIndexStyle(1,DRAW_LINE,STYLE_SOLID,1,hpxPh2color);
        }
      else
        {
         SetIndexStyle(0,DRAW_NONE);
         SetIndexStyle(1,DRAW_NONE);
        }
     }

   if(hpMode)
     {
      SetIndexBuffer(2,hp0);
      SetIndexBuffer(3,hp1);
      if(hpPhases)
        {
         SetIndexStyle(2,DRAW_LINE,STYLE_SOLID,1,hpPh1color);
         SetIndexStyle(3,DRAW_LINE,STYLE_SOLID,1,hpPh2color);
        }
      else
        {
         SetIndexStyle(2,DRAW_NONE);
         SetIndexStyle(3,DRAW_NONE);
        }
     }

   SetIndexBuffer(4,iMAX0);
   SetIndexBuffer(5,iMAX1);
   if(iMAXmode && iMAXPhases)
     {
      SetIndexStyle(4,DRAW_LINE,STYLE_SOLID,1,iMAXph1color);
      SetIndexStyle(5,DRAW_LINE,STYLE_SOLID,1,iMAXph2color);
     }
   else
     {
      SetIndexStyle(4,DRAW_NONE);
      SetIndexStyle(5,DRAW_NONE);
     }

   if(hpMode || hpxMode)
     {
      if(Ph1stepHPmodes==0.0)
        {
         switch(Period())
           {
            case 1:     Ph1step=0.0001;  break;
            case 5:     Ph1step = 0.00015; break;
            case 15:    Ph1step = 0.0003;  break;
            case 30:    Ph1step = 0.0005;  break;
            case 60:    Ph1step = 0.00075; break;
            case 240:   Ph1step = 0.0015;  break;
            case 1440:  Ph1step = 0.003;   break;
            case 10080: Ph1step = 0.005;   break;
            case 43200: Ph1step=0.01;    break;
           }
        }
      else
        {Ph1step=Ph1stepHPmodes;}
     }

   MinBars=20;

   IndicatorShortName("iMAX3");

   return (0);
  } // int init()
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
/*+-------------------------------------------------------------------+
  | iMAX3 Main cycle                                                  |
  +-------------------------------------------------------------------+*/

int start()
  {
   if(Bars<=MinBars){return(0);}

   int counted_bars = IndicatorCounted();
   if(counted_bars < 0)  return(-1);
   if(counted_bars > 0)   counted_bars--;
   int limit = Bars - counted_bars;
   if(counted_bars==0) limit-=1+3;

   x     = 0.5;
   c     = limit;

   while(c>=0)
     {
      if(hpxMode)
        {
         hpx1[c]=(0.13785 *(2 *((High[c]+Low[c])*x) -((High[c+1]+Low[c+1])*x)))
                 + (0.0007  * (2 * ((High[c+1] + Low[c+1]) * x) - ((High[c+2] + Low[c+2]) * x)))
                 + (0.13785 * (2 * ((High[c+2] + Low[c+2]) * x) - ((High[c+3] + Low[c+3]) * x)))
                 + (1.2103  * hpx0[c + 1] - 0.4867 * hpx0[c + 2]);
         if(Close[c]>hpx1[c])
           {hpx0[c]=hpx1[c]+Ph1step;}
         if(Close[c]<hpx1[c])
           {hpx0[c]=hpx1[c]-Ph1step;}
        }

      if(iMAXmode || hpMode)
        {
         iMAX0[c]=(0.13785 *(2 *((High[c]+Low[c])*x) -((High[c+1]+Low[c+1])*x)))
                  + (0.0007  * (2 * ((High[c+1] + Low[c+1]) * x) - ((High[c+2] + Low[c+2]) * x)))
                  + (0.13785 * (2 * ((High[c+2] + Low[c+2]) * x) - ((High[c+3] + Low[c+3]) * x)))
                  + (1.2103  * iMAX0[c + 1] - 0.4867 * iMAX0[c + 2]);
         xhp0=iMAX0[c];
         iMAX1[c]=iMAX0[c+1];
        }

      if(hpMode)
        {
         if(Close[c]>iMAX0[c])
           {xhp1=iMAX0[c]+Ph1step;}
         if(Close[c]<iMAX0[c])
           {xhp1=iMAX0[c]-Ph1step;}
         hp0[c]=xhp1;hp1[c]=xhp0;
        }

      c--;
     } // while(c >= 0)

   return (0);
  } // int start()

/*+-------------------------------------------------------------------+
  | End iMAX3 Main cycle                                              |
  +-------------------------------------------------------------------+*/
//+------------------------------------------------------------------+
