//+------------------------------------------------------------------+
//|                                       SilverTrend_CrazyChart.mq5 |
//|                                     Copyright  2006, CrazyChart |
//|                                                  http://viac.ru/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, CrazyChart"
#property link "http://viac.ru/"
//---   
#property version   "1.00"
//---     
#property indicator_chart_window 
//---    2
#property indicator_buffers 2 
//---    
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//---      
#property indicator_type1   DRAW_FILLING
//---     
#property indicator_color1  clrDodgerBlue,clrOrchid
//---   
#property indicator_label1  "SilverTrend_CrazyChart"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint SSP=7;
input double Kmin = 1.6;
input double Kmax = 50.6;
//+----------------------------------------------+
//---   ,   
//---      
double ExtABuffer[],ExtBBuffer[];
//---      
int  min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---     
   min_rates_total=int(2*SSP);
//---      
   SetIndexBuffer(0,ExtABuffer,INDICATOR_DATA);
//---       
   ArraySetAsSeries(ExtABuffer,true);
//---      
   SetIndexBuffer(1,ExtBBuffer,INDICATOR_DATA);
//---       
   ArraySetAsSeries(ExtBBuffer,true);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"SilverTrend_CrazyChart");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
//---    
   int limit,bar;
   double SsMax,SsMin,smin,smax;
//---         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
//---     
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      for(bar=rates_total-1; bar>=limit && !IsStopped(); bar--)
        {
         ExtBBuffer[bar]=0.0;
         ExtABuffer[bar]=0.0;
        }
     }
   else limit=rates_total-prev_calculated+int(SSP); //      
//---    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      SsMax=high[ArrayMaximum(high,bar,SSP)];
      SsMin=low[ArrayMinimum(low,bar,SSP)];
      smin=NormalizeDouble((SsMin-(SsMax-SsMin)*Kmin/100),_Digits);
      smax=NormalizeDouble((SsMax-(SsMax-SsMin)*Kmax/100),_Digits);
      int barx=bar-int(SSP)-1;
      if(barx>=0) ExtBBuffer[barx]=smax;
      ExtABuffer[bar]=smax;
     }
//---    
   return(rates_total);
  }
//+------------------------------------------------------------------+
