//+------------------------------------------------------------------+
//|                                                DS_Stochastic.mq5 |
//|                      Copyright  2006, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2004, MetaQuotes Software Corp."
#property link "http://www.metaquotes.net/"
//---   
#property version   "1.00"
//---     
#property indicator_separate_window 
//---    2
#property indicator_buffers 2 
//---    
#property indicator_plots   1
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//---      
#property indicator_type1   DRAW_FILLING
//---     
#property indicator_color1  clrYellowGreen,clrDeepPink
//---   
#property indicator_label1  "DS_Stochastic"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 70.0
#property indicator_level2 50.0
#property indicator_level3 30.0
#property indicator_levelcolor clrGray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|   CXMA                         |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//---    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2,XMA3,XMA4;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint qPeriod=13;                       //   
input Smooth_Method rMethod=MODE_EMA;        //   1
input uint rPeriod=32;                       //   1
input int rPhase=15;                         //   1
//---  JJMA    -100 ... +100,     ;
input Smooth_Method fMethod=MODE_EMA;        //   2
input uint fPeriod=5;                        //   2
input int fPhase=15;                         //   2
//---  JJMA    -100 ... +100,     ;
//+----------------------------------------------+
//---   ,   
//---      
double ExtABuffer[],ExtBBuffer[];
//---      
int  min_rates_1,min_rates_2,min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---     
   min_rates_1=int(qPeriod);
   min_rates_2=min_rates_1+XMA1.GetStartBars(rMethod,rPeriod,rPhase);
   min_rates_total=min_rates_2+XMA1.GetStartBars(fMethod,fPeriod,fPhase);
//---      
   SetIndexBuffer(0,ExtABuffer,INDICATOR_DATA);
//---       
   ArraySetAsSeries(ExtABuffer,true);
//---      
   SetIndexBuffer(1,ExtBBuffer,INDICATOR_DATA);
//---       
   ArraySetAsSeries(ExtBBuffer,true);
//---      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"DS_Stochastic");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
//---    
   int limit,bar,maxbar1,maxbar2;
   double HH,LL,DIF1,DIF2,CH,RN,XDIF1,XDIF2;
//---         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);
//---   
   maxbar1=rates_total-min_rates_1-1;
   maxbar2=rates_total-min_rates_2-1;
//---     
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=maxbar1; //      
     }
   else limit=rates_total-prev_calculated; //      
//---    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      HH=high[ArrayMaximum(high,bar,qPeriod)];
      LL=low[ArrayMinimum(low,bar,qPeriod)];
      CH=close[bar]-LL;
      RN=HH-LL;
      DIF1=XMA1.XMASeries(maxbar1,prev_calculated,rates_total,rMethod,rPhase,rPeriod,CH,bar,true);
      DIF2=XMA2.XMASeries(maxbar1,prev_calculated,rates_total,rMethod,rPhase,rPeriod,RN,bar,true);
      if(DIF2) ExtABuffer[bar]=100*DIF1/DIF2;
      else ExtABuffer[bar]=100.0;
      XDIF1=XMA3.XMASeries(maxbar2,prev_calculated,rates_total,fMethod,fPhase,fPeriod,DIF1,bar,true);
      XDIF2=XMA4.XMASeries(maxbar2,prev_calculated,rates_total,fMethod,fPhase,fPeriod,DIF2,bar,true);
      if(XDIF2) ExtBBuffer[bar]=100*XDIF1/XDIF2;
      else ExtBBuffer[bar]=100.0;
     }
//---    
   return(rates_total);
  }
//+------------------------------------------------------------------+
