//+------------------------------------------------------------------+
//|                                    nCalculate_Lot_by_Percent.mq5 |
//|                                                            NoVak |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "NoVak"
#property link      "https://www.mql5.com"
#property version   "1.00"
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
{
  
   Calculate_Lot_by_Percent(2, 1.23456);

}
//+------------------------------------------------------------------+


double Calculate_Lot_by_Percent(double percent_value, double sl_price)
{
   //--- Check if the percentage is entered in the input field
   if(percent_value == 0) 
      return 0;
   
   //--- Checking if there is a Stop Loss price
   if(sl_price == 0) 
      return 0;
      
   //--- We reset the variables for further calculations
   double volume   = 0;
   double lot      = 0;
   double sl_point = 0;
  
   //--- We will learn about the deposit and the symbol we will trade on
   double balance       = AccountInfoDouble(ACCOUNT_MARGIN_FREE);
   double contract_size = SymbolInfoDouble(Symbol(), SYMBOL_TRADE_CONTRACT_SIZE);
   double max_lot       = SymbolInfoDouble(Symbol(), SYMBOL_VOLUME_MAX);
   double min_lot       = SymbolInfoDouble(Symbol(), SYMBOL_VOLUME_MIN);
   double ask           = SymbolInfoDouble(Symbol(), SYMBOL_ASK);
   double bid           = SymbolInfoDouble(Symbol(), SYMBOL_BID);
   
   //--- If there are no prices, we stop the process
   if(ask == 0 || bid == 0) 
      return 0;
      
   //--- Check where the Stop Loss price is located
   if(ask > sl_price)      sl_point = ask - sl_price;
   else if(bid < sl_price) sl_point = sl_price - bid;
   
   //--- If you can't calculate the stop points, stop the process
   if(sl_point == 0) 
      return 0;
   
   //--- Checking which symbol is being traded on
   switch(StringFind(Symbol(), "USD"))
     {
         //--- Currencies USDCAD, USDJPY, and so on (dollar first)
         case  0:
            volume = (balance * (percent_value / 100) * sl_price) / sl_point;
            lot    = volume / contract_size;
         break;
         
         //--- Currencies with the dollar in second place. EURUSD, AUDUSD, and so on
         default:
            volume = (balance * (percent_value / 100)) / sl_point;  
            lot    = volume / contract_size;
         break;
     }
     
   //--- If the lot is less than or equal to zero, stop the process
   if(lot <= 0) 
      return 0;
      
   //--- If the lot goes beyond the broker's permission, stop the process
   if(lot < min_lot && lot > max_lot)
      return 0;
   
   //--- If everything goes well, we receive the lot
   return NormalizeDouble((lot - 0.01), 2);
}