//+------------------------------------------------------------------+
//|                                       Test_StochasticOnArray.mq5 |
//|                                                          Integer |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"

#property indicator_separate_window
#property indicator_minimum 0
#property indicator_maximum 100
#property indicator_buffers 5
#property indicator_plots   2
//--- plot Label1
#property indicator_label1  "Label1"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- plot Label2
#property indicator_label2  "Label2"
#property indicator_type2   DRAW_LINE
#property indicator_color2  clrYellow
#property indicator_style2  STYLE_SOLID
#property indicator_width2  1

input int            STPeriodK   =  5;
input int            STPeriodD   =  3;
input int            STPeriodS   =  3;
input ENUM_MA_METHOD STMethod    =  MODE_SMA;

//--- indicator buffers
double         MBuffer[];
double         SBuffer[];
double         DataClose[];
double         DataHigh[];
double         DataLow[];
#include <IncOnArray/IncStochasticOnArray.mqh>
CStochasticOnArray st;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   st.Init(STPeriodK,STPeriodD,STPeriodS,STMethod);

//--- indicator buffers mapping
   SetIndexBuffer(0,MBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,SBuffer,INDICATOR_DATA);

   SetIndexBuffer(2,DataClose,INDICATOR_CALCULATIONS);
   SetIndexBuffer(3,DataHigh,INDICATOR_CALCULATIONS);
   SetIndexBuffer(4,DataLow,INDICATOR_CALCULATIONS);

   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,st.BarsRequiredMain());
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,st.BarsRequiredSignal());

   PlotIndexSetString(0,PLOT_LABEL,st.Name()+" Main");
   PlotIndexSetString(1,PLOT_LABEL,st.Name()+" Signal");
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const int begin,
                const double &price[])
  {
   int start;
   if(prev_calculated>0)
     {
      start=prev_calculated-1;
     }
   else
     {
      start=0;
     }
   for(int i=start;i<rates_total;i++)
     {
      DataClose[i]=price[i];
      DataHigh[i]=price[i];
      DataLow[i]=price[i];
     }

   st.Solve(rates_total,prev_calculated,DataClose,DataHigh,DataLow,MBuffer,SBuffer);

   return(rates_total);
  }
//+------------------------------------------------------------------+
