//+------------------------------------------------------------------+
//|                                         IncStochasticOnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int            STPeriodK   =  5;
   input int            STPeriodD   =  3;
   input int            STPeriodS   =  3;
   input ENUM_MA_METHOD STMethod    =  MODE_SMA;

   Declaration:
   #include <IncOnArray/IncStochasticOnArray.mqh>
   CStochasticOnArray st;
      
   In OnInit:
   st.Init(STPeriodK,STPeriodD,STPeriodS,STMethod);

   In OnCalculate:
   st.Solve(rates_total,prev_calculated,DataClose,DataHigh,DataLow,MBuffer,SBuffer);
    
*/

#include <IncOnArray/IncMAOnArray.mqh>
//+------------------------------------------------------------------+
//| CStochasticOnArray                                               |
//+------------------------------------------------------------------+
class CStochasticOnArray
  {
private:
   int               m_PeriodK;
   int               m_PeriodD;
   int               m_PeriodS;
   double            m_RingMax[];
   double            m_RingMin[];
   double            m_RingData[];
   CMAOnArray        m_ma;
   string            m_Name;
   int               m_brm;
   int               m_brs;
public:
   void Init(int aPeriodK=5,int aPeriodD=3,int aPeriodS=3,ENUM_MA_METHOD aDMethod=MODE_SMA)
     {
      m_PeriodK=aPeriodK;
      m_PeriodD=aPeriodD;
      m_PeriodS=aPeriodS;
      ArrayResize(m_RingMax,m_PeriodS);
      ArrayResize(m_RingMin,m_PeriodS);
      ArrayResize(m_RingData,m_PeriodS);
      m_ma.Init(aPeriodD,aDMethod);
      m_Name="Stochastic("+IntegerToString(aPeriodK)+","+m_ma.Name()+","+IntegerToString(aPeriodS)+")";
      m_brm=m_PeriodK+m_PeriodS-1;
      m_brs=m_ma.BarsRequired()+m_PeriodK+m_PeriodS-2;
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aDataClose[],
              double  &aDataHigh[],
              double  &aDataLow[],
              double  &aStochMain[],
              double  &aStochSignal[])
     {
      int Start=0;
      if(aPrevCalc==0)
        {
         int ds=0;
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aDataClose[i]!=0 && aDataClose[i]!=EMPTY_VALUE && aDataHigh[i]!=0 && aDataHigh[i]!=EMPTY_VALUE && aDataLow[i]!=0 && aDataLow[i]!=EMPTY_VALUE)
              {
               ds=i;
               break;
              }
           }
         int Start0=ds+m_PeriodK-1;
         Start=ds+m_PeriodK+m_PeriodS-2;
         for(int i=Start0;i<Start;i++)
           {
            int ii=i%m_PeriodS;
            m_RingMax[ii]=aDataHigh[ArrayMaximum(aDataHigh,i-m_PeriodK+1,m_PeriodK)];
            m_RingMin[ii]=aDataLow[ArrayMinimum(aDataLow,i-m_PeriodK+1,m_PeriodK)];
            m_RingData[ii]=aDataClose[i];
           }
        }
      else
        {
         Start=aPrevCalc-1;
        }
      for(int i=Start;i<aRatesTotal;i++)
        {
         int ii=i%m_PeriodS;
         m_RingMax[ii]=aDataHigh[ArrayMaximum(aDataHigh,i-m_PeriodK+1,m_PeriodK)];
         m_RingMin[ii]=aDataLow[ArrayMinimum(aDataLow,i-m_PeriodK+1,m_PeriodK)];
         m_RingData[ii]=aDataClose[i];
         double Sum1=0;
         double Sum2=0;
         for(int j=0;j<m_PeriodS;j++)
           {
            Sum1+=(m_RingMax[j]-m_RingMin[j]);
            Sum2+=(m_RingData[j]-m_RingMin[j]);
           }
         if(Sum1==0)
           {
            aStochMain[i]=100.0;
           }
         else
           {
            aStochMain[i]=100.0*Sum2/Sum1;
           }
        }
      m_ma.Solve(aRatesTotal,aPrevCalc,aStochMain,aStochSignal);
     }
   int BarsRequiredSignal()
     {
      return(m_brs);
     }
   int BarsRequiredMain()
     {
      return(m_brm);
     }
   string Name()
     {
      return(m_Name);
     }
   string About()
     {
      return("Integer's StochasticOnArray class. https://login.mql5.com/en/users/Integer");
     }
  };
//+------------------------------------------------------------------+
