#include "timer.mqh"
#include "index.mqh"

void OnInit() {
    new Promise(printAndTimoutResolve, "111")
        .then(printAndReject, "222") // then - run if prev promise is resolved
        .ccatch(printAndResolve, "333") // ccatch - run if prev promise is rejected
        .ccatch(printAndResolve, "444")
        .ccatch(printAndResolve, "555")
        .then(printAndResolve, "666")
        .finally(printAndResolve, "end") // finally - run anything
        .destroy(); // clear memory theese promises after execution all promises

    Print("start");

    // printAndTimoutResolve 111
    // start
    // printAndReject 222
    // printAndTimoutResolve 333
    // printAndTimoutResolve 666
    // printAndTimoutResolve end


    Promise* list1[] = {
        new Promise(printAndTimoutResolve, "Promise 1")
            .then(printAndTimoutResolve, "Promise 1.1")
        ,
        new Promise(printAndReject, "Promise 2"),
        new Promise(printAndTimoutResolve, "Promise 3"),
    };

    Promise::all(list1, promiseAllResolve)
        .then(printAndResolve, "Promise::all resolved")
        .ccatch(printAndResolve, "Promise::all rejected")
        .destroy();


    Promise* list2[] = {
        new Promise(printAndTimoutResolve, "Promise 1")
            .then(printAndTimoutResolve, "Promise 1.1")
        ,
        new Promise(printAndReject, "Promise 2"),
        new Promise(printAndTimoutResolve, "Promise 3"),
    };

    Promise::race(list2, printAndResolve, "Promise::race")
        .then(printAndResolve, "Promise::race resolved")
        .ccatch(printAndResolve, "Promise::race rejected")
        .destroy();


    Promise* list3[] = {
        new Promise(printAndTimoutResolve, "Promise 1")
            .then(printAndTimoutResolve, "Promise 1.1")
        ,
        new Promise(printAndReject, "Promise 2"),
        new Promise(printAndTimoutResolve, "Promise 3"),
    };

    Promise::any(list3, printAndResolve, "Promise::any")
        .then(printAndResolve, "Promise::any resolved")
        .ccatch(printAndResolve, "Promise::any rejected")
        .destroy();
};

void promiseAllResolve(ulong promiseId, string &prevResult[], string parametr) {
    Print("promiseAllResolve " + parametr);
};

void printAndTimoutResolve(ulong promiseId, string prevResult, string parametr) {
    Print("printAndTimoutResolve " + parametr);
    Timer::setTimout(resolveByIdStr, 2000, string(promiseId));
};
void resolveByIdStr(string id) { Promise::resolveById(ulong(id)); }

void printAndResolve(ulong promiseId, string prevResult, string parametr) {
    Print("printAndResolve " + parametr);
    Promise::resolveById(promiseId);
};

void printAndReject(ulong promiseId, string prevResult, string parametr) {
    Print("printAndReject " + parametr);
    Promise::rejectById(promiseId);
};