//+------------------------------------------------------------------+
//|                                                   CSyncEvent.mqh |
//|                                     Copyright 2017, S.Aukscionis |
//+------------------------------------------------------------------+
#property copyright "2017, S.Aukscionis"
#property strict

#define INFINITE                   0xFFFFFFFF 
#define MANUAL_RESET               true
#define INITIAL_STATE_NONSIGNALED  false
#define ONLY_ONE_STATE_CHANGED     false

#import "kernel32.dll"

int CreateEventW(int lpEventAttributes,int bManualReset,int bInitialState,string lpName);
int SetEvent(int hEvent);
int ResetEvent(int hEvent);
int CloseHandle(int hObject);
int WaitForMultipleObjects(uint nCount,int &lpHandles[],int bWaitAll,uint dwMilliseconds);
int GetLastError();

#import
//+------------------------------------------------------------------+
//| Class CSyncEvent                                                 |
//+------------------------------------------------------------------+ 
class CSyncEvent
  {
   int               m_handle;
   bool              m_result;

public:
                     CSyncEvent() { m_handle=NULL; m_result=false; };
                    ~CSyncEvent() {};

public:
   int Create(string m_path) { m_handle=CreateEventW(NULL,MANUAL_RESET,INITIAL_STATE_NONSIGNALED,m_path); return(m_handle); }
   bool Set() { m_result=SetEvent(m_handle); return(m_result); }
   bool Reset() { m_result=ResetEvent(m_handle); return(m_result); }
   bool Destroy() { m_result=CloseHandle(m_handle); return(m_result); }
  };
//+------------------------------------------------------------------+
//| Class CSyncEventState                                            |
//+------------------------------------------------------------------+  
class CSyncEventState
  {
   int               m_index;

public:
                     CSyncEventState() { m_index=NULL; }
                    ~CSyncEventState() {};

public:
   int Get(int &m_handles[])
     { m_index=WaitForMultipleObjects(ArraySize(m_handles),m_handles,ONLY_ONE_STATE_CHANGED,INFINITE); return(m_index); }

  };
//------------------------------------------------------------------
