// MQL4&5-code

// #define PROFILER_OnTick //      OnTick -    
#include <TesterBenchmark.mqh>

//   include-  ,       MQL5 -  API
//  -  ,   API-  .
// TesterBench ,     ( ) API.
//#include <MT4Orders.mqh> // https://www.mql5.com/ru/code/16006
//#include <Trade\Trade.mqh>

input int Interval = 60;
input int AmountLastDeals = 5;
input double Lots = 1;

double CorrectLot( const double Lot )
{
  static const double StepVol = SymbolInfoDouble(_Symbol, SYMBOL_VOLUME_STEP);
  static const double MaxVol = SymbolInfoDouble(_Symbol, SYMBOL_VOLUME_MAX);
  static const double MinVol = SymbolInfoDouble(_Symbol, SYMBOL_VOLUME_MIN);

  const double Vol = StepVol * (int)(Lot / StepVol + 0.5);

  return((Vol < MinVol) ? MinVol : ((Vol > MaxVol) ? MaxVol : Vol));
}

#ifdef __MQL4__
  #property strict

  #define __MT4ORDERS__
#endif // __MQL4__

void OnTick()
{
#ifdef __MT4ORDERS__  // MT4Orders.mqh
  if (!OrderSelect(0, SELECT_BY_POS))
  {
    const int Total = OrdersHistoryTotal() - 1;

    double SumProfit = 0;
    double SumLots = 0;

    for (int i = Total, Count = 0; (i >= 0) && (Count < AmountLastDeals); i--)
      if (OrderSelect(i, SELECT_BY_POS, MODE_HISTORY) && (OrderType() <= OP_SELL))
      {
        SumProfit += OrderProfit() * (AmountLastDeals - Count);
        SumLots += OrderLots() * (AmountLastDeals - Count);

        Count++;
      }

    SumLots /= (AmountLastDeals * (1 + AmountLastDeals)) >> 1;

    const int Type = (Total >= 0) && OrderSelect(Total, SELECT_BY_POS, MODE_HISTORY) && (OrderType() == OP_BUY) ? OP_SELL : OP_BUY;

    OrderSend(_Symbol, Type, (SumProfit >= 0) ? Lots : CorrectLot(SumLots),
              SymbolInfoDouble(_Symbol, (Type == OP_BUY) ? SYMBOL_ASK : SYMBOL_BID), 0, 0, 0); // , NULL, 0, 0, INT_MIN);
  }
  else if (TimeCurrent() - OrderOpenTime() >= Interval)
    OrderClose(OrderTicket(), OrderLots(), OrderClosePrice(), 0);
#else  // __MT4ORDERS__
  #ifdef  ERR_USER_INVALID_HANDLE // Trade.mqh
  static CTrade Trade;
  static CDealInfo Deal;
  static CPositionInfo Position;

  if (!Position.SelectByIndex(0))
  {
    if (HistorySelect(0, TimeCurrent()))
    {
      const int Total = HistoryDealsTotal() - 1;

      double SumProfit = 0;
      double SumLots = 0;

      for (int i = Total, Count = 0; (i >= 0) && (Count < AmountLastDeals); i--)
        if (Deal.SelectByIndex(i) && (Deal.Entry() == DEAL_ENTRY_OUT))
        {
          SumProfit += Deal.Profit() * (AmountLastDeals - Count);
          SumLots += Deal.Volume() * (AmountLastDeals - Count);

          Count++;
        }

      SumLots /= (AmountLastDeals * (1 + AmountLastDeals)) >> 1;

      if ((Total >= 0) && Deal.SelectByIndex(Total) && (Deal.DealType() == DEAL_TYPE_SELL))
        Trade.Sell((SumProfit >= 0) ? Lots : CorrectLot(SumLots));
      else
        Trade.Buy((SumProfit >= 0) ? Lots : CorrectLot(SumLots));
    }
  }
  else if (TimeCurrent() - Position.Time() >= Interval)
    Trade.PositionClose(_Symbol);
#else  // ERR_USER_INVALID_HANDLE
  if (!PositionGetTicket(0))
  {
    if (HistorySelect(0, TimeCurrent()))
    {
      const int Total = HistoryDealsTotal() - 1;

      double SumProfit = 0;
      double SumLots = 0;

      for (int i = Total, Count = 0; (i >= 0) && (Count < AmountLastDeals); i--)
      {
        const ulong Ticket = HistoryDealGetTicket(i);

        if ((ENUM_DEAL_ENTRY)HistoryDealGetInteger(Ticket, DEAL_ENTRY) == DEAL_ENTRY_OUT)
        {
          SumProfit += HistoryDealGetDouble(Ticket, DEAL_PROFIT) * (AmountLastDeals - Count);
          SumLots += HistoryDealGetDouble(Ticket, DEAL_VOLUME) * (AmountLastDeals - Count);

          Count++;
        }
      }

      SumLots /= (AmountLastDeals * (1 + AmountLastDeals)) >> 1;

      MqlTradeRequest Request = {0};

      Request.action = TRADE_ACTION_DEAL;

      Request.symbol = _Symbol;
      Request.type = ((Total >= 0) && ((ENUM_DEAL_TYPE)HistoryDealGetInteger(HistoryDealGetTicket(Total), DEAL_TYPE) == DEAL_TYPE_SELL)) ?
                     ORDER_TYPE_SELL : ORDER_TYPE_BUY;;

      Request.volume = (SumProfit >= 0) ? Lots : CorrectLot(SumLots);
      Request.price = SymbolInfoDouble(Request.symbol, (Request.type == ORDER_TYPE_BUY) ? SYMBOL_ASK : SYMBOL_BID);

//      MqlTradeCheckResult CheckResult;
//      if (OrderCheck(Request, CheckResult))
      {
        MqlTradeResult Result;

        const bool AntiWarning = OrderSend(Request, Result);
      }
    }
  }
  else if (TimeCurrent() - PositionGetInteger(POSITION_TIME) >= Interval)
  {
    MqlTradeRequest Request = {0};
    MqlTradeResult Result;

    Request.action = TRADE_ACTION_DEAL;
    Request.position = PositionGetInteger(POSITION_TICKET);

    Request.symbol = PositionGetString(POSITION_SYMBOL);
    Request.type = (ENUM_ORDER_TYPE)(1 - PositionGetInteger(POSITION_TYPE));

    Request.volume = PositionGetDouble(POSITION_VOLUME);
    Request.price = PositionGetDouble(POSITION_PRICE_CURRENT);

    const bool AntiWarning = OrderSend(Request, Result);
  }
  #endif // ERR_USER_INVALID_HANDLE
#endif // __MT4ORDERS__
}
