//+------------------------------------------------------------------+
//|                                                time_in_range.mq4 |
//|                                               Alexander Sinitsyn |
//|                              https://www.mql5.com/en/users/wongv |
//+------------------------------------------------------------------+
#property library
#property copyright "Alexander Sinitsyn"
#property link      "https://www.mql5.com/en/users/wongv"
#property version   "1.00"
#property strict
//+------------------------------------------------------------------+
//| TimeInRange function with separated hours and minutes input      |
//|                                                                  |
//| usage: if(TimeInRange(TimeCurrent(),23,00,02,15) { ... }         |
//|   checks if current time in range 23:00-02:15                    |
//+------------------------------------------------------------------+
bool TimeInRange(datetime time,int hours_from,int minutes_from,int hours_to,int minutes_to)
  {
   int range_from=hours_from*60+minutes_from;
   int range_to=hours_to*60+minutes_to;
   int ttc=(int)((time/60)%1440);

   return range_from>range_to?(ttc>=range_from || ttc<=range_to):(ttc>=range_from && ttc<=range_to);
  }
//+------------------------------------------------------------------+
//| TimeInRange function with fractional hours input                 |
//|                                                                  |
//| usage: if(TimeInRange(TimeCurrent(),05.50,09.25) { ... }         |
//|   checks if current time in range 05:30-09:15                    |
//|   ! please note that fractional part represents whole hour!      |
//+------------------------------------------------------------------+
bool TimeInRange(datetime time,double hours_from,double hours_to)
  {
   int range_from=(int)(hours_from*60);
   int range_to=(int)(hours_to*60);
   int ttc=(int)((time/60)%1440);

   return range_from>range_to?(ttc>=range_from || ttc<=range_to):(ttc>=range_from && ttc<=range_to);
  }
//+------------------------------------------------------------------+
//| TimeInRange function with time coded in single variable          |
//|                                                                  |
//| usage: if(TimeInRange(TimeCurrent(),0200,0835) { ... }           |
//|   checks if current time in range 02:00-08:35                    |
//+------------------------------------------------------------------+
bool TimeInRange(datetime time,int from,int to)
  {
   from=from>2359?2359:from;
   int hours_from=from/100;
   int minutes_from=from%100;
   hours_from+=minutes_from>=60?1:0;
   minutes_from=minutes_from>=60?0:minutes_from;
   hours_from=hours_from>=24?23:hours_from;

   to=to>2359?2359:to;
   int hours_to=to/100;
   int minutes_to=to%100;
   hours_to+=minutes_to>=60?1:0;
   minutes_to=minutes_to>=60?0:minutes_to;
   hours_to=hours_to>=24?23:hours_to;

   int range_from=hours_from*60+minutes_from;
   int range_to=hours_to*60+minutes_to;
   int ttc=(int)((time/60)%1440);

   return range_from>range_to?(ttc>=range_from || ttc<=range_to):(ttc>=range_from && ttc<=range_to);

  }
//+------------------------------------------------------------------+
