//+------------------------------------------------------------------+
//|                                                     T3Taotra.mq5 |
//|                         MQL5: Copyright  2010, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+
//|      SmoothAlgorithms.mqh                 |
//|    : __\\MQL5\Include |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----   
#property version   "1.10"
//----     
#property indicator_separate_window
//----    6
#property indicator_buffers 6 
//----   6  
#property indicator_plots   6
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----  
#property indicator_color1 clrYellow
#property indicator_color2 clrRed
#property indicator_color3 clrMagenta
#property indicator_color4 clrAqua
#property indicator_color5 clrLimeGreen
#property indicator_color6 clrBlue
//----     
#property indicator_type1 DRAW_LINE
#property indicator_type2 DRAW_LINE
#property indicator_type3 DRAW_LINE
#property indicator_type4 DRAW_LINE
#property indicator_type5 DRAW_LINE
#property indicator_type6 DRAW_LINE
//----   -  
#property indicator_style1 STYLE_SOLID
#property indicator_style2 STYLE_SOLID
#property indicator_style3 STYLE_SOLID
#property indicator_style4 STYLE_SOLID
#property indicator_style5 STYLE_SOLID
#property indicator_style6 STYLE_SOLID
//----     1
#property indicator_width1 1
#property indicator_width2 1
#property indicator_width3 1
#property indicator_width4 1
#property indicator_width5 1
#property indicator_width6 1
//----   
#property indicator_label1  "T3Taotra1"
#property indicator_label2  "T3Taotra2" 
#property indicator_label3  "T3Taotra3" 
#property indicator_label4  "T3Taotra4" 
#property indicator_label5  "T3Taotra5" 
#property indicator_label6  "T3Taotra6" 
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ //  
  {
   PRICE_CLOSE_ = 1,     //PRICE_CLOSE
   PRICE_OPEN_,          //PRICE_OPEN
   PRICE_HIGH_,          //PRICE_HIGH
   PRICE_LOW_,           //PRICE_LOW
   PRICE_MEDIAN_,        //PRICE_MEDIAN
   PRICE_TYPICAL_,       //PRICE_TYPICAL
   PRICE_WEIGHTED_,      //PRICE_WEIGHTED
   PRICE_SIMPL_,         //PRICE_SIMPL
   PRICE_QUARTER_,       //PRICE_QUARTER
   PRICE_TRENDFOLLOW0_,  //PRICE_TRENDFOLLOW0
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input int T3_Period_1 = 3; //   1
input int T3_Period_2 = 5; //   2
input int T3_Period_3 = 8; //   3
input int T3_Period_4 = 12;//   4
input int T3_Period_5 = 21;//   5
input int T3_Period_6 = 34;//   6
input int Smooth_Curvature=100;
input  Applied_price_  IPC=PRICE_CLOSE_;// 
input int Shift1 = 0;  // c  1    
input int Shift2 = 0;  // c  2   
input int Shift3 = 0;  // c  3   
input int Shift4 = 0;  // c  6   
input int Shift5 = 0;  // c  5   
input int Shift6 = 0;  // c  6   
//+----------------------------------------------+
//----  
double Ind_Buffer1[];
double Ind_Buffer2[];
double Ind_Buffer3[];
double Ind_Buffer4[];
double Ind_Buffer5[];
double Ind_Buffer6[];
//+------------------------------------------------------------------+
//   iPriceSeries()                                   |
//   iPriceSeriesAlert()                              |
//    CT3                                              |
//+------------------------------------------------------------------+ 
#include <SmoothAlgorithms.mqh> 
//+------------------------------------------------------------------+   
//| T3Taotra initialization function                                 |
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----      
   SetIndexBuffer(0,Ind_Buffer1,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift1);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,1);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----      
   SetIndexBuffer(1,Ind_Buffer2,INDICATOR_DATA);
//----    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift2);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,1);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----      
   SetIndexBuffer(2,Ind_Buffer3,INDICATOR_DATA);
//----    3  
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift3);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,1);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----      
   SetIndexBuffer(3,Ind_Buffer4,INDICATOR_DATA);
//----    4  
   PlotIndexSetInteger(3,PLOT_SHIFT,Shift4);
//----      
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,1);
//----   ,      
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----      
   SetIndexBuffer(4,Ind_Buffer5,INDICATOR_DATA);
//----    5  
   PlotIndexSetInteger(4,PLOT_SHIFT,Shift5);
//----      
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,1);
//----   ,      
   PlotIndexSetDouble(4,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----      
   SetIndexBuffer(5,Ind_Buffer6,INDICATOR_DATA);
//----    6  
   PlotIndexSetInteger(5,PLOT_SHIFT,Shift6);
//----      
   PlotIndexSetInteger(5,PLOT_DRAW_BEGIN,1);
//----   ,      
   PlotIndexSetDouble(5,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----      
   string shortname;
   StringConcatenate(shortname,"T3Taotra( ",T3_Period_1,", ",T3_Period_2,", ",T3_Period_3,
                     ", ",T3_Period_4,", ",T3_Period_5,", ",T3_Period_6," )");
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+
//| T3.Taotra iteration function                                     |
//+------------------------------------------------------------------+
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<0)return(0);

//----     
   double series;

//----   
   int first,bar;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=0; //      
   else first=prev_calculated-1; //      

//----     CT3   T3Series_Cls.mqh
   static CT3 T3_[6];

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      series=PriceSeries(IPC,bar,open,low,high,close); 
      Ind_Buffer1[bar]=T3_[0].T3Series(0,prev_calculated,rates_total,0,Smooth_Curvature,T3_Period_1,series,bar,false);
      Ind_Buffer2[bar]=T3_[1].T3Series(0,prev_calculated,rates_total,0,Smooth_Curvature,T3_Period_2,series,bar,false);
      Ind_Buffer3[bar]=T3_[2].T3Series(0,prev_calculated,rates_total,0,Smooth_Curvature,T3_Period_3,series,bar,false);
      Ind_Buffer4[bar]=T3_[3].T3Series(0,prev_calculated,rates_total,0,Smooth_Curvature,T3_Period_4,series,bar,false);
      Ind_Buffer5[bar]=T3_[4].T3Series(0,prev_calculated,rates_total,0,Smooth_Curvature,T3_Period_5,series,bar,false);
      Ind_Buffer6[bar]=T3_[5].T3Series(0,prev_calculated,rates_total,0,Smooth_Curvature,T3_Period_6,series,bar,false);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
