//+------------------------------------------------------------------+ 
//|                                                     GMMA_HTF.mq5 | 
//|                               Copyright  2016, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2016, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---   
#property version   "1.00"
//----     
#property indicator_chart_window
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                                   //        
#define INDICATOR_NAME "GMMA"                     //    
#define SIZE 12                                   //      CountLine
//+----------------------------------------------+
//----    12
#property indicator_buffers SIZE 
//----     
#property indicator_plots   SIZE
//+-----------------------------------+
//|      |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----  -  
#property indicator_style1 STYLE_SOLID
//----   1
#property indicator_width1  1
//----        
#property indicator_color1 clrRed
#property indicator_color2 clrRed
#property indicator_color3 clrRed
#property indicator_color4 clrRed
#property indicator_color5 clrRed
#property indicator_color6 clrRed
//----        
#property indicator_color7 clrBlue
#property indicator_color8 clrBlue
#property indicator_color9 clrBlue
#property indicator_color10 clrBlue
#property indicator_color11 clrBlue
#property indicator_color12 clrBlue
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Smooth_Method
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;//  
input Smooth_Method xMA_Method=MODE_EMA; // 
//----
input int TrLength1=3; //  1  
input int TrLength2=5; //  2  
input int TrLength3=8; //  3  
input int TrLength4=10; //  4  
input int TrLength5=12; //  5 
input int TrLength6=15; //  6  
//----
input int InvLength1=30; //  1 
input int InvLength2=35; //  2 
input int InvLength3=40; //  3 
input int InvLength4=45; //  4 
input int InvLength5=50; //  5 
input int InvLength6=60; //  6 
//----                  
input int xPhase=100; // 
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE;// 
input int Shift=0; //      
//+----------------------------------------------+
//---   
string Symbol_,Word;
//---      
int min_rates_total;
//---      
int Ind_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+
//|                   |
//+------------------------------------------------------------------+  
class CIndicatorsBuffers
  {
public: double    IndBuffer[];
  };
//+------------------------------------------------------------------+
//|                                       |
//+------------------------------------------------------------------+
CIndicatorsBuffers Ind[SIZE];
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   if(TimeFrame<Period() && TimeFrame!=PERIOD_CURRENT)
     {
      Print("    GMMA       ");
      return(INIT_FAILED);
     }
//---   
   min_rates_total=2;
   Symbol_=Symbol();
   Word=INDICATOR_NAME+" : "+Symbol_+StringSubstr(EnumToString(_Period),7,-1);
//---    GMMA
   Ind_Handle=iCustom(Symbol_,TimeFrame,"GMMA",xMA_Method,TrLength1,TrLength2,TrLength3,TrLength4,TrLength5,TrLength6,
                      InvLength1,InvLength2,InvLength3,InvLength4,InvLength5,InvLength6,xPhase,IPC,0);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      GMMA");
      return(INIT_FAILED);
     }
   int period[SIZE];
   period[0]=TrLength1;
   period[1]=TrLength2;
   period[2]=TrLength3;
   period[3]=TrLength4;
   period[4]=TrLength5;
   period[5]=TrLength6;
   period[6]=InvLength1;
   period[7]=InvLength2;
   period[8]=InvLength3;
   period[9]=InvLength4;
   period[10]=InvLength5;
   period[11]=InvLength6;
//---
   for(int numb=0; numb<SIZE; numb++)
     {
      string shortname="";
      StringConcatenate(shortname,INDICATOR_NAME,numb,"(",period[numb],")");
      //---           
      PlotIndexSetString(numb,PLOT_LABEL,shortname);
      //----   ,      
      PlotIndexSetDouble(numb,PLOT_EMPTY_VALUE,EMPTY_VALUE);
      //----      
      PlotIndexSetInteger(numb,PLOT_DRAW_BEGIN,min_rates_total);
      //----      
      SetIndexBuffer(numb,Ind[numb].IndBuffer,INDICATOR_DATA);
      //----          
      ArraySetAsSeries(Ind[numb].IndBuffer,true);
      //----        
      PlotIndexSetInteger(numb,PLOT_DRAW_TYPE,PlotIndexGetInteger(0,PLOT_DRAW_TYPE));
      PlotIndexSetInteger(numb,PLOT_LINE_STYLE,PlotIndexGetInteger(0,PLOT_LINE_STYLE));
      PlotIndexSetInteger(numb,PLOT_LINE_WIDTH,PlotIndexGetInteger(0,PLOT_LINE_WIDTH));
     }
//---              
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME,SIZE,"(",GetStringTimeframe(TimeFrame),")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
//---         
   ArraySetAsSeries(time,true);
//---    
   for(int numb=0; numb<SIZE; numb++)
      if(!CountIndicator(numb,NULL,TimeFrame,Ind_Handle,numb,Ind[numb].IndBuffer,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//| CountLine                                                        |
//+------------------------------------------------------------------+
bool CountIndicator(uint     Numb,            //   CountLine      (  - 0)
                    string   Symb,            //  
                    ENUM_TIMEFRAMES TFrame,   //  
                    int      IndHandle,       //   
                    uint     BuffNumb,        //    
                    double&  IndBuf[],        //   
                    const datetime& iTime[],  //  
                    const int Rates_Total,    //       
                    const int Prev_Calculated,//       
                    const int Min_Rates_Total)//       
  {
//---
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---      
      IndBuf[bar]=0.0;
      //---       IndTime
      if(CopyTime(Symbol_,TimeFrame,iTime[bar],1,IndTime)<=0) return(RESET);
      //---
      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double Arr[1];
         //---       Arr
         if(CopyBuffer(IndHandle,BuffNumb,iTime[bar],1,Arr)<=0) return(RESET);
         IndBuf[bar]=Arr[0];
        }
      else IndBuf[bar]=IndBuf[bar+1];
     }
//---     
   return(true);
  }
//+------------------------------------------------------------------+
