//+---------------------------------------------------------------------+
//|                                                            GMMA.mq5 | 
//|                                Copyright  2011,   Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2011, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//----   
#property version   "1.01"
//----     
#property indicator_chart_window 
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define LINES_SIRNAME     "GMMA" //     
#define LINES_TOTAL         12   //     
#define RESET                0   //        
//+-----------------------------------+
#property description LINES_SIRNAME
//----   
#property indicator_buffers LINES_TOTAL 
//----    
#property indicator_plots   LINES_TOTAL
//+-----------------------------------+
//|      |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----  -  
#property indicator_style1 STYLE_SOLID
//----   1
#property indicator_width1  1
//----        
#property indicator_color1 clrRed
#property indicator_color2 clrRed
#property indicator_color3 clrRed
#property indicator_color4 clrRed
#property indicator_color5 clrRed
#property indicator_color6 clrRed
//----        
#property indicator_color7 clrBlue
#property indicator_color8 clrBlue
#property indicator_color9 clrBlue
#property indicator_color10 clrBlue
#property indicator_color11 clrBlue
#property indicator_color12 clrBlue
//+-----------------------------------+
//|    CXMA             |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA[LINES_TOTAL];
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input Smooth_Method xMA_Method=MODE_EMA; // 
//----
input int TrLength1=3; //  1  
input int TrLength2=5; //  2  
input int TrLength3=8; //  3  
input int TrLength4=10; //  4  
input int TrLength5=12; //  5 
input int TrLength6=15; //  6  
//----
input int InvLength1=30; //  1 
input int InvLength2=35; //  2 
input int InvLength3=40; //  3 
input int InvLength4=45; //  4 
input int InvLength5=50; //  5 
input int InvLength6=60; //  6 
//----                  
input int xPhase=100; // 
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE;// 
input int Shift=0; //      
//+-----------------------------------+
int period[LINES_TOTAL];
//----      
double dPriceShift;
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//|                   |
//+------------------------------------------------------------------+  
class CIndicatorsBuffers
  {
public: double    IndBuffer[];
  };
//+------------------------------------------------------------------+
//|                                       |
//+------------------------------------------------------------------+
CIndicatorsBuffers Ind[LINES_TOTAL];
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----        
   period[0]=TrLength1;
   period[1]=TrLength2;
   period[2]=TrLength3;
   period[3]=TrLength4;
   period[4]=TrLength5;
   period[5]=TrLength6;
   period[6]=InvLength1;
   period[7]=InvLength2;
   period[8]=InvLength3;
   period[9]=InvLength4;
   period[10]=InvLength5;
   period[11]=InvLength6;
//----
   int MaxPeriod=period[ArrayMaximum(period)];
   min_rates_total=XMA[0].GetStartBars(xMA_Method,MaxPeriod,xPhase);
//----
   for(int numb=0; numb<LINES_TOTAL; numb++)
     {
      string shortname="";
      StringConcatenate(shortname,LINES_SIRNAME,numb,"(",period[numb],")");
      //---           
      PlotIndexSetString(numb,PLOT_LABEL,shortname);
      //----   ,      
      PlotIndexSetDouble(numb,PLOT_EMPTY_VALUE,EMPTY_VALUE);
      //----      
      PlotIndexSetInteger(numb,PLOT_DRAW_BEGIN,min_rates_total);
      //----      
      SetIndexBuffer(numb,Ind[numb].IndBuffer,INDICATOR_DATA);
      //----          
      ArraySetAsSeries(Ind[numb].IndBuffer,true);
      //----        
      PlotIndexSetInteger(numb,PLOT_DRAW_TYPE,PlotIndexGetInteger(0,PLOT_DRAW_TYPE));
      PlotIndexSetInteger(numb,PLOT_LINE_STYLE,PlotIndexGetInteger(0,PLOT_LINE_STYLE));
      PlotIndexSetInteger(numb,PLOT_LINE_WIDTH,PlotIndexGetInteger(0,PLOT_LINE_WIDTH));
     }
//----      
   string shortname;
   string Smooth1=XMA[0].GetString_MA_Method(xMA_Method);
   StringConcatenate(shortname,LINES_SIRNAME,LINES_TOTAL,"(",Smooth1,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(RESET);
//----    
   int bar,limit,maxbar;
   double price_;
//----
   maxbar=rates_total-1;
//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      limit=rates_total-1; //      
   else limit=rates_total-prev_calculated; //      
//----         
   ArraySetAsSeries(open,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //----   PriceSeries     price_
      price_=PriceSeries(IPC,bar,open,low,high,close);
      //----
      for(int numb=0; numb<LINES_TOTAL; numb++)
         Ind[numb].IndBuffer[bar]=XMA[numb].XMASeries(maxbar,prev_calculated,rates_total,xMA_Method,xPhase,period[numb],price_,bar,true);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
