//+---------------------------------------------------------------------+ 
//|                                                       ColorMACD.mq5 | 
//|                                  Copyright  2011, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2011, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----   
#property version   "1.01"
//----     
#property indicator_separate_window 
//----    4
#property indicator_buffers 4 
//----     
#property indicator_plots   2
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//----      
#property indicator_color1 clrGray,clrTeal,clrDarkViolet,clrIndianRed,clrMagenta
//----   - 
#property indicator_style1 STYLE_SOLID
//----     2
#property indicator_width1 2
//----   
#property indicator_label1 "MACD"
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----      
#property indicator_type2 DRAW_COLOR_LINE
//----      
#property indicator_color2 clrGray,clrLime,clrRed
//----   -  
#property indicator_style2 STYLE_DASHDOTDOT
//----     3
#property indicator_width2 3
//----    
#property indicator_label2  "Signal Line"
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_      // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+-----------------------------------+
//|         |
//+-----------------------------------+
input int Fast_MA = 12; //    
input int Slow_MA = 26; //  SMMA 
input ENUM_MA_METHOD MA_Method_=MODE_EMA; //   
input int Signal_MA=9; //   
input ENUM_MA_METHOD Signal_Method_=MODE_EMA; //   
input Applied_price_ AppliedPrice=PRICE_CLOSE_;//  
//+-----------------------------------+
//----      
int start,macd_start=0;
//----   ,    
//----      
double MACDBuffer[],SignBuffer[],ColorMACDBuffer[],ColorSignBuffer[];
//+------------------------------------------------------------------+
//|   iPriceSeries                                    |
//|   Moving_Average                                   |
//+------------------------------------------------------------------+ 
#include <SmoothAlgorithms.mqh> 
//+------------------------------------------------------------------+    
//| MACD indicator initialization function                           | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   if(MA_Method_!=MODE_EMA) macd_start=MathMax(Fast_MA,Slow_MA);
   start=macd_start+Signal_MA+1;
//----    MACDBuffer   
   SetIndexBuffer(0,MACDBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,macd_start);
//---      DataWindow
   PlotIndexSetString(0,PLOT_LABEL,"MACD");
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----     ,     
   SetIndexBuffer(1,ColorMACDBuffer,INDICATOR_COLOR_INDEX);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,macd_start+1);

//----    SignBuffer   
   SetIndexBuffer(2,SignBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,start);
//---      DataWindow
   PlotIndexSetString(2,PLOT_LABEL,"Signal SMA");
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----     ,     
   SetIndexBuffer(3,ColorSignBuffer,INDICATOR_COLOR_INDEX);
//----      
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,start+1);

//----      
   string shortname;
   StringConcatenate(shortname,"MACD( ",Fast_MA,", ",Slow_MA,", ",Signal_MA," )");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+  
//| MACD iteration function                                          | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<start) return(0);
//----   
   int first1,first2,first3,bar;
//----       
   double price,fast_ma,slow_ma;
//----     OnCalculate()
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      first1=0; //        
      first2=macd_start+1; //        
      first3=start+1; //        
     }
   else //      
     {
      first1=prev_calculated-1;
      first2=first1;
      first3=first1;
     }
//----    CMoving_Average   MASeries_Cls.mqh
   static CMoving_Average MA1,MA2,MA3;
//----    
   for(bar=first1; bar<rates_total; bar++)
     {
      price=PriceSeries(AppliedPrice,bar,open,low,high,close);
      fast_ma = MA1.MASeries(0,prev_calculated,rates_total,Fast_MA, MA_Method_,price,bar,false);
      slow_ma = MA2.MASeries(0,prev_calculated,rates_total,Slow_MA, MA_Method_,price,bar,false);
      MACDBuffer[bar]=fast_ma-slow_ma;
      SignBuffer[bar]=MA3.MASeries(macd_start,prev_calculated,rates_total,Signal_MA,Signal_Method_,MACDBuffer[bar],bar,false);
     }
//----     MACD
   for(bar=first2; bar<rates_total; bar++)
     {
      int clr=0;
      //----
      if(MACDBuffer[bar]>0)
        {
         if(MACDBuffer[bar]>MACDBuffer[bar-1]) clr=1;
         if(MACDBuffer[bar]<MACDBuffer[bar-1]) clr=2;
        }
      //----
      if(MACDBuffer[bar]<0)
        {
         if(MACDBuffer[bar]<MACDBuffer[bar-1]) clr=3;
         if(MACDBuffer[bar]>MACDBuffer[bar-1]) clr=4;
        }
      ColorMACDBuffer[bar]=clr;
     }
//----     
   for(bar=first3; bar<rates_total; bar++)
     {
      int clr=0;
      if(MACDBuffer[bar]>SignBuffer[bar-1]) clr=1;
      if(MACDBuffer[bar]<SignBuffer[bar-1]) clr=2;
      ColorSignBuffer[bar]=clr;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
