//+------------------------------------------------------------------+ 
//|                                       MaxminChannelWithSlope.mq5 | 
//|                                         Copyright  2016, fajuzi | 
//|                                             fajuzi@yahoo.it 2015 | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2016, fajuzi"
#property link "fajuzi@yahoo.it 2015"
#property description "simple max - min channel with ema slope"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----    2
#property indicator_buffers 2 
//----    
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----      
#property indicator_type1   DRAW_FILLING
//----     
#property indicator_color1  clrPaleTurquoise
//----   
#property indicator_label1  "MaxminChannelWithSlope"
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint      barre=20;      // Bars for calculation min max
input double   ratio=4.0;      // Ratio EMA period / bars
input double   xslope=1.0;     // Slope adjustment
//+-----------------------------------+
//----      
int  min_rates_total;
double cosemap,emap,xslp,pendenzaxslp;
//----   ,    
//----      
double UpBuffer[];
double DnBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//----     
   min_rates_total=3;
   xslp=xslope*0.5;//adjustment of slope
   emap=barre*ratio;//period
   cosemap=(emap+1.0)/2.0;//constant
//----      
   SetIndexBuffer(0,UpBuffer,INDICATOR_DATA);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(UpBuffer,true);
//----      
   SetIndexBuffer(1,DnBuffer,INDICATOR_DATA);
//----       
   ArraySetAsSeries(DnBuffer,true);
//----         
   string shortname;
   StringConcatenate(shortname,"MaxminChannelWithSlope(",barre,", ",DoubleToString(ratio,2),", ",xslope,")");
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits+1);
//----  
  }
//+------------------------------------------------------------------+  
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &Time[],
                const double &Open[],
                const double &High[],
                const double &Low[],
                const double &Close[],
                const long &Tick_Volume[],
                const long &Volume[],
                const int &Spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----       
   double pendenza;
   static double pendenza_prev;
//----   
   int limit;
//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      pendenza_prev=0.0;
     }
   else limit=rates_total-prev_calculated;  //       
//----         
   ArraySetAsSeries(High,true);
   ArraySetAsSeries(Low,true);
//----    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      pendenza=pendenza_prev+(High[bar]+Low[bar]-High[bar+1]-Low[bar+1]-pendenza_prev)/cosemap;
      pendenzaxslp=pendenza*xslp;
      //----
      switch(bar+1-ArrayMaximum(High,bar,barre))
        {
         case 0 : UpBuffer[bar+1]=High[bar+1]; break;
         default : UpBuffer[bar+1]=UpBuffer[bar+2]+pendenzaxslp;
        }
      switch(bar+1-ArrayMinimum(Low,bar,barre))
        {
         case 0 : DnBuffer[bar+1]=Low[bar+1]; break;
         default : DnBuffer[bar+1]=DnBuffer[bar+2]+pendenzaxslp;
        }
      if(bar) pendenza_prev=pendenza;
     }
   UpBuffer[0]=UpBuffer[1]+pendenzaxslp;
   DnBuffer[0]=DnBuffer[1]+pendenzaxslp;
//----    
   return(rates_total);
  }
//+------------------------------------------------------------------+
