//+---------------------------------------------------------------------+
//|                                           VKW_Bands_Modify_XRSX.mq5 | 
//|                                     Copyright  2008, Alksnis Gatis | 
//|                                                   2xpoint@gmail.com | 
//+---------------------------------------------------------------------+
//|          SmoothAlgorithms.mqh |
//|   (): terminal_data_folder\MQL5\Include             |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2008, Alksnis Gatis"
#property link "2xpoint@gmail.com"
#property description " ,    "
#property description "         ,     "
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----   
#property indicator_buffers 3 
//----     
#property indicator_plots   3
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       SlateGray 
#property indicator_color1 clrSlateGray
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "METRO_XRSX"
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type2   DRAW_LINE
//----       Blue 
#property indicator_color2 clrBlue
//----   -  
#property indicator_style2  STYLE_SOLID
//----     3
#property indicator_width2  3
//----   
#property indicator_label2  "VKW_Bands Upper"
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type3   DRAW_LINE
//----       DarkOrange 
#property indicator_color3 clrDarkOrange
//----   -  
#property indicator_style3  STYLE_SOLID
//----     3
#property indicator_width3  3
//----   
#property indicator_label3  "VKW_Bands Lower"
//+-----------------------------------+
//|                   |
//+-----------------------------------+
#property indicator_level1 60
#property indicator_level2 40
#property indicator_levelcolor clrMagenta
#property indicator_levelstyle STYLE_DASHDOTDOT
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0                      //        
//+-----------------------------------+
//|   CXMA              |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2;
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_   //TrendFollow_2 Price 
  };
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input Smooth_Method DSmoothMethod=MODE_JJMA; //   
input int DPeriod=15;  //   
input int DPhase=100;  //    
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input int StepSizeFast=5;                             //  
input int StepSizeSlow=15;                            //  
input int IShift=0;                                   //       
input Applied_price_ IPC=PRICE_CLOSE;                 //  
input uint RPeriod=25;                                //    
input Smooth_Method SmMA_Method=MODE_SMA;             //  
input uint SLength=3;                                 //  
input int SPhase=100;                                 //  
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input int SShift=0;                                   //       
//+-----------------------------------+
//----   ,    
//----      
double IndBuffer[],UpIndBuffer[],DnIndBuffer[];
//----      
int Ind_Handle;
//----      
int min_rates_total,min_rates_1;
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//----     
   min_rates_1=GetStartBars(DSmoothMethod,DPeriod,DPhase)+1;
   min_rates_1+=int(RPeriod);
   min_rates_total=min_rates_1+GetStartBars(SmMA_Method,SLength,SPhase);
//----    ColorMETRO_XRSX
   Ind_Handle=iCustom(NULL,0,"ColorMETRO_XRSX",DSmoothMethod,DPeriod,DPhase,StepSizeFast,StepSizeSlow,IPC,0);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      ColorMETRO_XRSX");
      return(INIT_FAILED);
     }
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,IShift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//----          
   ArraySetAsSeries(IndBuffer,true);

//----      
   SetIndexBuffer(1,UpIndBuffer,INDICATOR_DATA);
//----    2  
   PlotIndexSetInteger(1,PLOT_SHIFT,SShift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0);
//----          
   ArraySetAsSeries(UpIndBuffer,true);

//----      
   SetIndexBuffer(2,DnIndBuffer,INDICATOR_DATA);
//----    3  
   PlotIndexSetInteger(2,PLOT_SHIFT,SShift);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0);
//----          
   ArraySetAsSeries(DnIndBuffer,true);

//----      
   string shortname="VKW_Bands_METRO_XRSX";
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(Ind_Handle)<rates_total || rates_total<int(min_rates_total)) return(RESET);
//----       
   double d_max,d_min;
//----        
   int limit,to_copy,bar,maxbar;
   maxbar=rates_total-1-min_rates_1;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      limit=maxbar; //      
     }
   else limit=rates_total-prev_calculated; //      
   to_copy=limit+1+int(RPeriod);
//----      
   if(CopyBuffer(Ind_Handle,0,0,to_copy,IndBuffer)<=0) return(RESET);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      d_max=IndBuffer[ArrayMaximum(IndBuffer,bar,RPeriod)];
      d_min=IndBuffer[ArrayMinimum(IndBuffer,bar,RPeriod)];
      UpIndBuffer[bar]=XMA1.XMASeries(maxbar,prev_calculated,rates_total,SmMA_Method,SPhase,SLength,d_max,bar,true);
      DnIndBuffer[bar]=XMA2.XMASeries(maxbar,prev_calculated,rates_total,SmMA_Method,SPhase,SLength,d_min,bar,true);
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
