//+---------------------------------------------------------------------+
//|                                                  JS-Stoh-BB-RSI.mq5 | 
//|                                         Copyright  2009, js_sergey | 
//|                          js_sergey@list.ru, http://multiexperts.ru/ | 
//+---------------------------------------------------------------------+
//|     SmoothAlgorithms.mqh      |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+ 
#property copyright "Copyright  2009, js_sergey"
#property link "http://multiexperts.ru/"
#property description "X2MA Bollinger Bands"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----    5
#property indicator_buffers 5 
//----   5  
#property indicator_plots   5
//+----------------------------------------------+
//|     1            |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1 clrBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     1
#property indicator_width1  1
//----   
#property indicator_label1  "Stochastic"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//----     
#property indicator_type2   DRAW_LINE
//----        
#property indicator_color2 clrTeal
//----   -  
#property indicator_style2  STYLE_SOLID
//----     1
#property indicator_width2  1
//----   
#property indicator_label2  "RSI"
//+----------------------------------------------+
//|    3             |
//+----------------------------------------------+
//----     
#property indicator_type3   DRAW_LINE
//----       - 
#property indicator_color3 clrBlueViolet
//----   -  
#property indicator_style3  STYLE_SOLID
//----     2
#property indicator_width3  2
//----   
#property indicator_label3  "Stochastic Signal"
//+----------------------------------------------+
//|    BB     |
//+----------------------------------------------+
//----      
#property indicator_type4   DRAW_LINE
#property indicator_type5   DRAW_LINE
//----    
#property indicator_color4  clrRed
#property indicator_color5  clrRed
//----   -  
#property indicator_style4 STYLE_SOLID
#property indicator_style5 STYLE_SOLID
//----     1
#property indicator_width4  1
#property indicator_width5  1
//----    
#property indicator_label4  "+2Sigma Stochastic"
#property indicator_label5  "-2Sigma Stochastic"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1  80.0
#property indicator_level2  70.0
#property indicator_level3  50.0
#property indicator_level4  30.0
#property indicator_level5  20.0
#property indicator_levelcolor clrMagenta
#property indicator_levelstyle STYLE_DASHDOTDOT
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                     |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//----    CXMA  CStdDeviation   SmoothAlgorithms.mqh
CXMA XMA;
CStdDeviation STD;
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint STO_KPeriod=5;  // K period 
input uint STO_DPeriod=3;  // D period 
input uint STO_Slowing=3;  // Slowing 
input ENUM_MA_METHOD STO_Method=MODE_SMA; //   
input ENUM_STO_PRICE STO_Price=STO_LOWHIGH; //   
input uint BandsPeriod=10; //   BB
input double BandsDeviation=1.0; // 
input uint RSI_Period=8; //   RSI
input ENUM_APPLIED_PRICE RSI_Price=PRICE_CLOSE; //     RSI
input int Shift=0; //      
//+----------------------------------------------+
//----   ,    
//----      
double ExtLineBuffer1[],ExtLineBuffer2[],ExtLineBuffer3[],ExtLineBuffer4[],ExtLineBuffer5[];
//----      
int RSI_Handle,STO_Handle;
//----      
int min_rates_total,min_rates_sto;
//+------------------------------------------------------------------+   
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_sto=int(STO_KPeriod+STO_DPeriod+STO_Slowing+1);
   int min_rates_=int(min_rates_sto+BandsDeviation);
   min_rates_total=int(MathMax(min_rates_,RSI_Period));
//----    iRSI  
   RSI_Handle=iRSI(NULL,PERIOD_CURRENT,RSI_Period,RSI_Price);
   if(RSI_Handle==INVALID_HANDLE) Print("      iRSI");
//----     iStochastic
   STO_Handle=iStochastic(NULL,0,STO_KPeriod,STO_DPeriod,STO_Slowing,STO_Method,STO_Price);
   if(STO_Handle==INVALID_HANDLE) Print("      iStochastic");
//----      
   SetIndexBuffer(0,ExtLineBuffer1,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(ExtLineBuffer1,true);
//----      
   SetIndexBuffer(1,ExtLineBuffer2,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(ExtLineBuffer2,true);
//----      
   SetIndexBuffer(2,ExtLineBuffer3,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(ExtLineBuffer3,true);
//----      
   SetIndexBuffer(3,ExtLineBuffer4,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(3,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(ExtLineBuffer4,true);
//----      
   SetIndexBuffer(4,ExtLineBuffer5,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(4,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(4,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(4,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----       
   ArraySetAsSeries(ExtLineBuffer5,true);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"JS-Stoh-BB-RSI");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----  
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(BarsCalculated(STO_Handle)<rates_total
      || BarsCalculated(RSI_Handle)<rates_total
      || rates_total<min_rates_total) return(RESET);
//----   
   int limit,bar,to_copy,xmaxbar,smaxbar;
//----       
   double stoh,xstoh,stdev;
//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-1; //      
     }
   else limit=rates_total-prev_calculated; //       
//----
   xmaxbar=rates_total-min_rates_sto-1;
   smaxbar=xmaxbar-int(BandsPeriod);
   to_copy=limit+1;
//----      
   if(CopyBuffer(STO_Handle,MAIN_LINE,0,to_copy,ExtLineBuffer1)<=0) return(RESET);
   if(CopyBuffer(RSI_Handle,MAIN_LINE,0,to_copy,ExtLineBuffer2)<=0) return(RESET);
//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      stoh=ExtLineBuffer1[bar];
      xstoh=XMA.XMASeries(xmaxbar,prev_calculated,rates_total,int(MODE_SMA),0,BandsPeriod,stoh,bar,true);
      ExtLineBuffer3[bar]=xstoh;
      stdev=STD.StdDevSeries(smaxbar,prev_calculated,rates_total,BandsPeriod,BandsDeviation,stoh,xstoh,bar,true);
      ExtLineBuffer4[bar]=xstoh+stdev;
      ExtLineBuffer5[bar]=xstoh-stdev;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
