//+------------------------------------------------------------------+
//|                                                 FineTuningMA.mq5 | 
//|                                         Copyright  2010, gumgum |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, gumgum"
#property link      ""
//----   
#property version   "1.00"
//----  
#property description "    "
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       RoyalBlue 
#property indicator_color1 clrRoyalBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     3
#property indicator_width1  3
//----   
#property indicator_label1  "FineTuningMA"
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//+-----------------------------------+
//|         |
//+-----------------------------------+
input uint   FTMA=10;
input double rank1=2;
input double rank2=2;
input double rank3=2;
input double shift1=1;
input double shift2=1;
input double shift3=1;
input Applied_price_ IPC=PRICE_TYPICAL; //  
/* ,      ( 1-CLOSE, 2-OPEN, 3-HIGH, 4-LOW, 
  5-MEDIAN, 6-TYPICAL, 7-WEIGHTED, 8-SIMPL, 9-QUARTER, 10-TRENDFOLLOW, 11-0.5 * TRENDFOLLOW.) */
input int Shift=0; //      
input int PriceShift=0; //      
//+-----------------------------------+
//----   ,    
//----      
double LineBuffer[];
//----
double PM[];
//----       
double dPriceShift;
//----      
int min_rates_total;
//+------------------------------------------------------------------+   
//| FineTuningMA indicator initialization function                   | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----    
   dPriceShift=_Point*PriceShift;
//----       
   ArrayResize(PM,FTMA);
//----  
   double sum=0;
   for(int h=0; h<int(FTMA); h++)
     {
      PM[h]=shift1+MathPow(h/(FTMA-1.0),rank1)*(1.0-shift1);
      PM[h]=(shift2+MathPow(1-(h/(FTMA-1.0)),rank2)*(1.0-shift2))*PM[h];
      //----
      if((h/(FTMA-1.))<0.5) PM[h]=(shift3+MathPow((1-(h/(FTMA-1.0))*2.0),rank3)*(1.0-shift3))*PM[h];
      else PM[h]=(shift3+MathPow((h/(FTMA-1.0))*2.0-1.0,rank3)*(1.0-shift3))*PM[h];
      //----
      sum+=PM[h];
     }
//----
   double sum1=0;
   for(int h=0; h<int(FTMA); h++)
     {
      PM[h]=PM[h]/sum;
      sum1+=PM[h];
     }
//----     
   min_rates_total=int(FTMA);
//----      
   SetIndexBuffer(0,LineBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"FineTuningMA");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----  
  }
//+------------------------------------------------------------------+ 
//| FineTuningMA iteration function                                  | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);
//----        
   int first,bar;
//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=min_rates_total; //      
   else first=prev_calculated-1; //      
//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      double sum1=0;
      for(int h=0; h<int(FTMA); h++) sum1+=PM[h]*PriceSeries(IPC,bar-h,open,low,high,close);
      LineBuffer[bar]=sum1+dPriceShift;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//| PriceSeries() function                                           |
//+------------------------------------------------------------------+
double PriceSeries(uint applied_price, //  
                   uint   bar,         //            
                   const double &Open[],
                   const double &Low[],
                   const double &High[],
                   const double &Close[])
  {
//----
   switch(applied_price)
     {
      //----     ENUM_APPLIED_PRICE
      case  PRICE_CLOSE: return(Close[bar]);
      case  PRICE_OPEN: return(Open [bar]);
      case  PRICE_HIGH: return(High [bar]);
      case  PRICE_LOW: return(Low[bar]);
      case  PRICE_MEDIAN: return((High[bar]+Low[bar])/2.0);
      case  PRICE_TYPICAL: return((Close[bar]+High[bar]+Low[bar])/3.0);
      case  PRICE_WEIGHTED: return((2*Close[bar]+High[bar]+Low[bar])/4.0);
      //----                            
      case  8: return((Open[bar] + Close[bar])/2.0);
      case  9: return((Open[bar] + Close[bar] + High[bar] + Low[bar])/4.0);
      //----                                
      case 10:
        {
         if(Close[bar]>Open[bar])return(High[bar]);
         else
           {
            if(Close[bar]<Open[bar])
               return(Low[bar]);
            else return(Close[bar]);
           }
        }
      //----         
      case 11:
        {
         if(Close[bar]>Open[bar])return((High[bar]+Close[bar])/2.0);
         else
           {
            if(Close[bar]<Open[bar])
               return((Low[bar]+Close[bar])/2.0);
            else return(Close[bar]);
           }
         break;
        }
      //----
      default: return(Close[bar]);
     }
//----
//return(0);
  }
//+------------------------------------------------------------------+
