//+------------------------------------------------------------------+
//|                                                      r_Gator.mq5 |
//|                                         Copyright  2006, Rosych | 
//|                                                   rosych@mail.ru | 
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Rosych"
#property link "rosych@mail.ru"
#property description "      "
//---   
#property version   "1.03"
//---     
#property indicator_chart_window 
//---        
#property indicator_buffers 3
//---     
#property indicator_plots   3
//+----------------------------------------------+
//|    1             |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_LINE
//---        
#property indicator_color1  clrRed
//---    1  2
#property indicator_width1  2
//---   
#property indicator_label1  "r_Gator Fast"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_LINE
//---        
#property indicator_color2  clrGreen
//---    2  2
#property indicator_width2  2
//---   
#property indicator_label2 "r_Gator"
//+----------------------------------------------+
//|    3             |
//+----------------------------------------------+
//---   3   
#property indicator_type3   DRAW_LINE
//---        
#property indicator_color3  clrBlue
//---    3  2
#property indicator_width3  2
//---   
#property indicator_label3 "r_Gator Slow"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint period1=5;    //   MA 
input uint period2=8;    //   MA
input uint period3=13;   //   MA
input int  Shift1=0;     //   MA    
input int  Shift2=0;     //   MA    
input int  Shift3=0;     //   MA    
//+----------------------------------------------+
//---   ,   
//---      
double Buffer1[],Buffer2[],Buffer3[];
//---      
int min_rates_total;
//---      
int MA_Handle[3][4][7]; //[ ][ ][-1]
//+------------------------------------------------------------------+
//|             |
//+------------------------------------------------------------------+  
class CArray
  {
public: double    Array[];
  };
//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+
CArray Arr[3][4][7];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//---      
   min_rates_total=int(MathMax(period1,MathMax(period2,period3)));
//---
   uint MAPeriod[3];
   MAPeriod[0]=period1;
   MAPeriod[1]=period2;
   MAPeriod[2]=period3;
//---   
   for(int i=0; i<3; i++)
      for(int k=0; k<4; k++)
         for(int r=0; r<7; r++)
           {
            MA_Handle[i][k][r]=iMA(NULL,0,MAPeriod[i],0,ENUM_MA_METHOD(k),ENUM_APPLIED_PRICE(r+1));
            if(MA_Handle[i][k][r]==INVALID_HANDLE)
              {
               Print("      iMA");
               return(INIT_FAILED);
              }
           }
//---      
   SetIndexBuffer(0,Buffer1,INDICATOR_DATA);
//---       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---    ,   
   ArraySetAsSeries(Buffer1,true);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
//---    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift1);
//---      
   SetIndexBuffer(1,Buffer2,INDICATOR_DATA);
//---       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---    ,   
   ArraySetAsSeries(Buffer2,true);
//---   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0);
//---    1  
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift2);
//---      
   SetIndexBuffer(2,Buffer3,INDICATOR_DATA);
//---       3
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//---    ,   
   ArraySetAsSeries(Buffer3,true);
//---   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0);
//---    1  
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift3);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---         
   string short_name="r_Gator";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+    
void OnDeinit(const int reason)
  {
//---
   Comment("");
//---
   ChartRedraw(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   for(int i=0; i<3; i++)
      for(int k=0; k<4; k++)
         for(int r=0; r<7; r++)
            if(BarsCalculated(MA_Handle[i][k][r])<rates_total) return(RESET);
//---
   if(rates_total<min_rates_total) return(RESET);
//---    
   int limit,to_copy;
//---     
//---    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      limit=rates_total-min_rates_total;   //      
   else limit=rates_total-prev_calculated; //      
//---    ,    
   for(int i=0; i<3; i++)
      for(int k=0; k<4; k++)
         for(int r=0; r<7; r++)
            ArraySetAsSeries(Arr[i][k][r].Array,true);
//---   
   to_copy=limit+1;
//---      
   for(int i=0; i<3; i++)
      for(int k=0; k<4; k++)
         for(int r=0; r<7; r++)
            if(CopyBuffer(MA_Handle[i][k][r],0,0,to_copy,Arr[i][k][r].Array)<=0) return(RESET);

//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      Buffer1[bar]=0.0; for(int k=0; k<4; k++) for(int r=0; r<7; r++) Buffer1[bar]+=Arr[0][k][r].Array[bar]; Buffer1[bar]/=28;
      Buffer2[bar]=0.0; for(int k=0; k<4; k++) for(int r=0; r<7; r++) Buffer2[bar]+=Arr[1][k][r].Array[bar]; Buffer2[bar]/=28;
      Buffer3[bar]=0.0; for(int k=0; k<4; k++) for(int r=0; r<7; r++) Buffer3[bar]+=Arr[2][k][r].Array[bar]; Buffer3[bar]/=28;
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
