//+------------------------------------------------------------------+
//|                                         AdaptiveCGOscillator.mq5 |
//|                                                                  |
//| Adaptive CG Oscillator                                           |
//|                                                                  |
//| Algorithm taken from book                                        |
//|     "Cybernetics Analysis for Stock and Futures"                 |
//| by John F. Ehlers                                                |
//|                                                                  |
//|                                              contact@mqlsoft.com |
//|                                          http://www.mqlsoft.com/ |
//+------------------------------------------------------------------+
//---  
#property copyright "Coded by Witold Wozniak"
//---  
#property link      "www.mqlsoft.com"
//---   
#property version   "1.00"
//---     
#property indicator_separate_window
//---        
#property indicator_buffers 2
//---    
#property indicator_plots   2
//+----------------------------------------------+
//|    CG            |
//+----------------------------------------------+
//---   1   
#property indicator_type1   DRAW_LINE
//---         
#property indicator_color1  Red
//---   1 -  
#property indicator_style1  STYLE_SOLID
//---    1  1
#property indicator_width1  1
//---    
#property indicator_label1  "Adaptive CG Oscillator"
//+----------------------------------------------+
//|    Trigger       |
//+----------------------------------------------+
//---   2   
#property indicator_type2   DRAW_LINE
//---         
#property indicator_color2  Blue
//---   2 -  
#property indicator_style2  STYLE_SOLID
//---    2  1
#property indicator_width2  1
//---    
#property indicator_label2  "Trigger"
//+----------------------------------------------+
//|     |
//+----------------------------------------------+
#property indicator_level1 0.0
#property indicator_levelcolor Gray
#property indicator_levelstyle STYLE_DASHDOTDOT
//+-----------------------------------+
//|                 |
//+-----------------------------------+
#define RESET 0 // R       
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input double Alpha=0.07;  //    
input int Shift=0;        //       
//+----------------------------------------------+
//---   ,   
//---      
double ACGBuffer[];
double TriggerBuffer[];
//---      
int CP_Handle;
//---      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   min_rates_total=1;
//---    CyclePeriod
   CP_Handle=iCustom(NULL,0,"CyclePeriod",Alpha);
   if(CP_Handle==INVALID_HANDLE)
     {
      Print("      CyclePeriod");
      return(INIT_FAILED);
     }
//---      
   SetIndexBuffer(0,ACGBuffer,INDICATOR_DATA);
//---    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//---       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---      
   SetIndexBuffer(1,TriggerBuffer,INDICATOR_DATA);
//---    2    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//---       2  min_rates_total+1
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total+1);
//---   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---      
   string shortname;
   StringConcatenate(shortname,"Adaptive CG Oscillator(",DoubleToString(Alpha,4),", ",Shift,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(BarsCalculated(CP_Handle)<rates_total || rates_total<min_rates_total) return(RESET);
//---    
   int first,bar,intperiod;
   double price,Num,Denom,period[1];
//---    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=1; //      
   else first=prev_calculated-1; //      
//---    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      //---      
      if(CopyBuffer(CP_Handle,0,rates_total-1-bar,1,period)<=0) return(RESET);
      intperiod=int(MathFloor(period[0]/2.0));
      //---
      Num=0.0;
      Denom=0.0;
      if(bar<intperiod) intperiod=bar; //      
      //---
      for(int count=0; count<intperiod; count++)
        {
         price=(high[bar-count]+low[bar-count])/2.0;
         Num += (1.0 + count) * price;
         Denom+=price;
        }
      //---
      if(Denom!=0.0) ACGBuffer[bar]=-Num/Denom+(intperiod+1.0)/2.0;
      else           ACGBuffer[bar]=EMPTY_VALUE;
      //---
      TriggerBuffer[bar]=ACGBuffer[bar-1];
     }
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
