//+------------------------------------------------------------------+ 
//|                                     ForexProfitBoost_2nb_HTF.mq5 | 
//|                               Copyright  2015, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2015, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---   
#property version   "1.60"
//---     
#property indicator_chart_window 
//---    6
#property indicator_buffers 6 
//---  3  
#property indicator_plots   3
//+-----------------------------------+
//|     1 |
//+-----------------------------------+
//---     
#property indicator_type1   DRAW_HISTOGRAM2
//---     
#property indicator_color1  clrOrange
//---     2
#property indicator_width1  2
//---   
#property indicator_label1  "ForexProfitBoost_2nb 1"
//+-----------------------------------+
//|     2 |
//+-----------------------------------+
//---     
#property indicator_type2   DRAW_HISTOGRAM2
//---     
#property indicator_color2  clrDeepPink
//---     2
#property indicator_width2  2
//---   
#property indicator_label2  "ForexProfitBoost_2nb 2"
//+-----------------------------------+
//|     3 |
//+-----------------------------------+
//---     
#property indicator_type3   DRAW_HISTOGRAM2
//---     
#property indicator_color3  clrBlue
//---     2
#property indicator_width3  2
//---   
#property indicator_label3  "ForexProfitBoost_2nb 3"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                                 //        
#define INDICATOR_NAME "ForexProfitBoost_2nb"   //    
#define SIZE 3                                  //      CountIndicator 
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;      //    ()

//---    1
input uint   MAPeriod1=7;
input  ENUM_MA_METHOD   MAType1=MODE_EMA;
input ENUM_APPLIED_PRICE   MAPrice1=PRICE_CLOSE;
//---    2
input uint   MAPeriod2=21;
input  ENUM_MA_METHOD   MAType2=MODE_SMA;
input ENUM_APPLIED_PRICE   MAPrice2=PRICE_CLOSE;
input uint BBPeriod = 15;
input double BBDeviation=1;
input uint BBShift=1;
input int Shift=0;                               //      
//+----------------------------------------------+
//---   ,   
//---      
double Up1IndBuffer[],Dn1IndBuffer[];
double Up2IndBuffer[],Dn2IndBuffer[];
double Up3IndBuffer[],Dn3IndBuffer[];
//---      
int min_rates_total;
//---      
int Ind_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   if(!TimeFramesCheck(INDICATOR_NAME,TimeFrame)) return(INIT_FAILED);
//---   
   min_rates_total=2;
//---    ForexProfitBoost_2nb
   Ind_Handle=iCustom(Symbol(),TimeFrame,"ForexProfitBoost_2nb",MAPeriod1,MAType1,MAPrice1,MAPeriod2,MAType2,MAPrice2,BBPeriod,BBDeviation,BBShift);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      ForexProfitBoost_2nb");
      return(INIT_FAILED);
     }
//---   
   IndInit(0,Up1IndBuffer,INDICATOR_DATA);
   IndInit(1,Dn1IndBuffer,INDICATOR_DATA);
   IndInit(2,Up2IndBuffer,INDICATOR_DATA);
   IndInit(3,Dn2IndBuffer,INDICATOR_DATA);
   IndInit(4,Up3IndBuffer,INDICATOR_DATA);
   IndInit(5,Dn3IndBuffer,INDICATOR_DATA);
//---  
   PlotInit(0,EMPTY_VALUE,0,Shift);
   PlotInit(1,EMPTY_VALUE,0,Shift);
   PlotInit(2,EMPTY_VALUE,0,Shift);
//---           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME,"(",GetStringTimeframe(TimeFrame),")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//---         
   ArraySetAsSeries(time,true);
//---
   if(!CountIndicator(0,NULL,TimeFrame,Ind_Handle,0,Up1IndBuffer,1,Dn1IndBuffer,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(1,NULL,TimeFrame,Ind_Handle,2,Up2IndBuffer,3,Dn2IndBuffer,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
   if(!CountIndicator(2,NULL,TimeFrame,Ind_Handle,4,Up3IndBuffer,5,Dn3IndBuffer,time,rates_total,prev_calculated,min_rates_total)) return(RESET);
//---     
   return(rates_total);
  }
//---
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
void IndInit(int Number,double &Buffer[],ENUM_INDEXBUFFER_TYPE Type)
  {
//---      
   SetIndexBuffer(Number,Buffer,Type);
//---       
   ArraySetAsSeries(Buffer,true);
//---
  }
//+------------------------------------------------------------------+
//|                                           |
//+------------------------------------------------------------------+    
void PlotInit(int Number,double Empty_Value,int Draw_Begin,int nShift)
  {
//---      
   PlotIndexSetInteger(Number,PLOT_DRAW_BEGIN,Draw_Begin);
//---   ,      
   PlotIndexSetDouble(Number,PLOT_EMPTY_VALUE,Empty_Value);
//---       Shift
   PlotIndexSetInteger(Number,PLOT_SHIFT,nShift);
//---
  }
//+------------------------------------------------------------------+
//| CountLine                                                        |
//+------------------------------------------------------------------+
bool CountIndicator(uint     Numb,            //   CountLine      (  - 0)
                    string   Symb,            //  
                    ENUM_TIMEFRAMES TFrame,   //  
                    int      IndHandle,       //   
                    uint     UpBuffNumb,      //       
                    double&  UpIndBuf[],      //      
                    uint     DnBuffNumb,      //       
                    double&  DnIndBuf[],      //      
                    const datetime& iTime[],  //  
                    const int Rates_Total,    //       
                    const int Prev_Calculated,//       
                    const int Min_Rates_Total)//       
  {
//---
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;
//---     
//---    limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       
//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---       IndTime
      if(CopyTime(Symbol(),TFrame,iTime[bar],1,IndTime)<=0) return(RESET);

      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double UpArr[1],DnArr[1];
         //---      
         if(CopyBuffer(IndHandle,UpBuffNumb,iTime[bar],1,UpArr)<=0) return(RESET);
         if(CopyBuffer(IndHandle,DnBuffNumb,iTime[bar],1,DnArr)<=0) return(RESET);
         
         UpIndBuf[bar]=UpArr[0]; 
         DnIndBuf[bar]=DnArr[0];
        }
      else
        {
         UpIndBuf[bar]=UpIndBuf[bar+1];
         DnIndBuf[bar]=DnIndBuf[bar+1];
        }
     }
//---     
   return(true);
  }
//+------------------------------------------------------------------+
//| TimeFramesCheck()                                                |
//+------------------------------------------------------------------+    
bool TimeFramesCheck(string IndName,
                     ENUM_TIMEFRAMES TFrame) //   ()
  {
//---     
   if(TFrame<Period() && TFrame!=PERIOD_CURRENT)
     {
      Print("    "+IndName+"       !");
      Print("    !");
      return(RESET);
     }
//---
   return(true);
  }
//+------------------------------------------------------------------+
