//+---------------------------------------------------------------------+
//|                                                     Range_Rider.mq5 | 
//|                                         Copyright  2013, Langouste | 
//|                                                                     | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
#property copyright "Copyright  2013, Langouste"
#property link "Copyright  2013, Langouste"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window 
//----   
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----        
#property indicator_color1 clrRed
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1  2
//----   
#property indicator_label1  "Range_Rider"

//+-----------------------------------+
//|    CXMA             |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//+-----------------------------------+

//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2;
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|         |
//+-----------------------------------+
input Smooth_Method MA_Method1=MODE_SMA; //    
input int Length1=2; //                       
input int Phase1=15; //  ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input Smooth_Method MA_Method2=MODE_SMA; //    
input int Length2 = 5; //    
input int Phase2=15;  //  ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input int Shift=0; //      
//+-----------------------------------+

//----   ,    
//      
double IndBuffer[];

//----      
int min_rates_total;
//+------------------------------------------------------------------+   
//| Range_Rider indicator initialization function                    | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   int min_rates_1=XMA1.GetStartBars(MA_Method1,Length1,Phase1);
   int min_rates_2=XMA2.GetStartBars(MA_Method2,Length2,Phase2);
   min_rates_total=MathMax(min_rates_1,min_rates_2);
//----       
   XMA1.XMALengthCheck("Length1",Length1);
   XMA2.XMALengthCheck("Length2",Length2);
//----       
   XMA1.XMAPhaseCheck("Phase1",Phase1,MA_Method1);
   XMA2.XMAPhaseCheck("Phase2",Phase2,MA_Method2);
   
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0);
   
//----      
   string shortname;
   string Smooth1=XMA1.GetString_MA_Method(MA_Method1);
   string Smooth2=XMA1.GetString_MA_Method(MA_Method2);
   StringConcatenate(shortname,"Range_Rider(",Length1,", ",Length2,", ",Smooth1,", ",Smooth2,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
   
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----  
  }
//+------------------------------------------------------------------+ 
//| Range_Rider iteration function                                   | 
//+------------------------------------------------------------------+ 
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----       
   double range,x1range,x2range;
//----        
   int first,bar;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
      first=1; //      
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      range=MathMax(high[bar],close[bar-1])-MathMin(low[bar],close[bar-1]);  
      x1range=XMA1.XMASeries(1,prev_calculated,rates_total,MA_Method1,Phase1,Length1,range,bar,false);
      x2range=XMA2.XMASeries(1,prev_calculated,rates_total,MA_Method2,Phase2,Length2,range,bar,false);
      x2range=MathMax(x2range,_Point); 
      IndBuffer[bar]=100*x1range/x2range;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
