#property copyright "trevone"
#property link "Milestone 4.3" 
extern string TOOLS = ".............................................................................................................";
extern int MAGIC = 20130721;
extern bool NewSession = false;
extern bool CloseAll = false;
extern bool ContinueTrading = true;
extern bool BackupSystem = true;  
extern bool FrontSystem = true;  
extern bool EarlyExits = true;
extern bool FixedSpace = false;
extern bool FixedLots = false;
extern string REWARD = ".............................................................................................................";
extern int QueryHistory = 7; 
extern int QueryHistory2 = 40; 
extern double BasketProfit = 1.025;
extern double OpenProfit = 1.0345; 
extern double MinProfit =  0.0045;
extern double LongStop = 0.5;
extern double MaxStops = 1;
extern double MinGowth =  0.037; 
extern double MaxGowth =  0.053; 
extern double LongGowth =  0.083; 
extern int StopLoss = 0.35;
extern int MaxStop = 4.35;
extern double MaxDrawDown = 0.93;
extern int RelativeStop = 1.35;
extern double TriggerFrontSystem = 0.1;
extern double TriggerBackSystem = 0.97;
extern string RISK = "............................................................................................................."; 
extern int MaxTrades = 1; 
extern double MarginUsage = 0.037;
extern double MinLots = 0.02;
extern double TradeSpace = 4.5;
extern string INDICATOR_ATR = ".............................................................................................................";
extern int ATRTimeFrame = 0;
extern int ATRPeriod = 10;
extern int ATRShift = 0; 
extern int ATRShiftCheck = 2; 
extern string INDICATOR_ADX = ".............................................................................................................";
extern double ADXMain = 10; 
extern int ADXTimeFrame = 0;
extern int ADXPeriod = 14;
extern int ADXShift = 0;
extern int ADXShiftCheck = 1; 
extern string INDICATOR_MA = ".............................................................................................................";
extern int MATimeFrame = 0; 
extern int MA2Period = 10;
extern int MA1Period = 120;
extern int MMAShift = 0;
extern int MAShift = 0;
extern int MAShiftCheck = 14; 
extern double MinTrend = 0.00015;

double trendStrend = 0;


double maxLotsHistory = 0;

int stopCounter = 0;


double slippage, marginRequirement, lotSize, totalHistoryProfit, totalProfit, totalLoss, symbolHistory,  
eATR, eATRPrev, eADXMain, eADXPlusDi, eADXMinusDi, eADXMainPrev, eADXPlusDiPrev, eADXMinusDiPrev, MA1Cur, MA1Prev,MA2Cur, MA2Prev;

int digits, totalTrades, totalBackupTrades;

bool nearLongPosition = false;
bool nearShortPosition = false;  
bool rangingMarket = false;
bool bullish = false;
bool bearish = false; 
bool incrementLimits = false;
int totalHistory = 100;
int basketNumber = 0;
int basketNumberType = -1;
int basketCount = -1; 
double buyLots = 0;
double sellLots = 0;
double pipPoints = 0.00010; 
double fractalUpPrice = 0;
double fractalDownPrice = 0; 
double milestoneCount = 0;
double milestoneEquity = 0;
double milestoneBalance = 0;
double nextMilestone = 0;
double prevMilestone = 0;
double accumulatedEquity = 0; 
double mileEquity = 0; 
double DynamicSlippage = 1;   
double BaseLotSize = 0.01; 
double accountLimit = 0;
double accountReserve = 0;

string display = "\n"; 

int MaxStartTrades = 1;

double maxDD[5] = { 0,0,0,0,0 };  

double maxAccountEquity = 0;
double maxDrawDown = 0;
double averageDrawDown = 0;

int tradeNumber = 0;
int tradeNumberDD = 0;

int init(){   
   prepare(); 
   return( 0 );
}
  

double marginCalculate( string symbol, double volume ){ 
   return ( MarketInfo( symbol, MODE_MARGINREQUIRED ) * volume ) ; 
} 

void lotSize(){ 
   if( AccountEquity() > maxAccountEquity ) maxAccountEquity = AccountEquity();  
   slippage = NormalizeDouble( ( eATR / pipPoints ) * DynamicSlippage, 1 );
   marginRequirement = marginCalculate( Symbol(), BaseLotSize ); 
   lotSize = NormalizeDouble( ( AccountBalance() * MarginUsage / marginRequirement ) * BaseLotSize, 2 ) ; 
   if( lotSize < MinLots ) lotSize = MinLots; 
   
   if( lotSize > maxLotsHistory ) {
      maxLotsHistory = lotSize;
      stopCounter = 0;
   }
} 

void setPipPoint(){
   digits = MarketInfo( Symbol(), MODE_DIGITS );
   if( digits == 3 ) pipPoints = 0.010;
   else if( digits == 5 ) pipPoints = 0.00010;
} 

void closeAll( string type = "none" ){
   for( int i=OrdersTotal()-1;i>=0;i-- ) {
   if( OrderSelect( i, SELECT_BY_POS, MODE_TRADES ) == false ) break;
      if( OrderSymbol() == Symbol() ){ 
         RefreshRates();
         if( ( OrderStopLoss() == 0 && OrderProfit() > 0 && type == "profits" ) || type == "none" ){
            if( OrderType() == OP_BUY ) OrderClose( OrderTicket(), OrderLots(), Bid, slippage );
            if( OrderType() == OP_SELL ) OrderClose( OrderTicket(), OrderLots(), Ask, slippage );
         }
      }
   }
} 

void prepareHistory(){
   symbolHistory = 0;
   totalHistoryProfit = 0;
   for( int iPos = OrdersHistoryTotal() - 1 ; iPos > ( OrdersHistoryTotal() - 1 ) - totalHistory; iPos-- ){
      OrderSelect( iPos, SELECT_BY_POS, MODE_HISTORY ) ;
      double QueryHistoryDouble = ( double ) QueryHistory;
      if( symbolHistory >= QueryHistoryDouble ) break;
      if( OrderSymbol() == Symbol() ){
         totalHistoryProfit = totalHistoryProfit + OrderProfit() ;
         symbolHistory = symbolHistory + 1 ;
      }
   }
}

void prepareTrend(){
   if( eADXMain < ADXMain ) {
      rangingMarket = true;
      bullish = false;
      bearish = false;
   } else {
      rangingMarket = false; 
      if( MA1Cur < MA2Cur && eADXPlusDi > ADXMain && eADXPlusDiPrev < eADXMinusDi && Close[0] < MA2Cur ) {
         bullish = true;  
         bearish = false;
      } else if( MA1Cur > MA2Cur && eADXMinusDi > ADXMain && eADXMinusDiPrev < eADXMinusDi && Close[0] > MA2Cur ) {
         bearish = true;
         bullish = false;   
      }
   }
}

void preparePositions() {
   nearLongPosition = false;
   nearShortPosition = false;
   totalTrades = 0;
   totalBackupTrades = 0;
   totalProfit = 0;
   totalLoss = 0;
   buyLots = 0;
   sellLots = 0;
   for( int i = 0 ; i < OrdersTotal() ; i++ ) {
      if( OrderSelect( i, SELECT_BY_POS, MODE_TRADES ) == false ) break; 
      if( OrderSymbol() == Symbol() ) totalTrades = totalTrades + 1;
      if( OrderSymbol() == Symbol() && OrderComment() == "backup" ) totalBackupTrades = totalBackupTrades + 1;
      if( OrderSymbol() == Symbol() && OrderStopLoss() == 0 ) {
         if( OrderType() == OP_BUY && MathAbs( OrderOpenPrice() - Ask ) < eATR * TradeSpace ) nearLongPosition = true ;
         else if( OrderType() == OP_SELL && MathAbs( OrderOpenPrice() - Bid ) < eATR * TradeSpace ) nearShortPosition = true ;
         if( OrderType() == OP_BUY ) buyLots = buyLots + OrderLots(); 
         else if( OrderType() == OP_SELL ) sellLots = sellLots + OrderLots(); 
         if( OrderProfit() > 0 ) totalProfit = totalProfit + OrderProfit();
         else totalLoss = totalLoss + OrderProfit(); 
      }
   } 
} 

void prepareIndicators(){
   eATR = iATR( NULL, ATRTimeFrame, ATRPeriod, ATRShift ); 
   eATRPrev = iATR( NULL, ATRTimeFrame, ATRPeriod, ATRShift + ATRShiftCheck ); 
   eADXMain = iADX( NULL, ADXTimeFrame, ADXPeriod, PRICE_MEDIAN, MODE_MAIN, ADXShift ); 
   eADXPlusDi = iADX( NULL, ADXTimeFrame, ADXPeriod, PRICE_MEDIAN, MODE_PLUSDI, ADXShift );  
   eADXMinusDi = iADX( NULL, ADXTimeFrame, ADXPeriod, PRICE_MEDIAN, MODE_MINUSDI, ADXShift );    
   eADXMainPrev = iADX( NULL, ADXTimeFrame, ADXPeriod, PRICE_MEDIAN, MODE_MAIN, ADXShift + ADXShiftCheck ); 
   eADXPlusDiPrev = iADX( NULL, ADXTimeFrame, ADXPeriod, PRICE_MEDIAN, MODE_PLUSDI, ADXShift + ADXShiftCheck );  
   eADXMinusDiPrev = iADX( NULL, ADXTimeFrame, ADXPeriod, PRICE_MEDIAN, MODE_MINUSDI, ADXShift + ADXShiftCheck ); 
   MA1Cur = iMA( NULL, PERIOD_M5, MA1Period, MMAShift, MODE_SMMA, PRICE_MEDIAN, MAShift );  
   MA1Prev = iMA( NULL, PERIOD_M5, MA1Period, MMAShift, MODE_SMMA, PRICE_MEDIAN, MAShift + MAShiftCheck ); 
   MA2Cur = iMA( NULL, PERIOD_M5, MA2Period, MMAShift, MODE_SMMA, PRICE_MEDIAN, MAShift );  
   MA2Prev = iMA( NULL, PERIOD_M5, MA2Period, MMAShift, MODE_SMMA, PRICE_MEDIAN, MAShift + MAShiftCheck ); 
   
   trendStrend = MA1Cur - MA1Prev;
} 
 

void prepare(){ 
   prepareIndicators(); 
   prepareTrend();
   setPipPoint(); 
   prepareHistory();
   preparePositions(); 
   prepareDrawDown();
   lotSize();   
   update();  
} 

void openPosition(){  
   if( !nearLongPosition && bullish && sellLots == 0 ) {
      if( basketNumberType != OP_BUY ) basketCount = 0;
      if( basketCount < MaxTrades ){
         OrderSend( Symbol(), OP_BUY , lotSize, Ask, slippage, 0, 0, "basketNumber" + DoubleToStr( basketNumber, 0 ), MAGIC ) ; 
         basketCount = basketCount + 1;
         if( basketNumberType != OP_BUY ) basketNumber = basketNumber + 1; 
         basketNumberType = OP_BUY; 
         tradeNumber = tradeNumber + 1;
      } 
   } else if( !nearShortPosition && bearish && buyLots == 0 ) {
      if( basketNumberType != OP_SELL ) basketCount = 0;
      if( basketCount < MaxTrades ){
         OrderSend( Symbol(), OP_SELL, lotSize, Bid, slippage, 0, 0, "basketNumber" + DoubleToStr( basketNumber, 0 ), MAGIC ) ; 
         basketCount = basketCount + 1; 
         if( basketNumberType != OP_SELL ) basketNumber = basketNumber + 1; 
         basketNumberType = OP_SELL; 
         tradeNumber = tradeNumber + 1;
      }
   }  
} 

void backSystem(){ 
   if( ( ContinueTrading || ( !ContinueTrading && totalBackupTrades > 0 ) ) && ( totalBackupTrades < MaxTrades ) ) {
      int type = -1;
      if( bullish ) type = OP_BUY;
      else if( bearish ) type = OP_SELL; 
      if( !nearLongPosition && type == OP_BUY && sellLots == 0 ) {
         OrderSend( Symbol(), type, lotSize, Ask, slippage, 0, 0, "backup", MAGIC ) ;
         tradeNumber = tradeNumber + 1;
      } else if( !nearShortPosition && type == OP_SELL && buyLots == 0 ){
         OrderSend( Symbol(), type , lotSize, Bid, slippage, 0, 0, "backup", MAGIC ) ; 
      }
    } 
}

 

void managePositions(){
   if( totalHistoryProfit < 0 && AccountEquity() < AccountBalance() && AccountEquity() / AccountBalance() > BasketProfit ) closeAll( "profits" );
   else if( totalTrades > 1 && AccountEquity() / AccountBalance() > OpenProfit ) closeAll();
   else if( totalTrades > 0 && totalTrades <= MaxStartTrades && totalProfit > 0 && ( ( bullish && basketNumberType == OP_SELL ) || ( bearish && basketNumberType == OP_BUY ) ) ) closeAll(); 
   else { 
      for( int i = OrdersTotal() - 1; i >= 0; i-- ) {
         if( OrderSelect( i, SELECT_BY_POS, MODE_TRADES ) == false ) break;  
         if( OrderSymbol() == Symbol()  ) {  
            if( totalTrades <= MaxStartTrades ){
               if( OrderType() == OP_BUY && Bid > OrderOpenPrice() &&  OrderProfit() > MinProfit * AccountBalance() ) 
                  OrderClose( OrderTicket(), OrderLots(), Bid, slippage ); 
               else if( OrderType() == OP_SELL && Ask < OrderOpenPrice() &&  OrderProfit() > MinProfit * AccountBalance() )
                  OrderClose( OrderTicket(), OrderLots(), Ask, slippage );   
            }
         }  
      }
   }
} 

void finalStop(){ 
   if( totalHistoryProfit > MinGowth * AccountBalance() && ( totalProfit + totalLoss ) < 0 && MathAbs( totalProfit + totalLoss )  > StopLoss * totalHistoryProfit ){
      closeAll(); 
   }    
   
   if( totalHistoryProfit > MaxGowth *  AccountBalance() && totalProfit + totalLoss < 0 &&  totalProfit + totalLoss  <  MaxStop * averageDrawDown  ){
      closeAll();
      Print("MaxStop");
   } 
}

void prepareDrawDown(){
   double totalDD = 0;
   int count = 0;
   for( int i = 0; i < 5; i++ ){
      if( maxDD[i] < 0 ) {
         totalDD = totalDD + maxDD[i];
         count = count + 1;
      }
   }
   if( count > 0 ) averageDrawDown = totalDD / count;
   updateDrawDown();
}

void updateDrawDown(){
   double drawdown = ( totalProfit + totalLoss );  
   if( drawdown < maxDrawDown && tradeNumber > tradeNumberDD ) {
      maxDrawDown = drawdown; 
      maxDD[4] = maxDD[3];
      maxDD[3] = maxDD[2]; 
      maxDD[2] = maxDD[1];
      maxDD[1] = maxDD[0];
      maxDD[0] = maxDrawDown;
      tradeNumberDD = tradeNumber;
   }
}
 
void longStop(){
   double symbolHistory2 = 0;
   double totalHistoryProfit2 = 0;
    
   for( int iPos = OrdersHistoryTotal() - 1 ; iPos > ( OrdersHistoryTotal() - 1 ) - totalHistory; iPos-- ){
      OrderSelect( iPos, SELECT_BY_POS, MODE_HISTORY ) ;
      double QueryHistoryDouble2 = ( double ) QueryHistory2;
      if( symbolHistory2 >= QueryHistoryDouble2 ) break;
      if( OrderSymbol() == Symbol() ){
         totalHistoryProfit2 = totalHistoryProfit2 + OrderProfit() ;
         symbolHistory2 = symbolHistory2 + 1 ;
      }
   }
   if( symbolHistory2 >= QueryHistoryDouble2 && totalHistoryProfit2 > LongGowth && totalProfit + totalLoss < 0 && MathAbs( totalProfit + totalLoss ) > LongStop * totalHistoryProfit2 ){
      if( stopCounter < MaxStops ) closeAll();
      stopCounter = stopCounter + 1;
   } 
}
 
void update(){
   display = "";   
   display = display + " Leverage: " + DoubleToStr( AccountLeverage(), 0 ); 
   display = display + " Open: " + DoubleToStr( totalTrades, 0 );  
   display = display + " Milestones: " + DoubleToStr( milestoneCount, 0 );   
   display = display + " Next: " + DoubleToStr( nextMilestone, 0 );
   display = display + " Equity: " + DoubleToStr( AccountEquity(), 2 ); 
   display = display + " Accumulated: " + DoubleToStr( accumulatedEquity, 2 );  
   display = display + " MileEquity: " + DoubleToStr( mileEquity, 2 ); 
   display = display + " Profit: " + DoubleToStr( totalProfit, 2 );
   display = display + " Loss: " + DoubleToStr( totalLoss, 2 );    
   display = display + "\n maxDD0: " + DoubleToStr( maxDD[0], 2 );
   display = display + " maxDD1: " + DoubleToStr( maxDD[1], 2 );
   display = display + " maxDD2: " + DoubleToStr( maxDD[2], 2 );
   display = display + " maxDD3: " + DoubleToStr( maxDD[3], 2 );
   display = display + " maxDD4: " + DoubleToStr( maxDD[4], 2 );
   display = display + "\n averageDrawDown: " + DoubleToStr( averageDrawDown, 2 );
   display = display + " trendStrend: " + DoubleToStr( trendStrend, digits );
   Comment( display );
}

int start() { 
   prepare() ;  
   if( CloseAll ) closeAll() ;
   else {
      if( MathAbs( trendStrend ) < MinTrend && DayOfWeek() != 5 ){
         if( BackupSystem && totalTrades >= MaxStartTrades && AccountEquity() / AccountBalance() < TriggerBackSystem ) backSystem();
         else if( ( ContinueTrading || ( !ContinueTrading && totalTrades > 0 ) ) && ( totalTrades < MaxStartTrades || MaxStartTrades == 0 ) ) openPosition() ; 
      } 
      managePositions() ;
      finalStop();
      longStop();
   }
   return( 0 ) ;
}