//+------------------------------------------------------------------+
//|                                            MainChartReporter.mq5 |
//|                                    Copyright (c) 2019, Marketeer |
//|                            https://www.mql5.com/ru/articles/5913 |
//+------------------------------------------------------------------+
#property copyright "Copyright (c) 2019, Marketeer"
#property link      "https://www.mql5.com/en/users/marketeer"
#property version   "1.0"
#property description "Display arbitrary symbol quotes in the main window. Load and parse HTML/CSV-reports to show multi-symbol buttons and trades (trend lines) for selected symbol."


#property indicator_chart_window
#property indicator_buffers 0
#property indicator_plots   0


#include <Marketeer/GroupSettings.mqh>


input GroupSettings Common_Settings; // G E N E R A L     S E T T I N G S

input string ReportFile = ""; // · ReportFile
input string Prefix = ""; // · Prefix
input string Suffix = ""; // · Suffix
input int  TimeShift = 0; // · TimeShift


#include <Marketeer/WebDataExtractor.mqh>
#include <Marketeer/RubbArray.mqh>
#include <Marketeer/CSVReader.mqh>


#define CHART_REPORTER_MAIN
#define CHART_REPORTER_TITLE "MainChartReporter"


bool internal = false;


#include <Marketeer/ChartReporterCore.mqh>


int OnInit()
{
  if(StringFind(ReportFile, ".htm") > 0)
  {
    processor = new ReportProcessor();
  }
  else if(StringFind(ReportFile, ".csv") > 0)
  {
    processor = new HistoryProcessor();
  }
  else
  {
    Print("Unsupported or unspecified file");
    processor = new ReportProcessor(); // default
  }
  processor.apply(_Symbol);
  
  IndicatorSetString(INDICATOR_SHORTNAME, CHART_REPORTER_TITLE + " (" + _Symbol + ")");
  Comment(CHART_REPORTER_TITLE + " (" + _Symbol + ")");

  if(ReportFile != "")
  {
    EventSetTimer(1);
  }
  
  Print(__FUNCTION__);
  
  return INIT_SUCCEEDED;
}

void OnChartEvent(const int id,
                  const long& lparam,
                  const double& dparam,
                  const string& sparam)
{
  if(id != CHARTEVENT_CHART_CHANGE)
  {
    processor.onChartEvent(id, lparam, dparam, sparam);
  }
}

void OnDeinit(const int reason)
{
  Print(__FUNCTION__);
  Comment("");
  if(processor != NULL) delete processor;
}

void OnTimer()
{
  EventKillTimer();
  Print(__FUNCTION__);
  
  if(processor.isEmpty()) // load file only once
  {
    if(processor.attach(ReportFile))
    {
      processor.apply(/*keep already selected symbol*/);
      datetime start = processor.getStart();
      if(start != 0)
      {
        ChartSetInteger(ChartID(), CHART_AUTOSCROLL, false);
        // FIXME: this does not work as expected
        ChartNavigate(ChartID(), CHART_END, -1 * (iBarShift(_Symbol, _Period, start)/* - (int)ChartGetInteger(0, CHART_VISIBLE_BARS)*/));
      }
    }
    else
    {
      Print("File loading failed: ", ReportFile);
    }
  }
}

int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime& time[],
                const double& op[],
                const double& hi[],
                const double& lo[],
                const double& cl[],
                const long& tick_volume[],
                const long& volume[],
                const int& spread[])
{
  return rates_total;
}
