//+------------------------------------------------------------------+
//|                                                  StringUtils.mqh |
//|                                    Collected from public sources |
//|     StringImplode, StringPrepend, ArrayPrintString, MultiComment |
//+------------------------------------------------------------------+

string StringImplode(string &Lines[])
{
  int i, n;
  n = ArraySize(Lines);
  string Result = "";
  for(i = 0; i < n; i++)
  {
    Result = Result + Lines[i];
  }
  return(Result);
}

string StringImplodeExt(string &Lines[], const string Delimiter = "")
{
  int i, n;
  n = ArraySize(Lines);
  string Result = "";
  for(i = 0; i < n; i++)
  {
    if(StringLen(Lines[i]) > 0)
    {
      if(Result != "")
      {
        Result = Result + Delimiter + Lines[i];
      }
      else
      {
        Result = Lines[i];
      }
    }
  }
  return(Result);
}

void StringPrepend(string &v, string c, int length)
{
  if(StringLen(c) == 0) return;
  int l = StringLen(v);
  while(StringLen(v) < length)
  {
    v = c + v;
  }
}

string ArrayPrintString(string Label, string Delimiter, string FillerPrefix, double &V[], int Accuracy)
{
  int n = ArraySize(V);
  string s;
  s = Label;
  for(int i = 0; i < n; i++)
  {
    s = s + Delimiter;
    string v;
    if(V[i] != -1)
    {
      v = DoubleToString(V[i], Accuracy);
      StringPrepend(v, FillerPrefix, Accuracy + 4); // _-0.xxx
    }
    else
    {
      v = "      ";
    }
    s = s + v;
  }
  return(s);
}

/**
* use the Comment() display to simulate the behaviour of
* the good old print command, useful for debugging.
* Text will be appended as a new line on every call
* and if it has reached 20 lines it will start to scroll.
* if clear is set to True the buffer will be cleared. 
*/
void MultiComment(const string text, const bool clear = false)
{
  static string print_lines[20];
  static int print_line_position = 0;
  if(MQLInfoInteger(MQL_OPTIMIZATION))
  {
    return;
  }
  string output = "\n";
  string space  = "                        ";
  int max_lines = 20;
  int i;
  if(clear)
  {
    for(i = 0; i < max_lines; i++)
    {
      print_lines[i] = "";
      print_line_position = 0;
    }
  }

  if(print_line_position == max_lines)
  {
    for(i = 0; i < max_lines; i++)
    {
      print_lines[i] = print_lines[i+1];
    }
    print_line_position--;
  }

  print_lines[print_line_position] = text;
  print_line_position++;

  for(i = 0; i < print_line_position; i++)
  {
    output = output + print_lines[i] + "\n";
  }

  StringReplace(output, "\n", "\n" + space);
  Comment(output);
}
