//+------------------------------------------------------------------+
//|                                                    TokenType.mqh |
//|                                    Copyright (c) 2019, Marketeer |
//|                          https://www.mql5.com/en/users/marketeer |
//|                            https://www.mql5.com/ru/articles/5638 |
//+------------------------------------------------------------------+

// Scanner token-types

enum TokenType
{
  null, // should be 0-th (NULL)
  
  // Single-character tokens
  LEFT_PAREN, RIGHT_PAREN, LEFT_BRACE, RIGHT_BRACE, LEFT_BRACKET, RIGHT_BRACKET,
  COMMA, DOT, MINUS, PLUS, SEMICOLON, SLASH, STAR, DIV,
  INC, PLUS_EQUAL, DEC, MINUS_EQUAL, SLASH_EQUAL, STAR_EQUAL,
  DIV_EQUAL, BIT_XOR_EQUAL, TILDE,
  BIT_AND, BIT_OR, BIT_AND_EQUAL, BIT_OR_EQUAL, BIT_XOR, SHIFT_LEFT, SHIFT_RIGHT,
  
  QMARK, COLON,

  // One or two character tokens
  BANG, BANG_EQUAL,
  EQUAL, EQUAL_EQUAL,
  GREATER, GREATER_EQUAL,
  LESS, LESS_EQUAL,
  AND, OR,

  // Literals. Dates are formed as D'LITERAL'
  IDENTIFIER, CONST_STRING, CONST_NUMBER, CONST_INTEGER, LITERAL, CONST_DATETIME,

  // Keywords
  // Order and composition are important below - must coincide with `reserved.txt`
  
  BREAK,
  CASE,
  CLASS,
  CONST,
  CONTINUE,
  DEFAULT,
  DELETE,
  DO,
  DYNAMIC_CAST,
  ELSE,
  EXPORT,
  EXTERN,
  FALSE,
  FINAL,
  FOR,
  IF,
  IMPORT,
  INLINE,
  INPUT,
  INTERFACE,
  NEW,
  NIL,
  OPERATOR,
  OVERRIDE,
  PRIVATE,
  PROTECTED,
  PUBLIC,
  RETURN,
  SINPUT,
  SIZEOF,
  STATIC,
  STATIC_CAST,
  STRUCT,
  SWITCH,
  TEMPLATE,
  THIS,
  TRUE,
  TYPEDEF,
  TYPENAME,
  UNION,
  VIRTUAL,
  WHILE,  

  // Types
  CHAR,
  SHORT,
  INT,
  LONG,
  UCHAR,
  USHORT,
  UINT,
  ULONG,
  BOOL,
  STRING,
  DOUBLE,
  FLOAT,
  COLOR,
  DATETIME,
  ENUM,
  UNSIGNED,
  VOID,

  _DEFINE,
  _ELSE,
  _ENDIF,
  _IFDEF,
  _IFNDEF,
  _IMPORT,
  _INCLUDE,
  _PROPERTY,
  _RESOURCE,
  _UNDEF,

  EOF
};
