//+------------------------------------------------------------------+
//|                                                        Token.mqh |
//|                                    Copyright (c) 2019, Marketeer |
//|                          https://www.mql5.com/en/users/marketeer |
//|                            https://www.mql5.com/ru/articles/5638 |
//+------------------------------------------------------------------+

#include "TokenType.mqh"

class Token
{
  private:
    TokenType type;
    int line;
    int offset;
    int length;

  public:
    Token(const TokenType _type, const int _line, const int _offset, const int _length = 0)
    {
      type = _type;
      line = _line;
      offset = _offset;
      length = _length;
    }
    
    TokenType getType() const
    {
      return type;
    }
    
    int getLine() const
    {
      return line;
    }

    int getOffset() const
    {
      return offset;
    }
    
    int getLength() const
    {
      return length;
    }

    string toString(const Source *source, const int extracontext = 0) const
    {
      uint filestart = 0, fileline = line;
      string filepath = source != NULL ? source.filename(offset, filestart, fileline) : "n/a";
      return EnumToString(type)  + " (file:" + filepath + "; line:" + (string)fileline + "; offset:" + (string)(offset - filestart) + ")" + (source == NULL || length + extracontext == 0 ? "" : (" `" + source.get(offset, length + extracontext) + "`"));
    }
    
    string content(const Source *source) const
    {
      return source.get(offset, length);
    }
};
