//---------------------------------------------------------------------------
// PROJECT NAME: "Universal library to combine MetaTrader 5 & MATLAB        |
//                                                                          |
// PROJECT AUTHOR:  ANDREY EMELYANOV, nav_soft@mail.ru, 2010                |
// DEVELOPMENT ENVIRONMENT:     BORLAND C++ BUILDER 6                       |
// METATRADER VERSION:    5.0.0.257                                         |
// DLL VERSION:           0.0.1.0 (DLL training version)                    |
// HARDWARE REQUIREMENTS:  PENTIUM IV, CELERON M; RAM 256 Mb                |
// SOFTWARE REQUIREMENTS:      MATLAB R2007, MetaTrader 5                   |
//                                                                          |
//                                                          MatlabEngineLib |
//                                Copyright 2010, MetaQuotes Software Corp. |
//                                                   http://www.mql5.com/ru |
//---------------------------------------------------------------------------
// DLL CONTENTS:
//===========================================================================
//|  FUNCTION NAME             |                PURPOSE                     |
//===========================================================================
//|  mlxOpen()               | Start MATLAB virtual machine                 |
//---------------------------------------------------------------------------
//|  mlxClose()              | Close MATLAB virtual machine                 |
//---------------------------------------------------------------------------
//|  mlxInputChar()          | Input data of the char type                  |
//---------------------------------------------------------------------------
//|  mlxInputDouble()        | Input data of the double type                |
//---------------------------------------------------------------------------
//|  mlxInputInt()           | Input data of the int type                   |
//---------------------------------------------------------------------------
//|  mlxInputLogical()       | Input data of the logical type               |
//---------------------------------------------------------------------------
//|  mlxGetDouble()          | Get data of the double type                  |
//---------------------------------------------------------------------------
//|  mlxGetInt()             | Get data of the int type                     |
//---------------------------------------------------------------------------
//|  mlxGetLogical()         | Get data of the logical type                 |
//---------------------------------------------------------------------------
//|  mlxGetSizeOfName()      | Get the size of variable                     |
/*---------------------------------------------------------------------------
** PROJECT CONTENTS(= *.lib + *.def):
** libeng.lib  (from dir: <MATLAB>\extern\lib\win32\borland\)
** libmx.lib   (from dir: <MATLAB>\extern\lib\win32\borland\)
** DllUnit.def
** engine.h    (from dir: <MATLAB>\extern\include\)
---------------------------------------------------------------------------*/
#define WIN32_LEAN_AND_MEAN
#define  BUFSIZE 256
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <conio.h>
#include "engine.h"
/*---------------------------------------------------------------------------
** DLL Global Functions (external)
*/
extern "C" __declspec(dllexport) bool __stdcall mlxOpen(void);
extern "C" __declspec(dllexport) void __stdcall mlxClose(void);
extern "C" __declspec(dllexport) bool __stdcall mlxInputChar(char *CharArray);
extern "C" __declspec(dllexport) bool __stdcall mlxInputDouble(double *dArray
                                                               , int sizeArray
                                                               , char *CharNameArray);
extern "C" __declspec(dllexport) bool __stdcall mlxInputInt(double *dArray
                                                            , int sizeArray
                                                            , char *CharNameArray);
extern "C" __declspec(dllexport) bool __stdcall mlxInputLogical(double *dArray
                                                                , int sizeArray
                                                                , char *CharNameArray);
extern "C" __declspec(dllexport) int __stdcall mlxGetDouble(double *dArray
                                                            , int sizeArray
                                                            , char *CharNameArray);
extern "C" __declspec(dllexport) int __stdcall mlxGetInt(double *dArray
                                                         , int sizeArray
                                                         , char *CharNameArray);
extern "C" __declspec(dllexport) int __stdcall mlxGetLogical(double *dArray
                                                             , int sizeArray
                                                             , char *CharNameArray);
extern "C" __declspec(dllexport) int __stdcall mlxGetSizeOfName(char *CharNameArray);
/*---------------------------------------------------------------------------
** DLL Auxiliary Functions (internal)
*/
void DestrBuffer(void);
void MakeBufferIn(int nSizeIn);
/*---------------------------------------------------------------------------
** Global Variables
*/
Engine  *pEng;
mxArray *mxVectorIn;
mxArray *mxVectorOut;
int      nSizeVectorIn;

//---------------------------------------------------------------------------
int WINAPI DllEntryPoint(HINSTANCE hinst, unsigned long reason, void* lpReserved)
{//100% ready.
    /*
    ** Check the reason of call
    */
    switch(reason)
    {
        case DLL_PROCESS_ATTACH:
            /*
            ** Preparation of Global Variables
            ** Start MatLab engine virtual machine 
	    */
            pEng = NULL;
            mlxOpen();
            break;
        case DLL_PROCESS_DETACH:
            /*
            ** Delete process
            ** Stop MatLab Engine virtual machine
            */
            mlxClose();
            break;
    }
    return 1;
}
//---------------------------------------------------------------------------
bool __stdcall mlxOpen(void)
{//100% ready. Create virtual machine
 /*
 ** Check if virtual machine is started
 */
 if(pEng != NULL) return true;
 /*
 ** Initialize virtual machine
 */
 if ((pEng = engOpen(NULL)) == NULL)
 {
  MessageBoxA(NULL, (LPSTR)"Can't start MATLAB Engine!",
     	      (LPSTR) "MatLab Engine: ERROR!", MB_OK|MB_ICONSTOP);
  return false;                 //Problems with starting virtual machine
 };
 mxVectorIn    =  NULL;
 mxVectorOut   =  NULL;
 nSizeVectorIn =     0;

 return true;
}
//---------------------------------------------------------------------------
void __stdcall mlxClose(void)
{//100% ready. Delete virtual machine
 /*
 ** Deinitialize virtual machine
 */
 if(pEng != NULL)
 {
  engClose((Engine *)pEng);
  pEng    = NULL;
 };
 /*
 ** Delete input/output buffer
 */
 DestrBuffer();
 return;
}
//---------------------------------------------------------------------------
void DestrBuffer(void)
{//100% ready. Function of clearing all buffers
 if(mxVectorIn != NULL)
 {//Delete old data (don't need them)
  mxDestroyArray((mxArray *)mxVectorIn);
  mxVectorIn     = NULL;
  nSizeVectorIn  = 0;
 };
 mxVectorOut     = NULL;
 return;
}
//---------------------------------------------------------------------------
void MakeBufferIn(int nSizeIn)
{//100% ready. Function of creating input buffer
 /*
 ** Delete old buffer
 */
 if(mxVectorIn != NULL)
 {
  mxDestroyArray((mxArray *)mxVectorIn);
  mxVectorIn     = NULL;
  nSizeVectorIn  = 0;
 };
 /*
 ** Create buffers
 */
 mxVectorIn  = mxCreateDoubleMatrix(1, nSizeIn, mxREAL);
 nSizeVectorIn  = nSizeIn;                     // Getting new size of vector
 return;
}
//---------------------------------------------------------------------------
bool __stdcall mlxInputChar(char *CharArray)
{//100% ready. Function of passing command/function/text to desktop
 /*
 ** Check if virtual machine and string are present
 */
 if((pEng == NULL)&&(strlen(CharArray)<1)) return false;
 /*
 ** Enter formula into MATLAB desktop
 */
 engEvalString((Engine *)pEng, CharArray);
 return true;
}
//---------------------------------------------------------------------------
bool __stdcall mlxInputDouble(double *dArray, int sizeArray, char *CharNameArray)
{//100% ready. Function of passing variable of the double type to desktop
 /*
 ** Check if virtual machine is present
 */
 if(pEng == NULL) return false;
 /*
 ** Create buffer
 */
 MakeBufferIn(sizeArray);
 /*
 ** Creating data for processing
 ** Enter vector into MATLAB desktop
 */
 memcpy((char *)mxGetPr(mxVectorIn), (char *)dArray, (sizeArray)*8);
 engPutVariable((Engine *)pEng, (char *)CharNameArray, (mxArray *)mxVectorIn);
 return true;
}
//---------------------------------------------------------------------------
bool __stdcall mlxInputInt(double *dArray, int sizeArray, char *CharNameArray)
{//100% ready. Function of passing variable of the int type to desktop
 /*
 ** Command preparation
 */
 char szString[BUFSIZE];// command line
 ZeroMemory(szString, BUFSIZE);
 strcat(szString, CharNameArray);
 strcat(szString, (char *)"=int32(");
 strcat(szString, CharNameArray);
 strcat(szString, (char *)");");
 /*
 ** Passing data as double
 */
 if(mlxInputDouble((double *)dArray, sizeArray, (char *)CharNameArray) == false)
   return false;
 /*
 ** Sending command for data conversion
 */
 return(mlxInputChar((char *)szString));
}
//---------------------------------------------------------------------------
bool __stdcall mlxInputLogical(double *dArray, int sizeArray, char *CharNameArray)
{//100% ready. Function of passing variable of the logical type to desktop
 /*
 ** Command preparation
 */
 char szString[BUFSIZE];// command line
 ZeroMemory(szString, BUFSIZE);
 strcat(szString, CharNameArray);
 strcat(szString, (char *)"=logical(");
 strcat(szString, CharNameArray);
 strcat(szString, (char *)");");
 /*
 ** Passing data as double
 */
 if(mlxInputDouble((double *)dArray, sizeArray, (char *)CharNameArray) == false)
   return false;
 /*
 ** Sending command for data conversion
 */
 return(mlxInputChar((char *)szString));
}
//---------------------------------------------------------------------------
int __stdcall mlxGetDouble(double *dArray, int sizeArray, char *CharNameArray)
{//100% ready. Function of getting variable of the double type from desktop
 /*
 ** Check if virtual machine is present
 */
 if(pEng == NULL) return 0;
 /*
 ** The response output from MATLAB desktop
 ** Return the calculated vector from virtual machine
 */
 if(((mxArray *)mxVectorOut = engGetVariable((Engine *)pEng, CharNameArray))== NULL)
   return 0;
 memcpy((char *)dArray, (char *)mxGetPr(mxVectorOut), (sizeArray)*8);
 return sizeArray;
}
//---------------------------------------------------------------------------
int __stdcall mlxGetInt(double *dArray, int sizeArray, char *CharNameArray)
{//100% ready. Function of getting variable of the int type from desktop
 /*
 ** Commands preparation
 */
 char szString1[BUFSIZE];// command line 1
 char szString2[BUFSIZE];// command line 2
 ZeroMemory(szString1, BUFSIZE);
 ZeroMemory(szString2, BUFSIZE);
 strcat(szString1, CharNameArray);
 strcat(szString1, (char *)"=double(");
 strcat(szString1, CharNameArray);
 strcat(szString1, (char *)");");
 strcat(szString2, CharNameArray);
 strcat(szString2, (char *)"=int32(");
 strcat(szString2, CharNameArray);
 strcat(szString2, (char *)");");
 /*
 ** Sending command for data conversion
 */
 if(mlxInputChar((char *)szString1) == false) return 0;
 /*
 ** The response output from MATLAB desktop
 */
 if(mlxGetDouble((double *)dArray, sizeArray, (char *)CharNameArray) < 1)
 {
  mlxInputChar((char *)szString2);
  return 0;
 };
 /*
 ** Sending command for data conversion
 */
 if(mlxInputChar((char *)szString2) == false) return 0;
 return sizeArray;
}
//---------------------------------------------------------------------------
int __stdcall mlxGetLogical(double *dArray, int sizeArray, char *CharNameArray)
{//100% ready. Function of getting variable of the logical type from desktop
 /*
 ** Commands preparation
 */
 char szString1[BUFSIZE];// command line 1
 char szString2[BUFSIZE];// command line 2
 ZeroMemory(szString1, BUFSIZE);
 ZeroMemory(szString2, BUFSIZE);
 strcat(szString1, CharNameArray);
 strcat(szString1, (char *)"=double(");
 strcat(szString1, CharNameArray);
 strcat(szString1, (char *)");");
 strcat(szString2, CharNameArray);
 strcat(szString2, (char *)"=logical(");
 strcat(szString2, CharNameArray);
 strcat(szString2, (char *)");");
 /*
 ** Sending command for data conversion
 */
 if(mlxInputChar((char *)szString1) == false) return 0;
 /*
 ** The response output from MATLAB desktop
 */
 if(mlxGetDouble((double *)dArray, sizeArray, (char *)CharNameArray) < 1)
 {
  mlxInputChar((char *)szString2);
  return 0;
 };
 /*
 ** Sending command for data conversion
 */
 if(mlxInputChar((char *)szString2) == false) return 0;
 return sizeArray;
}
//---------------------------------------------------------------------------
int __stdcall mlxGetSizeOfName(char *CharNameArray)
{//100% ready. Function of getting variable size.
 /*
 ** Function variables
 */
 char szString1[BUFSIZE];// command line
 char szString2[BUFSIZE];// variable name, that contains the size of array
 double dArray[2];
 int iSize = 0;
 /*
 ** Check if virtual machine is present
 */
 if(pEng == NULL) return 0;
 /*
 ** Commands preparation
 */
 dArray[0] = 0;
 dArray[1] = 0;
 ZeroMemory(szString1, BUFSIZE);
 ZeroMemory(szString2, BUFSIZE);
 strcat(szString1, (char *)"nSize = length(");
 strcat(szString1, CharNameArray);
 strcat(szString1, (char *)");");//  SizeOfName = double(SizeOfName);
 strcat(szString2, (char *)"nSize");
 /*
 ** Sending commands
 */
 if(mlxInputChar((char *)szString1) == false) return 0;
 /*
 ** The response output from MATLAB desktop
 */
 if(mlxGetDouble((double *)dArray, 1, (char *)szString2) < 1) return 0;
 iSize = dArray[0];
 return(iSize);
}
//---------------------------------------------------------------------------
