//+------------------------------------------------------------------+
//|                                               volatilityTest.mq5 |
//|                        Copyright 2010, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "denkir"
#property link      "denkir@gmail.com"
#property version   "1.00"
#property script_show_inputs

#include <Random_class.mqh>
#include <Object.mqh>
#include <ExpStatistics_class.mqh>
#include <Trade\SymbolInfo.mqh>
#import "shell32.dll"
int ShellExecuteW(int hwnd,string lpOperation,string lpFile,string lpParameters,
                  string lpDirectory,int nShowCmd);
#import

input long len=500;    //Number of Bars
input bool save=false; //Write returns data
input Dist_type dist; //Distribution Type
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   double Arr[],Arr_out[],p;
   int filehandle,digs;
   ArrayResize(Arr,(int)len);
//Volatility write
   if(save)
     {
      CSymbolInfo m_smbinf; // CSymbolInfo class instance
      m_smbinf.Refresh();
      m_smbinf.RefreshRates(); // refresh symbol info
      m_smbinf.Name("EURUSD");// Gets/sets the financial instrument name
      digs=m_smbinf.Digits();
      MqlRates rates[];

      ArraySetAsSeries(rates,true);
      double nVolat[];
      //datetime nTime[];

      ArrayResize(nVolat,(int)len);
      //ArrayResize(nTime,len);

      int copied=CopyRates("EURUSD",PERIOD_H4,1,(int)len,rates);
      if(copied>0)
         Print("Bars copied: "+IntegerToString(copied));
      else
         Print("Failed to get historical data regarding the symbol","EURUSD");
      for(int i=0;i<len;i++)
        {
         nVolat[i]=NormalizeDouble(pow(10.,digs)*(rates[i].high-rates[i].low),0);
         //nTime[i]=rates[i].time;
        }
      ArraySetAsSeries(nVolat,true);
      //ArraySetAsSeries(nTime,true);
      filehandle=FileOpen("Volat.csv",FILE_CSV|FILE_WRITE);
      if(filehandle!=INVALID_HANDLE)
        {
         for(int i=0;i<len;i++)
           {
            string Str2;
            Str2=DoubleToString(nVolat[i],1)+" \n";
            FileWriteString(filehandle,Str2);
           }
         FileClose(filehandle);
         Print("FileOpen OK");
        }
      else Print("FileOpen action failed, error",GetLastError());
     }
   else //Volatility read
     {
      filehandle=FileOpen("Volat.csv",FILE_READ|FILE_CSV);
      string str1;
      if(filehandle!=INVALID_HANDLE)
        {
         for(int i=0;i<len;i++)
           {
            str1=FileReadString(filehandle);
            Arr[i]=StringToDouble(str1);
           }
         FileClose(filehandle);
         Print("Volat FileRead OK");
         
         CExpStatistics eSt;
         eSt.setCExpStatistics(Arr);
         //Testing the series
         eSt.ZeroCheckArray(true);
         eSt.outlierDelete();
         eSt.pArrOutput(Arr_out);
         
         // Static series preparation   
         int intervals,
         y=ArraySize(Arr_out);
         intervals=Sturges(y); //number of classes
         double f[]; ArrayResize(f,intervals); //array of observations by classes
         double b[]; ArrayResize(b,intervals); //class midpoints
         Allocate(Arr_out,y,f,b,intervals); //allocation of observations to classes

         histogramSave(f,b);
         string path=TerminalInfoString(TERMINAL_DATA_PATH)+"\\MQL5\\Files\\Histogram.htm";
         ShellExecuteW(NULL,"open",path,NULL,NULL,1);

         jarqueberatest(Arr_out,p);
         Print("The Jarque-Bera test: "+"probability of rejecting a true null hypothesis is "+DoubleToString(p,4));
         //----chi square testing    
         double ebins[],df,chsq,prob;
         const int knstrn=1;
         //Selected distribution  
         estimateDistribution(eSt,dist,ebins,f,b,y,intervals);
         //---
         chsone(f,ebins,df,chsq,prob,knstrn);
         Print("Chi-square statistic: "+DoubleToString(chsq,2)+"; "+
               "probability of rejecting a true null hypothesis: "+DoubleToString(prob,4));
         histogramSaveE(f,b,y,ebins,dist);
         path=TerminalInfoString(TERMINAL_DATA_PATH)+"\\MQL5\\Files\\Histogram2.htm";
         ShellExecuteW(NULL,"open",path,NULL,NULL,1);
        }
      else Print("FileOpen action failed, error",GetLastError());
     }
  }
//+------------------------------------------------------------------+
