//+------------------------------------------------------------------+
//|                                                  returnsTest.mq5 |
//|                        Copyright 2010, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "denkir"
#property link      "denkir@gmail.com"
#property version   "1.00"

#property script_show_inputs

#include <Random_class.mqh>
#include <Object.mqh>
#include <ExpStatistics_class.mqh>
#include <Trade\SymbolInfo.mqh>
#import "shell32.dll"
int ShellExecuteW(int hwnd,string lpOperation,string lpFile,string lpParameters,
                  string lpDirectory,int nShowCmd);
#import

input long len=500;    //Number of Bars
input bool save=false; //Write returns data
input Dist_type dist; //Distribution Type
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   double Arr[],Arr_out[],p;
   int filehandle,hRI;
   ArrayResize(Arr,(int)len);

//Returns write
   if(save)
     {
      double rets1[],//rets1 - initial array of N length,
      rets[];        //rets - alternate array of N-1 length
      ArrayResize(rets1,(int)len+1);ArrayResize(rets,(int)len);;
      hRI=iCustom("EURUSD",PERIOD_H4,"ReturnsIndicator");
      if(CopyBuffer(hRI,0,0,(int)len+1,rets1)<1)
        {
         Print("Copying of indicator buffer failed!");
         return;
        }
      if(ArrayCopy(rets,rets1,0,1,(int)len)<1)
        {
         Print("Copying of returns array failed!");
         return;
        }
      CExpStatistics Re;
      Re.setCExpStatistics(rets);
      Re.outlierDelete();
      Re.pArrOutput(Arr_out,true);
      filehandle=FileOpen("Returns_std.csv",FILE_CSV|FILE_WRITE);
      if(filehandle!=INVALID_HANDLE)
        {
         for(int i=0;i<len;i++)
           {
            string Str2;
            Str2=DoubleToString(Arr_out[i],4)+" \n";
            FileWriteString(filehandle,Str2);
           }
         FileClose(filehandle);
         Print("FileOpen OK");
        }
      else Print("FileOpen action failed, error",GetLastError());
     }
   else
     {
      filehandle=FileOpen("Returns_std.csv",FILE_READ|FILE_CSV);
      string str1;
      if(filehandle!=INVALID_HANDLE)
        {
         for(int i=0;i<len;i++)
           {
            //Arr[i]=StringToDouble(FileReadString(filehandle));
            str1=FileReadString(filehandle);
            //Arr[i]=StringToDouble(StringSubstr(str1,0,StringFind(str1,',')-1));
            Arr[i]=StringToDouble(str1);
           }
         FileClose(filehandle);
         Print("Returns_std FileRead OK");
         CExpStatistics eSt;
         eSt.setCExpStatistics(Arr);
         //Descriptive statistics
         double var,es,mm,med,me;
         var=eSt.expVariance(true);
         es=eSt.expKurtosis(true,me);
         mm=eSt.mean(true); //mean for raw series
         med=eSt.median(true);
         // Static series preparation   
         int intervals,
         y=ArraySize(Arr);
         intervals=Sturges(y); //number of classes
         double f[]; ArrayResize(f,intervals); //array of observations by classes
         double b[]; ArrayResize(b,intervals); //class midpoints
         Allocate(Arr,y,f,b,intervals); //allocation of observations to classes

         histogramSave(f,b);
         string path=TerminalInfoString(TERMINAL_DATA_PATH)+"\\MQL5\\Files\\Histogram.htm";
         ShellExecuteW(NULL,"open",path,NULL,NULL,1);
         //Jarque-Bera Test
         jarqueberatest(Arr,p);
         Print("The Jarque-Bera test: "+"probability of rejecting a true null hypothesis is "+DoubleToString(p,4));
         //----chi square testing    
         double ebins[],df,chsq,prob;
         const int knstrn=1;
         //Selected distribution  
         estimateDistribution(eSt,dist,ebins,f,b,y,intervals);
         //---
         chsone(f,ebins,df,chsq,prob,knstrn);
         Print("Chi-square statistic: "+DoubleToString(chsq,2)+"; "+
               "probability of rejecting a true null hypothesis: "+DoubleToString(prob,4));
         histogramSaveE(f,b,y,ebins,dist);
         path=TerminalInfoString(TERMINAL_DATA_PATH)+"\\MQL5\\Files\\Histogram2.htm";
         ShellExecuteW(NULL,"open",path,NULL,NULL,1);
        }
      else Print("FileOpen action failed, error",GetLastError());
     }
  }
//-----------------------------------------------------------------------------------
// Save file for histogram
//-----------------------------------------------------------------------------------
void histogramSave2(double &f[],double &b[],int y,CExpStatistics &E,Dist_type Dist)
/*
   f  calculated array of observations allocated to classes;
	b  array of class midpoints;
	y - sample size;
	E - Expected Statistics object;
	Dist - distribution type.
*/
  {
   int fhandle;
   string title,str;
   title="var title=\""+"Histogram and pdf for "+EnumToString(Dist)+" Distribution\";";
   ResetLastError();
   fhandle=FileOpen("dataHist2.txt",FILE_WRITE|FILE_TXT|FILE_ANSI);
   if(fhandle<0){Print("File open failed, error ",GetLastError());return;}
   str="var data=[";
   int len1=ArraySize(f);
   for(int i=0;i<len1-1;i++)
      str+="["+DoubleToString(NormalizeDouble(b[i],2),2)+","+DoubleToString(NormalizeDouble(f[i]/y,5),5)+"],";
   str+="["+DoubleToString(NormalizeDouble(b[len1-1],2),2)+","+DoubleToString(NormalizeDouble(f[len1-1]/y,5),5)+"]];";
   FileWriteString(fhandle,title+"\n");
   FileWriteString(fhandle,str+"\n");

//=== pdf ===
   string str1;
   str1="var pdf=[";
   double nn=0.,mCenter,exVar;
   mCenter=E.meanCenter(0);
   exVar=E.expVariance(0);

   CDistributionFigure F;
   double Xx1,Xx2,Sst=0.05;
   if(dist==0 || dist==2) //(Normal,Lognormal,Cauchy,Hypersec,Studentt)
     {
      Xx1=mCenter-5.0*exVar/1.25;//Normal,Cauchy
      Xx2=mCenter+5.0*exVar/1.25;
     }
   else if(dist==1)
     {
      Xx1=0.001;
      Xx2=7.75;
     }
   else //Hypersec,Studentt
     {
      Xx1=mCenter-5.0*exVar;
      Xx2=mCenter+5.0*exVar;
     }
   F.setDistribution(dist,0,Xx1,Xx2,Sst);
   F.calculateDistribution(nn,mCenter,exVar);
   int len2=ArraySize(F.xAr);
   for(int i=1;i<len2-1;i++)
      str1+="["+DoubleToString(NormalizeDouble(F.xAr[i],5),5)+","+DoubleToString(NormalizeDouble(F.p1[i],6),6)+"],";
   str1+="["+DoubleToString(NormalizeDouble(F.xAr[len2-1],5),5)+","+DoubleToString(NormalizeDouble(F.p1[len2-1],6),6)+"]];";
   FileWriteString(fhandle,str1+"\n");
   FileClose(fhandle);
  }
//-----------------------------------------------------------------------------------
// Save file for histogram
//-----------------------------------------------------------------------------------
void histogramSave2(double &f[],double &b[],int y,CExpStatistics &E,Dist_type Dist,bool A)
/*
   f  calculated array of observations allocated to classes;
	b  array of class midpoints;
	y - sample size;
	E - Expected Statistics object;
	Dist - distribution type.
*/
  {
   int fhandle;
   string title,str;
   title="var title=\""+"Histogram and pdf for "+EnumToString(Dist)+" Distribution\";";
   ResetLastError();
   fhandle=FileOpen("dataHist2.txt",FILE_WRITE|FILE_TXT|FILE_ANSI);
   if(fhandle<0){Print("File open failed, error ",GetLastError());return;}
   str="var data=[";
   int len1=ArraySize(f);
   for(int i=0;i<len1-1;i++)
      str+="["+DoubleToString(NormalizeDouble(b[i],2),2)+","+DoubleToString(NormalizeDouble(f[i]/y,5),5)+"],";
   str+="["+DoubleToString(NormalizeDouble(b[len1-1],2),2)+","+DoubleToString(NormalizeDouble(f[len1-1]/y,5),5)+"]];";
   FileWriteString(fhandle,title+"\n");
   FileWriteString(fhandle,str+"\n");

//=== pdf ===
   string str1;
   str1="var pdf=[";
   double nn=0.,mCenter,exVar;
   mCenter=E.meanCenter(A);
   exVar=E.expVariance(A);
//nn???
   CDistributionFigure F;
   double Xx1,Xx2,Sst=0.05;
   if(dist==0 || dist==2) //(Normal,Lognormal,Cauchy,Hypersec,Studentt)
     {
      Xx1=mCenter-5.0*exVar/1.25;//Normal,Cauchy
      Xx2=mCenter+5.0*exVar/1.25;
     }
   else if(dist==1)
     {
      Xx1=0.001;
      Xx2=7.75;
     }
   else //Hypersec,Studentt
     {
      Xx1=mCenter-5.0*exVar;
      Xx2=mCenter+5.0*exVar;
     }
   F.setDistribution(dist,0,Xx1,Xx2,Sst);
   F.calculateDistribution(nn,mCenter,exVar);
   int len2=ArraySize(F.xAr);
   for(int i=1;i<len2-1;i++)
      str1+="["+DoubleToString(NormalizeDouble(F.xAr[i],5),5)+","+DoubleToString(NormalizeDouble(F.p1[i],6),6)+"],";
   str1+="["+DoubleToString(NormalizeDouble(F.xAr[len2-1],5),5)+","+DoubleToString(NormalizeDouble(F.p1[len2-1],6),6)+"]];";
   FileWriteString(fhandle,str1+"\n");
   FileClose(fhandle);
  }
//+------------------------------------------------------------------+
