//+------------------------------------------------------------------+
//|                                             ReturnsIndicator.mq5 |
//|                        Copyright 2010, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "denkir"
#property link      "denkir@gmail.com"
#property version   "1.00"
#property description "This indicator calculates returns on assets"
#property description "by the formula: r_t= ln(P_t/P_(t-1) )"


#property indicator_separate_window
#property indicator_buffers 1
#property indicator_plots   1
//---- plot Returns
#property indicator_label1  "Returns"
#property indicator_type1   DRAW_LINE
#property indicator_color1  Blue
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1

//--- indicator buffers
double         ReturnsBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,ReturnsBuffer,INDICATOR_DATA);
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,      // price[] array size
                const int prev_calculated,  // number of available bars at the previous call
                const int begin,            // price[] array index from which valid data starts
                const double& price[])      // array based on which the indicator will be calculated

  {
//---
   int start;
   if(prev_calculated<2) start=1;  // begin filling ReturnsBuffer[] starting from the 1st index 
   else start=prev_calculated-1;    // set start equal to the last index in arrays

   for(int i=start;i<rates_total;i++)
     {
      ReturnsBuffer[i]=MathLog(price[i]/price[i-1]);
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
