//+------------------------------------------------------------------+
//|                                                   randomTest.mq5 |
//|                        Copyright 2010, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "denkir"
#property link      "denkir@gmail.com"
#property version   "1.00"

#property script_show_inputs

#include <Random_class.mqh>
#include <Object.mqh>
#include <ExpStatistics_class.mqh>
#include <Trade\SymbolInfo.mqh>
#import "shell32.dll"
int ShellExecuteW(int hwnd,string lpOperation,string lpFile,string lpParameters,
                  string lpDirectory,int nShowCmd);
#import
//(Normal,Lognormal,Cauchy,Hypersec,Studentt,Logistic,Exponential,Gamma,Beta)
input Dist_type dist;  //Distribution Type
input long len=100;    //Sample size
input bool save=false; //Write sample data
input int nn1=1;        //Nu
input double mm1=0.,    //Mu
ss1=1.;    //Sigma
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   double Arr[],Arr_out[],p;
   int filehandle;
   ArrayResize(Arr,(int)len);

//Randoms write
   if(save)
     {
      //Randoms generate   
      RandomGenerate(Arr,dist);
      filehandle=FileOpen("Randoms.csv",FILE_CSV|FILE_WRITE);
      if(filehandle!=INVALID_HANDLE)
        {
         for(int i=0;i<len;i++)
           {
            string Str2;
            Str2=DoubleToString(Arr[i],4)+" \n";
            FileWriteString(filehandle,Str2);
           }
         FileClose(filehandle);
         Print("FileOpen OK");
        }
      else Print("FileOpen action failed, error",GetLastError());
     }
   else
     {
      filehandle=FileOpen("Randoms.csv",FILE_READ|FILE_CSV);
      string str1;
      if(filehandle!=INVALID_HANDLE)
        {
         for(int i=0;i<len;i++)
           {
            str1=FileReadString(filehandle);
            Arr[i]=StringToDouble(str1);
           }
         FileClose(filehandle);
         Print("Randoms FileRead OK");
         // Static series preparation   
         int intervals,
         y=ArraySize(Arr);
         intervals=Sturges(y); //number of classes
         double f[]; ArrayResize(f,intervals); //array of observations by classes
         double b[]; ArrayResize(b,intervals); //class midpoints
         Allocate(Arr,y,f,b,intervals); //allocation of observations to classes

         histogramSave(f,b);
         string path=TerminalInfoString(TERMINAL_DATA_PATH)+"\\MQL5\\Files\\Histogram.htm";
         ShellExecuteW(NULL,"open",path,NULL,NULL,1);
         if(dist!=4) //if(dist!=4 && dist!=10 && dist!=11)
           {
            //Testing
            CExpStatistics eSt;
            eSt.setCExpStatistics(Arr);
            //Testing the series
            eSt.outlierDelete();
            eSt.pArrOutput(Arr_out);
            jarqueberatest(Arr_out,p);
            Print("The Jarque-Bera test: "+"probability of rejecting a true null hypothesis is "+DoubleToString(p,4));
            //----chi square testing    
            double ebins[],df,chsq,prob;
            const int knstrn=1;
            //Selected distribution  
            estimateDistribution(eSt,dist,ebins,f,b,y,intervals);
            chsone(f,ebins,df,chsq,prob,knstrn);
            Print("Chi-square statistic: "+DoubleToString(chsq,2)+"; "+
                  "probability of rejecting a true null hypothesis: "+DoubleToString(prob,4));
            histogramSaveE(f,b,y,ebins,dist);
            path=TerminalInfoString(TERMINAL_DATA_PATH)+"\\MQL5\\Files\\Histogram2.htm";
            ShellExecuteW(NULL,"open",path,NULL,NULL,1);
           }
        }
     }
  }
//+------------------------------------------------------------------+
//|       Random Generate from the specified distribution            |
//+------------------------------------------------------------------+
void RandomGenerate(double &Arr[],Dist_type dist1)
/*
  Arr - input array;
  dist - distribution type.
*/
  {
   switch(dist1)
     {
      case 0:
        {
         CNormaldev dN;
         CNormaldist N;
         long j; j=fCounter();
         N.mu=mm1;
         N.sig=ss1;
         dN.setNormaldev(N,j);
         for(int i=0;i<len;i++)
            Arr[i]=dN.dev();
         Print(IntegerToString(ArraySize(Arr))+ " Normal deviates generated from X~Nor("+DoubleToString(N.mu,2)+", "+DoubleToString(N.sig,2)+");");
         break;
        }
      case 1:
        {
         CLognormaldev dLg;
         CLognormaldist Lg;
         long j; j=fCounter();
         Lg.mu=mm1;
         Lg.sig=ss1;
         dLg.setLognormaldev(Lg,j);
         for(int i=0;i<len;i++)
            Arr[i]=dLg.dev();
         Print(IntegerToString(ArraySize(Arr))+ " Lognormal deviates generated from X~Logn("+DoubleToString(Lg.mu,2)+", "+DoubleToString(Lg.sig,2)+");");
         break;
        }
      case 2:
        {
         CCauchydev dCau;
         CCauchydist Cau;
         long j; j=fCounter();
         Cau.mu=mm1;
         Cau.sig=ss1;
         dCau.setCauchydev(Cau,j);
         for(int i=0;i<len;i++)
            Arr[i]=dCau.dev();
         Print(IntegerToString(ArraySize(Arr))+ " Cauchy deviates generated from X~Cau("+DoubleToString(Cau.mu,2)+", "+DoubleToString(Cau.sig,2)+");");
         break;
        }
      case 3:
        {
         CHypersecdev dHy;
         CHypersecdist Hy;
         long j; j=fCounter();
         Hy.mu=mm1;
         Hy.sig=ss1;
         dHy.setHypersecdev(Hy,(uint)j);
         for(int i=0;i<len;i++)
            Arr[i]=dHy.dev();
         Print(IntegerToString(ArraySize(Arr))+ " Hyperbolic Secant deviates generated from X~HS("+DoubleToString(Hy.mu,2)+", "+DoubleToString(Hy.sig,2)+");");
         break;
        }
      case 4:
        {
         CStudenttdev dSt;
         CStudenttdist St;
         long j; j=fCounter();
         St.setCStudenttdist(nn1,mm1,ss1);
         dSt.setStudenttdev(St,j);
         for(int i=0;i<len;i++)
            Arr[i]=dSt.dev();
         Print(IntegerToString(ArraySize(Arr))+ " Studentt deviates generated from t~Stt("+DoubleToString(St.nu,2)+", "+DoubleToString(St.mu,2)+", "+DoubleToString(St.sig,2)+");");
         break;
        }
      case 5:
        {
         CLogisticdev dLo;
         CLogisticdist Lo;
         long j; j=fCounter();
         Lo.alph=mm1;
         Lo.bet=ss1;
         dLo.setLogisticdev(Lo,j);
         for(int i=0;i<len;i++)
            Arr[i]=dLo.dev();
         Print(IntegerToString(ArraySize(Arr))+ " Logistic deviates generated from X~Logi("+DoubleToString(Lo.alph,2)+", "+DoubleToString(Lo.bet,2)+");");
         break;
        }
      case 6:
        {
         CExpondev dEx;
         CExpondist Ex;
         long j; j=fCounter();
         Ex.lambda=mm1;
         dEx.setExpondev(Ex,j);
         for(int i=0;i<len;i++)
            Arr[i]=dEx.dev();
         Print(IntegerToString(ArraySize(Arr))+ " Exponential deviates generated from X~Exp("+DoubleToString(Ex.lambda,2)+");");
         break;
        }
      case 7:
        {
         CGammadev dGa;
         CGammadist Ga;
         long j; j=fCounter();
         Ga.setCGammadist(mm1,ss1);
         dGa.setGammadev(Ga,j);
         for(int i=0;i<len;i++)
            Arr[i]=dGa.dev();
         Print(IntegerToString(ArraySize(Arr))+ " Gamma deviates generated from X~Gam("+DoubleToString(Ga.alph,2)+", "+DoubleToString(Ga.bet,2)+");");
         break;
        }
      case 8:
        {
         CBetadev dBe;
         CBetadist Be;
         long j; j=fCounter();
         Be.setCBetadist(mm1,ss1);
         dBe.setBetadev(Be,j);
         for(int i=0;i<len;i++)
            Arr[i]=dBe.dev();
         Print(IntegerToString(ArraySize(Arr))+ " Beta deviates generated from X~Beta("+DoubleToString(Be.alph,2)+", "+DoubleToString(Be.bet,2)+");");
         break;
        }
      case 9:
        {
         CLaplacedev dLap;
         CLaplacedist Lap;
         long j; j=fCounter();
         Lap.alph=mm1;
         Lap.bet=ss1;
         dLap.setLaplacedev(Lap,(uint)j);
         for(int i=0;i<len;i++)
            Arr[i]=dLap.dev();
         Print(IntegerToString(ArraySize(Arr))+ " Laplace deviates generated from X~Lap("+DoubleToString(Lap.alph,2)+", "+DoubleToString(Lap.bet,2)+");");
         break;
        }
      case 10:
        {
         CBinomialdev dBi;
         CBinomialdist Bi;
         long j; j=fCounter();
         Bi.setCBinomialdist((int)mm1,ss1);
         dBi.setBinomialdev(Bi,j);
         for(int i=0;i<len;i++)
            Arr[i]=dBi.dev();
         Print(IntegerToString(ArraySize(Arr))+ " Binomial deviates generated from k~Bin("+DoubleToString(Bi.n,0)+", "+DoubleToString(Bi.pe,2)+");");
         break;
        }
      case 11:
        {
         CPoissondev dPo;
         CPoissondist Po;
         long j; j=fCounter();
         Po.lambda=mm1;
         dPo.setPoissondev(Po,j);
         for(int i=0;i<len;i++)
            Arr[i]=dPo.dev();
         Print(IntegerToString(ArraySize(Arr))+ " Poisson deviates generated from k~Pois("+DoubleToString(Po.lambda,2)+");");
         break;
        }
     }
  }
//+------------------------------------------------------------------+
