//+------------------------------------------------------------------+
//|                                                       fitAll.mq5 |
//|                        Copyright 2010, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "denkir"
#property link      "denkir@gmail.com"
#property version   "1.00"

#property script_show_inputs

#include <Random_class.mqh>
#include <Object.mqh>
#include <ExpStatistics_class.mqh>
#include <Trade\SymbolInfo.mqh>
#import "shell32.dll"
int ShellExecuteW(int hwnd,string lpOperation,string lpFile,string lpParameters,
                  string lpDirectory,int nShowCmd);
#import
//(Normal,Lognormal,Cauchy,Hypersec,Studentt,Logistic,Exponential,Gamma,Beta)
input Dist_type dist;  //Distribution Type
input long len=100;    //Sample size
input bool save=false; //Write sample data
input int nn1=1;        //Nu
input double mm1=0.,    //Mu
ss1=1.;    //Sigma
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   double Arr[],Arr_out[];
   int filehandle;
   ArrayResize(Arr,(int)len);
   if(save)//Randoms write
     {
      RandomGenerate(Arr,dist);//Randoms generate 
      filehandle=FileOpen("Randoms.csv",FILE_CSV|FILE_WRITE);
      if(filehandle!=INVALID_HANDLE)
        {
         for(int i=0;i<len;i++)
           {
            string Str2;
            Str2=DoubleToString(Arr[i],4)+" \n";
            FileWriteString(filehandle,Str2);
           }
         FileClose(filehandle);
         Print("FileOpen OK");
        }
      else Print("FileOpen action failed, error",GetLastError());
     }
   else //Randoms read
     {
      filehandle=FileOpen("Randoms.csv",FILE_READ|FILE_CSV);
      string str1;
      if(filehandle!=INVALID_HANDLE)
        {
         for(int i=0;i<len;i++)
           {
            str1=FileReadString(filehandle);
            Arr[i]=StringToDouble(str1);
           }
         FileClose(filehandle);
         Print("Randoms FileRead OK");
         if(dist!=4)
           {
            //Testing
            CExpStatistics eSt;
            eSt.setCExpStatistics(Arr);

            fitDistributions(eSt);
            string path=TerminalInfoString(TERMINAL_DATA_PATH)+"\\MQL5\\Files\\chi_test.htm";
            ShellExecuteW(NULL,"open",path,NULL,NULL,1);
           }
        }
     }
  }
//+------------------------------------------------------------------+
//|              Fit all the available distributions                 |
//+------------------------------------------------------------------+
void fitDistributions(CExpStatistics &E)
/*
   1) E - CExpStatistics class instance.   
*/
  {
//---histogram
   double jp,Arr_out[];
   E.outlierDelete();
   E.ZeroCheckArray(true);
   E.pArrOutput(Arr_out);
   jarqueberatest(Arr_out,jp);
   Print("The Jarque-Bera test: "+"probability of rejecting a true null hypothesis is "+DoubleToString(jp,4));   
// Static series preparation   
   int intervals,
   y=ArraySize(Arr_out);
   intervals=Sturges(y); //number of classes
   double f[]; ArrayResize(f,intervals); //array of observations by classes
   double b[]; ArrayResize(b,intervals); //class midpoints
   Allocate(Arr_out,y,f,b,intervals); //allocation of observations to classes
   int fhandle;
   string title,str;
   title="var title=\""+"Histogram"+"\";";
   ResetLastError();
   fhandle=FileOpen("dataFitAll.txt",FILE_WRITE|FILE_TXT|FILE_ANSI);
   if(fhandle<0){Print("File open failed, error ",GetLastError());return;}
   str="var data=[";
   int Len=ArraySize(f);
   for(int i=0;i<Len-1;i++)
      str+="["+DoubleToString(NormalizeDouble(b[i],2),2)+","+DoubleToString(NormalizeDouble(f[i],1),1)+"],";
   str+="["+DoubleToString(NormalizeDouble(b[Len-1],2),2)+","+DoubleToString(NormalizeDouble(f[Len-1],1),1)+"]];";
   FileWriteString(fhandle,title+"\n");
   FileWriteString(fhandle,str+"\n");
//---histogram_end

   double f1[],ebins[],df,chsq,prob,max,min,pVals_arr[12];
   ArrayFill(pVals_arr,0,12,0.0);
   ArrayResize(f1,ArraySize(f));ArrayCopy(f1,f);
   const int knstrn=1;
   Dist_type Dist=0;
   max=Arr_out[ArrayMaximum(Arr_out)];
   min=Arr_out[ArrayMinimum(Arr_out)];

//(Normal #0,Lognormal #1,Cauchy #2,Hypersec #3,Studentt #4,Logistic #5,
// Exponential #6,Gamma #7,Beta #8,Laplace #9,Binomial #10,Poisson #11)

   for(int i=0;i<12;i++)
     {
      if((i==4) || ((i==1 || i==6 || i==7 || i==10 || i==11) && min<0.) || (i==8 && (min<0. || max>1.)))
         //denial condition for Lognormal,Studentt,Exponential,Gamma,Beta,Binomial,Poisson
        {
         printDeny(Dist);
         Dist++;
         continue;
        }
      estimateDistribution(E,Dist,ebins,f1,b,y,intervals);
      chsone(f1,ebins,df,chsq,prob,knstrn);
      pVals_arr[i]=prob;

      Print(EnumToString(Dist)+" distribution: Chi-square statistic: "+DoubleToString(chsq,2)+"; "+
            "probability of rejecting a true null hypothesis: "+DoubleToString(prob,4));
      //reset
      ArrayFree(ebins);
      ArrayFree(f1);
      ArrayCopy(f1,f);
      df=0;chsq=prob=0.;
      Dist++; //next distribution
     }
//write pVals_arr
   string str1[12];
   str1[0]="var pNor="+DoubleToString(NormalizeDouble(pVals_arr[0],4),4)+";";
   str1[1]="var pLogn="+DoubleToString(NormalizeDouble(pVals_arr[1],4),4)+";";
   str1[2]="var pCau="+DoubleToString(NormalizeDouble(pVals_arr[2],4),4)+";";
   str1[3]="var pHS="+DoubleToString(NormalizeDouble(pVals_arr[3],4),4)+";";
   str1[4]="var pStt="+DoubleToString(NormalizeDouble(pVals_arr[4],4),4)+";";
   str1[5]="var pLogi="+DoubleToString(NormalizeDouble(pVals_arr[5],4),4)+";";
   str1[6]="var pExp="+DoubleToString(NormalizeDouble(pVals_arr[6],4),4)+";";
   str1[7]="var pGam="+DoubleToString(NormalizeDouble(pVals_arr[7],4),4)+";";
   str1[8]="var pBeta="+DoubleToString(NormalizeDouble(pVals_arr[8],4),4)+";";
   str1[9]="var pLap="+DoubleToString(NormalizeDouble(pVals_arr[9],4),4)+";";
   str1[10]="var pBin="+DoubleToString(NormalizeDouble(pVals_arr[10],4),4)+";";
   str1[11]="var pPois="+DoubleToString(NormalizeDouble(pVals_arr[11],4),4)+";";
   for(int i=0;i<12;i++)FileWriteString(fhandle,str1[i]+"\n");
//Desriptive statistics
   int SampleSize;
   double mean_stat,median_stat,stD_stat,var_stat,intqR_stat,kurt_stat,skew_stat;
   bool pros;
   SampleSize=ArraySize(Arr_out);
   mean_stat=E.mean(false);
   median_stat=E.median(false);
   stD_stat=E.expStddev(false);
   var_stat=E.expVariance(false);
   intqR_stat=E.interqtlRange(false);
   kurt_stat=E.expKurtosis(false,skew_stat);
   pros=E.isProcessed;
//write Desriptive statistics
   string str2[9];
   str2[0]="var SampleSize="+IntegerToString(SampleSize)+";";
   str2[1]="var mean_stat="+DoubleToString(NormalizeDouble(mean_stat,4),4)+";";
   str2[2]="var median_stat="+DoubleToString(NormalizeDouble(median_stat,4),4)+";";
   str2[3]="var stD_stat="+DoubleToString(NormalizeDouble(stD_stat,4),4)+";";
   str2[4]="var var_stat="+DoubleToString(NormalizeDouble(var_stat,4),4)+";";
   str2[5]="var intqR_stat="+DoubleToString(NormalizeDouble(intqR_stat,4),4)+";";
   str2[6]="var kurt_stat="+DoubleToString(NormalizeDouble(kurt_stat,4),4)+";";
   str2[7]="var skew_stat="+DoubleToString(NormalizeDouble(skew_stat,4),4)+";";
   str2[8]="var pros="+IntegerToString(pros)+";";
   for(int i=0;i<9;i++)FileWriteString(fhandle,str2[i]+"\n");
//best fit
   int fg=ArrayMaximum(pVals_arr);
   Dist_type Dist2=0;
   Dist2+=fg;
   estimateDistribution(E,Dist2,ebins,f1,b,y,intervals);
   chsone(f1,ebins,df,chsq,prob,knstrn);
   string title2,str3,str4;
   title2="var title2=\""+"Histogram: observed vs. expected for "+EnumToString(Dist2)+" Distribution\";";
   str3="var data2=[";
   int len1=ArraySize(f);
   for(int i=0;i<len1-1;i++)
      str3+="["+DoubleToString(NormalizeDouble(b[i],2),2)+","+DoubleToString(NormalizeDouble(f[i]/y,5),5)+"],";
   str3+="["+DoubleToString(NormalizeDouble(b[len1-1],2),2)+","+DoubleToString(NormalizeDouble(f[len1-1]/y,5),5)+"]];";
   FileWriteString(fhandle,title2+"\n");
   FileWriteString(fhandle,str3+"\n");
//---ebins
   str4="var pdf=[";
   int len2=ArraySize(ebins);
   for(int i=0;i<len2-1;i++)
      str4+="["+DoubleToString(NormalizeDouble(b[i],2),2)+","+DoubleToString(NormalizeDouble(ebins[i]/y,3),3)+"],";
   str4+="["+DoubleToString(NormalizeDouble(b[len2-1],2),2)+","+DoubleToString(NormalizeDouble(ebins[len2-1]/y,3),3)+"]];";
   FileWriteString(fhandle,str4+"\n");
   //---   
   string str5;
   str5="var jp="+DoubleToString(jp,4)+";";
   FileWriteString(fhandle,str5+"\n");
   FileClose(fhandle);
  }
//+------------------------------------------------------------------+
//|                   Print estimation denial                        |
//+------------------------------------------------------------------+
void printDeny(Dist_type Dist)
  {
   Print(EnumToString(Dist)+" distribution cannot be estimated!");
  }
//+------------------------------------------------------------------+
//|       Random Generate from the specified distribution            |
//+------------------------------------------------------------------+
void RandomGenerate(double &Arr[],Dist_type dist1)
/*
  Arr - input array;
  dist - distribution type.
*/
  {
   switch(dist1)
     {
      case 0:
        {
         CNormaldev dN;
         CNormaldist N;
         long j; j=fCounter();
         N.mu=mm1;
         N.sig=ss1;
         dN.setNormaldev(N,j);
         for(int i=0;i<len;i++)
            Arr[i]=dN.dev();
         Print(IntegerToString(ArraySize(Arr))+" Normal deviates generated from X~Nor("+DoubleToString(N.mu,2)+", "+DoubleToString(N.sig,2)+");");
         break;
        }
      case 1:
        {
         CLognormaldev dLg;
         CLognormaldist Lg;
         long j; j=fCounter();
         Lg.mu=mm1;
         Lg.sig=ss1;
         dLg.setLognormaldev(Lg,j);
         for(int i=0;i<len;i++)
            Arr[i]=dLg.dev();
         Print(IntegerToString(ArraySize(Arr))+" Lognormal deviates generated from X~Logn("+DoubleToString(Lg.mu,2)+", "+DoubleToString(Lg.sig,2)+");");
         break;
        }
      case 2:
        {
         CCauchydev dCau;
         CCauchydist Cau;
         long j; j=fCounter();
         Cau.mu=mm1;
         Cau.sig=ss1;
         dCau.setCauchydev(Cau,j);
         for(int i=0;i<len;i++)
            Arr[i]=dCau.dev();
         Print(IntegerToString(ArraySize(Arr))+" Cauchy deviates generated from X~Cau("+DoubleToString(Cau.mu,2)+", "+DoubleToString(Cau.sig,2)+");");
         break;
        }
      case 3:
        {
         CHypersecdev dHy;
         CHypersecdist Hy;
         long j; j=fCounter();
         Hy.mu=mm1;
         Hy.sig=ss1;
         dHy.setHypersecdev(Hy,(uint)j);
         for(int i=0;i<len;i++)
            Arr[i]=dHy.dev();
         Print(IntegerToString(ArraySize(Arr))+" Hyperbolic Secant deviates generated from X~HS("+DoubleToString(Hy.mu,2)+", "+DoubleToString(Hy.sig,2)+");");
         break;
        }
      case 4:
        {
         CStudenttdev dSt;
         CStudenttdist St;
         long j; j=fCounter();
         St.setCStudenttdist(nn1,mm1,ss1);
         dSt.setStudenttdev(St,j);
         for(int i=0;i<len;i++)
            Arr[i]=dSt.dev();
         Print(IntegerToString(ArraySize(Arr))+" Studentt deviates generated from t~Stt("+DoubleToString(St.nu,2)+", "+DoubleToString(St.mu,2)+", "+DoubleToString(St.sig,2)+");");
         break;
        }
      case 5:
        {
         CLogisticdev dLo;
         CLogisticdist Lo;
         long j; j=fCounter();
         Lo.alph=mm1;
         Lo.bet=ss1;
         dLo.setLogisticdev(Lo,j);
         for(int i=0;i<len;i++)
            Arr[i]=dLo.dev();
         Print(IntegerToString(ArraySize(Arr))+" Logistic deviates generated from X~Logi("+DoubleToString(Lo.alph,2)+", "+DoubleToString(Lo.bet,2)+");");
         break;
        }
      case 6:
        {
         CExpondev dEx;
         CExpondist Ex;
         long j; j=fCounter();
         Ex.lambda=mm1;
         dEx.setExpondev(Ex,j);
         for(int i=0;i<len;i++)
            Arr[i]=dEx.dev();
         Print(IntegerToString(ArraySize(Arr))+" Exponential deviates generated from X~Exp("+DoubleToString(Ex.lambda,2)+");");
         break;
        }
      case 7:
        {
         CGammadev dGa;
         CGammadist Ga;
         long j; j=fCounter();
         Ga.setCGammadist(mm1,ss1);
         dGa.setGammadev(Ga,j);
         for(int i=0;i<len;i++)
            Arr[i]=dGa.dev();
         Print(IntegerToString(ArraySize(Arr))+" Gamma deviates generated from X~Gam("+DoubleToString(Ga.alph,2)+", "+DoubleToString(Ga.bet,2)+");");
         break;
        }
      case 8:
        {
         CBetadev dBe;
         CBetadist Be;
         long j; j=fCounter();
         Be.setCBetadist(mm1,ss1);
         dBe.setBetadev(Be,j);
         for(int i=0;i<len;i++)
            Arr[i]=dBe.dev();
         Print(IntegerToString(ArraySize(Arr))+" Beta deviates generated from X~Beta("+DoubleToString(Be.alph,2)+", "+DoubleToString(Be.bet,2)+");");
         break;
        }
      case 9:
        {
         CLaplacedev dLap;
         CLaplacedist Lap;
         long j; j=fCounter();
         Lap.alph=mm1;
         Lap.bet=ss1;
         dLap.setLaplacedev(Lap,(uint)j);
         for(int i=0;i<len;i++)
            Arr[i]=dLap.dev();
         Print(IntegerToString(ArraySize(Arr))+" Laplace deviates generated from X~Lap("+DoubleToString(Lap.alph,2)+", "+DoubleToString(Lap.bet,2)+");");
         break;
        }
      case 10:
        {
         CBinomialdev dBi;
         CBinomialdist Bi;
         long j; j=fCounter();
         Bi.setCBinomialdist((int)mm1,ss1);
         dBi.setBinomialdev(Bi,j);
         for(int i=0;i<len;i++)
            Arr[i]=dBi.dev();
         Print(IntegerToString(ArraySize(Arr))+" Binomial deviates generated from k~Bin("+DoubleToString(Bi.n,0)+", "+DoubleToString(Bi.pe,2)+");");
         break;
        }
      case 11:
        {
         CPoissondev dPo;
         CPoissondist Po;
         long j; j=fCounter();
         Po.lambda=mm1;
         dPo.setPoissondev(Po,j);
         for(int i=0;i<len;i++)
            Arr[i]=dPo.dev();
         Print(IntegerToString(ArraySize(Arr))+" Poisson deviates generated from k~Pois("+DoubleToString(Po.lambda,2)+");");
         break;
        }
     }
  }
//+------------------------------------------------------------------+
