//+------------------------------------------------------------------+
//|                                          ExpStatistics_class.mqh |
//|                                                           denkir |
//|                                                 denkir@gmail.com |
//+------------------------------------------------------------------+
#property copyright "denkir"
#property link      "denkir@gmail.com"

#include <DistributionFigure_class.mqh>

//+------------------------------------------------------------------+
//|             Expected Statistics class definition                 |
//+------------------------------------------------------------------+
class CExpStatistics
  {
private:
   double            arr[];      //initial array
   int               N;          //initial array size
   double            Parr[];     //processed array
   int               pN;         //processed array size
   void              stdz(double &outArr_st[],bool A); //standardization
public:
   void              setArrays(bool A,double &Arr[],int &n); //set array for processing
   bool              isProcessed;  //Array processed?
   void              CExpStatistics(){};  //constructor   
   void              setCExpStatistics(double &Arr[]); //set initial array for a class
   void              ZeroCheckArray(bool A); //check the input array for zero elements
   int               get_arr_N();           //get the initial array length
   double            median(bool A);   //median
   double            median50(bool A); //median of 50% interquantile range (midquartile range)
   double            mean(bool A);     //mean of the entire initial sample
   double            mean50(bool A);   //mean of 50% interquantile range
   double            interqtlRange(bool A); //interquartile range
   double            RangeCenter(bool A); //range center
   double            meanCenter(bool A);  //mean of the top five estimates
   double            expVariance(bool A); //estimated variance
   double            expSampleVariance(bool A); //shifted estimate of sample variance
   double            expStddev(bool A);   //estimated standard deviation
   double            Moment(int index,bool A,int sw,double xm); //moment of distribution
   double            expKurtosis(bool A,double &Skewness); ////estimated kurtosis and skewness
   double            censorR(bool A); //censoring coefficient
   int               outlierDelete(); //deletion of outliers from the sample 
   int               pArrOutput(double &outArr[],bool St); //processed array output
   void              ~CExpStatistics(){};//destructor
  };
//+------------------------------------------------------------------+
//|                 Get arr length method                            |
//+------------------------------------------------------------------+  
int CExpStatistics::get_arr_N()
  {
   return N;
  }
//+------------------------------------------------------------------+
//|                 ZeroCheckArray method                            |
//+------------------------------------------------------------------+
void CExpStatistics::ZeroCheckArray(bool A)
//Replace zeros with means
  {
   int n;
   double Arr[];
   setArrays(A,Arr,n);
   for(int i=0;i<n;i++)
      if(!MathIsValidNumber(Arr[i])) //if(!MathIsValidNumber(log(Arr[i])))
        {
         Print("Arr["+IntegerToString(i)+"] is not valid.");
         if(A) arr[i]=mean(A);
         else  Parr[i]=mean(A);
        }
  }
//+------------------------------------------------------------------+
//|             Set method for class CExpStatistics                  |
//+------------------------------------------------------------------+
void CExpStatistics::setCExpStatistics(double &Arr[])
  {
   ArrayCopy(arr,Arr);
   N=ArraySize(arr);
  }
//+------------------------------------------------------------------+
//|                     median method                                |
//+------------------------------------------------------------------+
double CExpStatistics::median(bool A)
  {
   int n;
   double res=0.0,Arr[];
   setArrays(A,Arr,n);
   ArraySort(Arr);
   if(n%2==0)
      res=(Arr[n/2-1]+Arr[n/2])/2;
   else
      res=(Arr[n/2]);
   return(res);
  }
//+------------------------------------------------------------------+
//|             setArrays method for class CExpStatistics            |
//+------------------------------------------------------------------+
void CExpStatistics::setArrays(bool A,double &Arr[],int &n)
  {
   if(A)
     {
      ArrayResize(Arr,ArraySize(arr));
      ArrayCopy(Arr,arr);
      n=N;
     }
   else
     {
      ArrayResize(Arr,ArraySize(Parr));
      ArrayCopy(Arr,Parr);
      n=pN;
     }
  }
//+------------------------------------------------------------------+
//|                     median50 method                              |
//+------------------------------------------------------------------+
double CExpStatistics::median50(bool A)
  {
   int n,m;
   double Arr[];
   setArrays(A,Arr,n);
   ArraySort(Arr);
   m=n/4;
   return((Arr[m]+Arr[n-m-1])/2);
  }
//+------------------------------------------------------------------+
//|                      mean method                                 |
//+------------------------------------------------------------------+
double CExpStatistics::mean(bool A)
  {
   int n;
   double Arr[];
   setArrays(A,Arr,n);
   double Sum=0.0;
   for(int i=0; i<n; i++)
      Sum+=Arr[i];
   return(Sum/n);
  }
//+------------------------------------------------------------------+
//|                      mean50 method                               |
//+------------------------------------------------------------------+
double CExpStatistics::mean50(bool A)
  {
   int n,m,q;
   double Sum=0.,Arr[];
   setArrays(A,Arr,n);
   ArraySort(Arr);
   m=n/4;
   q=n-m;
   for(int i=m; i<q; i++)
      Sum+=Arr[i];
   return(Sum/(n-2*m));
  }
//+------------------------------------------------------------------+
//|            Interquartile Range method                            |
//+------------------------------------------------------------------+
double CExpStatistics::interqtlRange(bool A)
  {
   int n,q1,q3;
   double Arr[],Q1,Q3,dif1,dif3,resd1,resd3;
   setArrays(A,Arr,n);
   ArraySort(Arr);
   Q1=(n+2)/4.; //Q1=(n+1)/4.;
   Q3=(3*n+2)/4.; //Q3=3*(n+1)/4.
   q1=(int)Q1;
   q3=(int)Q3;
   if(ceil(Q1)>Q1)
     {
      dif1=Arr[q1+1]-Arr[q1];
      resd1=Q1-floor(Q1);
      Q1=Arr[q1]+resd1*dif1;
     }
   else
      Q1=Arr[q1];
   if(ceil(Q3)>Q3)
     {
      dif3=Arr[q3+1]-Arr[q3];
      resd3=Q3-floor(Q3);
      Q3=Arr[q3]+resd3*dif3;
     }
   else
      Q3=Arr[q3];
   return Q3-Q1;
  }
//+------------------------------------------------------------------+
//|                    RangeCenter method                            |
//+------------------------------------------------------------------+
double CExpStatistics::RangeCenter(bool A)
  {
   int n;
   double res,Arr[];
   setArrays(A,Arr,n);
   ArraySort(Arr);
   res=(Arr[0]+Arr[n-1])/2;
   return(res);
  }
//+------------------------------------------------------------------+
//|                 meanCenter  method                               |
//+------------------------------------------------------------------+
double CExpStatistics::meanCenter(bool A)
  {
   double array[5];
   array[0]=median(A);
   array[1]=median50(A);
   array[2]=mean(A);
   array[3]=mean50(A);
   array[4]=RangeCenter(A);
   ArraySort(array);
   return(array[2]);
  }
//+------------------------------------------------------------------+
//|             Expected variance method                             |
//+------------------------------------------------------------------+
double CExpStatistics::expVariance(bool A)
//Variance (using corrected two-pass algorithm)
  {
   int n;
   double MX,v1,v2,variance,Arr[];
   MX=meanCenter(A);
   setArrays(A,Arr,n);
   v1=0.;
   for(int i=0; i<=n-1; i++)
      v1=v1+pow(Arr[i]-MX,2.);
   v2=0.;
   for(int i=0; i<=n-1; i++)
      v2=v2+(Arr[i]-MX);
   v2=pow(v2,2.)/n;
   variance=(v1-v2)/(n-1);
   if(variance<0.)
      variance=0.;
   return variance;
  }
//+------------------------------------------------------------------+
//|            Expected sample variance method                       |
//+------------------------------------------------------------------+
double CExpStatistics::expSampleVariance(bool A)
//Variance (using corrected two-pass algorithm)
  {
   int n;
   double MX,v1,variance,Arr[];
   MX=meanCenter(A);
   setArrays(A,Arr,n);
   v1=0.;
   for(int i=0; i<=n-1; i++)
      v1=v1+pow(Arr[i]-MX,2.);
   variance=v1/n;
   if(variance<0.)
      variance=0.;
   return variance;
  }
//+------------------------------------------------------------------+
//|            Expected standard deviation method                    |
//+------------------------------------------------------------------+
double CExpStatistics::expStddev(bool A)
//Standard deviation
  {
   double var=expVariance(A);
   return sqrt(var);
  }
//+------------------------------------------------------------------+
//|             Expected kurtosis and skewness method                |
//+------------------------------------------------------------------+
double CExpStatistics::expKurtosis(bool A,double &Skewness)
//Kurtosis,Skewness
  {
   int n;
   double v,v2,std,mn,Kurtosis=0.,Arr[];
   setArrays(A,Arr,n);
   std=expStddev(A);
   mn=mean(A);
   if(std!=0.)
     {
      for(int i=0;i<n-1;i++)
        {
         v=(Arr[i]-mn)/std;
         v2=pow(v,2.);
         Skewness=Skewness+v2*v;
         Kurtosis=Kurtosis+pow(v2,2.);
        }
      Skewness=Skewness/n;
      Kurtosis=Kurtosis/n-3.;
     }
   return Kurtosis;
  }
//+------------------------------------------------------------------+
//|                    Standardize method                            |
//+------------------------------------------------------------------+
void  CExpStatistics::stdz(double &outArr_st[],bool A)
  {
   int h;
   double Arr[];
   setArrays(A,Arr,h);
   ArrayResize(outArr_st,ArraySize(Arr));
   double Mean=mean(A),
   std=sqrt(expVariance(A));
   for(int i=0;i<ArraySize(Arr);i++)
      outArr_st[i]=(Arr[i]-Mean)/std;
  }
//+------------------------------------------------------------------+
//|                 Censoring ratio method                           |
//+------------------------------------------------------------------+
double CExpStatistics::censorR(bool A)
  {
   double eKurt,k,h,me;
   eKurt=expKurtosis(A,me);
   k=0.8*log10((double)N/10);
   h=sqrt(eKurt-1);
   if(!MathIsValidNumber(h))
      h=0.;
   return 1.55+k*h;
  }
//+------------------------------------------------------------------+
//|                  Delete outliers method                          |
//+------------------------------------------------------------------+
int CExpStatistics::outlierDelete()
  {
   int    mini=-1,
   maxi=-1,
   m=0;
   double expVar,sig,G,Gsig,min,max,MX;
   bool A=true;                        // clearing the initial array so A=true
   expVar=expVariance(A);
   MX=meanCenter(A);
   sig=sqrt(expVar);
   G=censorR(A);
   Gsig=G*sig;
   min=MX-Gsig;
   max=MX+Gsig;
   for(int i=N-1; maxi<0; i--)
      if(arr[i]<=max)
         maxi=N-1-i;
   for(int i=0; mini<0; i++)
      if(arr[i]>=min)
         mini=i;
   m=N-mini-maxi;
   ArrayResize(Parr,m);
   pN=m;
   for(int i=0; i<m; i++)
      Parr[i]=arr[i+mini];
   if(pN<N)
     {
      isProcessed=true;
      Print("Outliers deleted!");
     }
   return(pN);
  }
//+------------------------------------------------------------------+
//|                  Processed array output method                   |
//+------------------------------------------------------------------+
int CExpStatistics::pArrOutput(double &outArr[],bool St=false)
  {
   ArrayResize(outArr,ArraySize(Parr));
   if(St)
     {
      stdz(outArr,false);
      return ArraySize(outArr);
     }
   else
      return(ArrayCopy(outArr,Parr));
  }
//+------------------------------------------------------------------+
//|                    Moment method                                 |
//+------------------------------------------------------------------+
double CExpStatistics::Moment(int index,bool A,int sw,double xm)
/*
  Distribution moment calculation function.
  Symbols:
   index  order of the distribution moment,
   //x  initial sample,
   sw  type of the distribution moment:
     sw = 0  central moment calculation, no need to set xm,
     sw = 1  conditional moment calculation, set xm = C (C - arbitrary number),
          calculation of the moment about zero, set xm = 0,
     xm  calculated value of the mean (when sw = 0),
  n  sample size.
  Return value:
  distribution moment value.
*/
  {
   int i,j; // Counters
   int n;
   double Arr[];
   setArrays(A,Arr,n);
//int n=ArraySize(x);
   double s=0,// Initial value of the sum
   temp;      // Auxiliary value
              // Calculation of the mean
   if(sw==0)
      xm=mean(A);
// Calculation of the moment
   for(i=0; i<n; i++)
     {
      temp=Arr[i]-xm;
      for(j=1; j<index; j++)
         temp*=Arr[i]-xm;
      s+=temp;
     }
   return s/n;
  }
//+------------------------------------------------------------------+
//|                    Covariance function                           |
//+------------------------------------------------------------------+
double Cov(double &x[],double &y[])
/*
  The function calculates covariance value.
  Symbols:
  x  first compared sample,
  y  second compared sample,
  n  size of each sample.
  Return value:
  covariance value.
*/
  {
   int n=ArraySize(x);
   int i; // Loop counter

   double xm,// Mean value x
   ym,      // Mean value y
   s = 0;   // Auxiliary variable
   xm = mean(x);
   ym = mean(y);
   for(i=0;i<n;i++)
      s+=(x[i]-xm)*(y[i]-ym);
   return s/(n-1);
  }
//+------------------------------------------------------------------+
//|                     Mean function                                |
//+------------------------------------------------------------------+
double mean(double &X[])
  {
   int Len=ArraySize(X);
   double sum=0;
   for(int g=0;g<Len;g++)
      sum+=X[g];
   return(sum/Len);
  }
//+------------------------------------------------------------------+
//|                     Mean function                                |
//+------------------------------------------------------------------+
double mean(double &Arr[],int n)
  {
   double Sum=0.0;
   for(int i=0; i<n; i++)
      Sum+=Arr[i];
   return(Sum/n);
  }
//+------------------------------------------------------------------+
//                   The Jarque-Bera Test                            | 
//+------------------------------------------------------------------+
void jarqueberatest(double &x[],double &p)
/*
  The Jarque-Bera test is used to check hypothesis about the fact that
   a given sample xS  is a sample of normal random variable with unknown 
   mean and variance.
   Variables:
     x - sample Xs;
     p - p-value;
*/
  {
   int n=ArraySize(x);
   double s;
   p=0.;
   if(n<5)//N is too small
     {
      p=1.0;
      return;
     }
//N is large enough
   jarquebera_jarqueberastatistic(x,n,s);
   p=jarquebera_jarqueberaapprox(n,s);
  }
//+------------------------------------------------------------------+
//|                  The Jarque-Bera Statistic                       |
//+------------------------------------------------------------------+
void jarquebera_jarqueberastatistic(double &x[],int n,double &s)
  {
   int i;
   double v;
   double v1;
   double v2;
   double stddev;
   double mean;
   double variance;
   double skewness;
   double kurtosis;

   s=0;

   mean=0;
   variance = 0;
   skewness = 0;
   kurtosis = 0;
   stddev=0;

   if(n<=1) Alert("Not enough data!");
   mean=mean(x,n);//Mean
                  //Variance (using corrected two-pass algorithm)
   if(n!=1)
     {
      v1=0;
      for(i=0; i<=n-1; i++)
         v1=v1+pow(x[i]-mean,2.);
      v2=0;
      for(i=0; i<=n-1; i++)
         v2=v2+(x[i]-mean);
      v2=pow(v2,2.)/n;
      variance=(v1-v2)/(n-1);
      if(variance<0.)
         variance=0.;
      stddev=sqrt(variance);
     }
//Skewness and kurtosis  
   if(stddev!=0.)
     {
      for(i=0; i<=n-1; i++)
        {
         v=(x[i]-mean)/stddev;
         v2=pow(v,2.);
         skewness = skewness+v2*v;
         kurtosis = kurtosis+pow(v2,2.);
        }
      skewness = skewness/n;
      kurtosis = kurtosis/n-3;
     }
//Statistic
   s=(double)n/(double)6.*(pow(skewness,2.)+pow(kurtosis,2.)/4);
  }
//+------------------------------------------------------------------+
//|              Approximation of the Jarque-Bera                    |
//+------------------------------------------------------------------+
double jarquebera_jarqueberaapprox(int n,double s)
  {
   double vx[];
   double vy[];
   double t1;
   double t2;
   double t3;
   double t;
   double f1;
   double f2;
   double f3;
   double f12;
   double f23;
   double x;
   double result;
   result=1.;
   x=s;
   if(n<5)
     {
      return result;
     }
//N = 5..20 are tabulated
   if(n>=5 && n<=20)
     {
      if(n==5)
        {
         result=exp(jarquebera_jbtbl5(x)); //todo         
        }
      if(n==6)
        {
         result=exp(jarquebera_jbtbl6(x));
        }
      if(n==7)
        {
         result=exp(jarquebera_jbtbl7(x));
        }
      if(n==8)
        {
         result=exp(jarquebera_jbtbl8(x));
        }
      if(n==9)
        {
         result=exp(jarquebera_jbtbl9(x));
        }
      if(n==10)
        {
         result=exp(jarquebera_jbtbl10(x));
        }
      if(n==11)
        {
         result=exp(jarquebera_jbtbl11(x));
        }
      if(n==12)
        {
         result=exp(jarquebera_jbtbl12(x));
        }
      if(n==13)
        {
         result=exp(jarquebera_jbtbl13(x));
        }
      if(n==14)
        {
         result=exp(jarquebera_jbtbl14(x));
        }
      if(n==15)
        {
         result=exp(jarquebera_jbtbl15(x));
        }
      if(n==16)
        {
         result=exp(jarquebera_jbtbl16(x));
        }
      if(n==17)
        {
         result=exp(jarquebera_jbtbl17(x));
        }
      if(n==18)
        {
         result=exp(jarquebera_jbtbl18(x));
        }
      if(n==19)
        {
         result=exp(jarquebera_jbtbl19(x));
        }
      if(n==20)
        {
         result=exp(jarquebera_jbtbl20(x));
        }
      return result;
     }
/*N = 20, 30, 50 are tabulated.
     In-between values are interpolated
     using interpolating polynomial of the second degree.
     */
   if(n>20 && n<=50)
     {
      t1 = -1.0/20.0;
      t2 = -1.0/30.0;
      t3 = -1.0/50.0;
      t=-1.0/n;
      f1 = jarquebera_jbtbl20(x);
      f2 = jarquebera_jbtbl30(x);
      f3 = jarquebera_jbtbl50(x);
      f12 = ((t-t2)*f1+(t1-t)*f2)/(t1-t2);
      f23 = ((t-t3)*f2+(t2-t)*f3)/(t2-t3);
      result=((t-t3)*f12+(t1-t)*f23)/(t1-t3);
      if(result>0.)
         result=0.;
      result=exp(result);
      return result;
     }
/*
     N = 50, 65, 100 are tabulated.
     In-between values are interpolated
     using interpolating polynomial of the second degree.
   */
   if(n>50 && n<=100)
     {
      t1 = -1.0/50.0;
      t2 = -1.0/65.0;
      t3 = -1.0/100.0;
      t=-1.0/n;
      f1 = jarquebera_jbtbl50(x);
      f2 = jarquebera_jbtbl65(x);
      f3 = jarquebera_jbtbl100(x);
      f12 = ((t-t2)*f1+(t1-t)*f2)/(t1-t2);
      f23 = ((t-t3)*f2+(t2-t)*f3)/(t2-t3);
      result=((t-t3)*f12+(t1-t)*f23)/(t1-t3);
      if(result>0.)
         result=0.;
      result=exp(result);
      return result;
     }
/*
     * N = 100, 130, 200 are tabulated.
     * In-between values are interpolated
     * using interpolating polynomial of the second degree.
     */
   if(n>100 && n<=200)
     {
      t1 = -1.0/100.0;
      t2 = -1.0/130.0;
      t3 = -1.0/200.0;
      t=-1.0/n;
      f1 = jarquebera_jbtbl100(x);
      f2 = jarquebera_jbtbl130(x);
      f3 = jarquebera_jbtbl200(x);
      f12 = ((t-t2)*f1+(t1-t)*f2)/(t1-t2);
      f23 = ((t-t3)*f2+(t2-t)*f3)/(t2-t3);
      result=((t-t3)*f12+(t1-t)*f23)/(t1-t3);
      if(result>0.)
         result=0.;
      result=exp(result);
      return result;
     }
/*
     * N = 200, 301, 501 are tabulated.
     * In-between values are interpolated
     * using interpolating polynomial of the second degree.
     */
   if(n>200 && n<=501)
     {
      t1 = -1.0/200.0;
      t2 = -1.0/301.0;
      t3 = -1.0/501.0;
      t=-1.0/n;
      f1 = jarquebera_jbtbl200(x);
      f2 = jarquebera_jbtbl301(x);
      f3 = jarquebera_jbtbl501(x);
      f12 = ((t-t2)*f1+(t1-t)*f2)/(t1-t2);
      f23 = ((t-t3)*f2+(t2-t)*f3)/(t2-t3);
      result=((t-t3)*f12+(t1-t)*f23)/(t1-t3);
      if(result>0.)
         result=0.;
      result=exp(result);
      return result;
     }
/*
     * N = 501, 701, 1401 are tabulated.
     * In-between values are interpolated
     * using interpolating polynomial of the second degree.
     */
   if(n>501 && n<=1401)
     {
      t1 = -1.0/501.0;
      t2 = -1.0/701.0;
      t3 = -1.0/1401.0;
      t=-1.0/n;
      f1 = jarquebera_jbtbl501(x);
      f2 = jarquebera_jbtbl701(x);
      f3 = jarquebera_jbtbl1401(x);
      f12 = ((t-t2)*f1+(t1-t)*f2)/(t1-t2);
      f23 = ((t-t3)*f2+(t2-t)*f3)/(t2-t3);
      result=((t-t3)*f12+(t1-t)*f23)/(t1-t3);
      if(result>0.)
         result=0.;
      result=exp(result);
      return result;
     }
//Asymptotic expansion
   if(n>1401)
     {
      result=-0.5*x+(jarquebera_jbtbl1401(x)+0.5*x)*sqrt((double)1401./(double)n);
      if(result>0.)
         result=0.;
      result=exp(result);
      return result;
     }
   return result;
  }
//+------------------------------------------------------------------+
//|                   Jarquebera tabulated5                          |
//+------------------------------------------------------------------+
double jarquebera_jbtbl5(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;
   result=0.;
   if(s<=0.4000)
     {
      x=2*(s-0.000000)/0.400000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x,-1.097885e-20,tj,tj1,result);
      jarquebera_jbcheb(x, -2.854501e-20, tj, tj1, result);
      jarquebera_jbcheb(x, -1.756616e-20, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=1.1000)
     {
      x=2*(s-0.400000)/0.700000-1.;
      tj=1.;
      tj1=x;
      jarquebera_jbcheb(x, -1.324545e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.075941e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -9.772272e-01, tj, tj1, result);
      jarquebera_jbcheb(x,3.175686e-01,tj,tj1,result);
      jarquebera_jbcheb(x,-1.576162e-01, tj, tj1, result);
      jarquebera_jbcheb(x, 1.126861e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -3.434425e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -2.790359e-01, tj, tj1, result);
      jarquebera_jbcheb(x,2.809178e-02,tj,tj1,result);
      jarquebera_jbcheb(x,-5.479704e-01, tj, tj1, result);
      jarquebera_jbcheb(x, 3.717040e-02, tj, tj1, result);
      jarquebera_jbcheb(x,-5.294170e-01, tj, tj1, result);
      jarquebera_jbcheb(x, 2.880632e-02, tj, tj1, result);
      jarquebera_jbcheb(x,-3.023344e-01, tj, tj1, result);
      jarquebera_jbcheb(x, 1.601531e-02, tj, tj1, result);
      jarquebera_jbcheb(x,-7.920403e-02, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   result=-5.188419e+02*(s-1.100000e+00)-4.767297e+00;
   return result;
  }
//+------------------------------------------------------------------+
//|       Chebyshev approximation of the Jarque-Bera CDF             |
//+------------------------------------------------------------------+
void jarquebera_jbcheb(double x,double c,double &tj,double &tj1,double &r)
/*
  This function adds c*x to r and updates tj and tj1 in such way, that tj1 
  is now equal to tj, and tj stores valye of (j+1)-th Chebyshev polynomial.
  Variables:
    x - point of calculation;
    c - coefficient;
    tj - j-th Chebyshev polynomial;
    tj1 - previous (j-1)-th Chebyshev polynomial;
    r - accumulator variable;
*/
  {
   double t;
   r=r+c*tj;
   t = 2.*x*tj1-tj;
   tj=tj1;
   tj1=t;
  }
//+------------------------------------------------------------------+
//|                 Jarquebera tabulated6                            |
//+------------------------------------------------------------------+
double jarquebera_jbtbl6(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;
   result=0.;
   if(s<=0.2500)
     {
      x=2*(s-0.000000)/0.250000-1.;
      tj=1.;
      tj1=x;
      jarquebera_jbcheb(x, -2.274707e-04, tj, tj1, result);
      jarquebera_jbcheb(x, -5.700471e-04, tj, tj1, result);
      jarquebera_jbcheb(x, -3.425764e-04, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=1.3000)
     {
      x=2*(s-0.250000)/1.050000-1.;
      tj=1.;
      tj1=x;
      jarquebera_jbcheb(x, -1.339000e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -2.011104e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -8.168177e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -1.085666e-01, tj, tj1, result);
      jarquebera_jbcheb(x, 7.738606e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 7.022876e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 3.462402e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 6.908270e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -8.230772e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -1.006996e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -5.410222e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -2.893768e-03, tj, tj1, result);
      jarquebera_jbcheb(x,8.114564e-04,tj,tj1,result);
      if(result>0.)//ae_fp_greater
         result=0;
      return result;
     }
   if(s<=1.8500)//ae_fp_less_eq
     {
      x=2*(s-1.300000)/0.550000-1.;
      tj=1.;
      tj1=x;
      jarquebera_jbcheb(x, -6.794311e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -3.578700e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.394664e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -7.928290e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -4.813273e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -3.076063e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -1.835380e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -1.013013e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -5.058903e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -1.856915e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -6.710887e-03, tj, tj1, result);
      if(result>0.)//ae_fp_greater
         result=0.;
      return result;
     }
   result=-1.770029e+02*(s-1.850000e+00)-1.371015e+01;
   return result;
  }
//+------------------------------------------------------------------+
//|              Jarquebera tabulated7                               |
//+------------------------------------------------------------------+
double jarquebera_jbtbl7(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;

   result=0.;
   if(s<=1.4000)//ae_fp_less_eq
     {
      x=2*(s-0.000000)/1.400000-1.;
      tj=1.;
      tj1=x;
      jarquebera_jbcheb(x, -1.093681e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.695911e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -7.473192e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -1.203236e-01, tj, tj1, result);
      jarquebera_jbcheb(x, 6.590379e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 6.291876e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 3.132007e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 9.411147e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -1.180067e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -3.487610e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -2.436561e-03, tj, tj1, result);
      if(result>0.)
         result=0;
      return result;
     }
   if(s<=3.0000)
     {
      x=2*(s-1.400000)/1.600000-1.;
      tj=1.;
      tj1=x;
      jarquebera_jbcheb(x, -5.947854e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -2.772675e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -4.707912e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -1.691171e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -4.132795e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -1.481310e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 2.867536e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 8.772327e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 5.033387e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -1.378277e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -2.497964e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -3.636814e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -9.581640e-04, tj, tj1, result);
      if(result>0.)
         result=0;
      return result;
     }
   if(s<=3.2000)
     {
      x=2*(s-3.000000)/0.200000-1.;
      tj=1.;
      tj1=x;
      jarquebera_jbcheb(x, -7.511008e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -8.140472e-01, tj, tj1, result);
      jarquebera_jbcheb(x,1.682053e+00,tj,tj1,result);
      jarquebera_jbcheb(x, -2.568561e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -1.933930e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -8.140472e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -3.895025e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -8.140472e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -1.933930e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -2.568561e-02, tj, tj1, result);
      jarquebera_jbcheb(x,1.682053e+00,tj,tj1,result);
      if(result>0.)
         result=0;
      return result;
     }
   result=-1.824116e+03*(s-3.200000e+00)-1.440330e+01;
   return result;
  }
//+------------------------------------------------------------------+
//|               Jarquebera tabulated8                              |
//+------------------------------------------------------------------+
double jarquebera_jbtbl8(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;
   result=0.;
   if(s<=1.3000)
     {
      x=2*(s-0.000000)/1.300000-1.;
      tj=1.;
      tj1=x;
      jarquebera_jbcheb(x, -7.199015e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -1.095921e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -4.736828e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -1.047438e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -2.484320e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 7.937923e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 4.810470e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 2.139780e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 6.708443e-04, tj, tj1, result);
      if(result>0.)
         result=0;
      return result;
     }
   if(s<=2.0000)
     {
      x=2*(s-1.300000)/0.700000-1.;
      tj=1.;
      tj1=x;
      jarquebera_jbcheb(x, -3.378966e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -7.802461e-01, tj, tj1, result);
      jarquebera_jbcheb(x,1.547593e-01,tj,tj1,result);
      jarquebera_jbcheb(x,-6.241042e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.203274e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 5.201990e-03, tj, tj1, result);
      jarquebera_jbcheb(x,-5.125597e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 1.584426e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 2.546069e-04, tj, tj1, result);
      if(result>0.)
         result=0;
      return result;
     }
   if(s<=5.0000)
     {
      x=2*(s-2.000000)/3.000000-1.;
      tj=1.;
      tj1=x;
      jarquebera_jbcheb(x, -6.828366e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -3.137533e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -5.016671e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -1.745637e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -5.189801e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -1.621610e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -6.741122e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -4.516368e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 3.552085e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 2.787029e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 5.359774e-03, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   result=-5.087028e+00*(s-5.000000e+00)-1.071300e+01;
   return result;
  }
//+------------------------------------------------------------------+
//|                 Jarquebera tabulated9                            |
//+------------------------------------------------------------------+
double jarquebera_jbtbl9(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;
   result=0.;
   if(s<=1.3000)
     {
      x=2*(s-0.000000)/1.300000-1.;
      tj=1.;
      tj1=x;
      jarquebera_jbcheb(x, -6.279320e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -9.277151e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -3.669339e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -7.086149e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -1.333816e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 3.871249e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 2.007048e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 7.482245e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 2.355615e-04, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=2.0000)
     {
      x=2*(s-1.300000)/0.700000-1.;
      tj=1.;
      tj1=x;
      jarquebera_jbcheb(x, -2.981430e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -7.972248e-01, tj, tj1, result);
      jarquebera_jbcheb(x,1.747737e-01,tj,tj1,result);
      jarquebera_jbcheb(x, -3.808530e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -7.888305e-03, tj, tj1, result);
      jarquebera_jbcheb(x,9.001302e-03,tj,tj1,result);
      jarquebera_jbcheb(x, -1.378767e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -1.108510e-03, tj, tj1, result);
      jarquebera_jbcheb(x,5.915372e-04,tj,tj1,result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=7.0000)
     {
      x=2*(s-2.000000)/5.000000-1.;
      tj=1.;
      tj1=x;
      jarquebera_jbcheb(x, -6.387463e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -2.845231e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.809956e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -7.543461e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -4.880397e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -1.160074e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -7.356527e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -4.394428e-03, tj, tj1, result);
      jarquebera_jbcheb(x,9.619892e-04,tj,tj1,result);
      jarquebera_jbcheb(x,-2.758763e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 4.790977e-05, tj, tj1, result);
      if(result>0.)
         result=0;
      return result;
     }
   result=-2.020952e+00*(s-7.000000e+00)-9.516623e+00;
   return result;
  }
//+------------------------------------------------------------------+
//|               Jarquebera tabulated10                             |
//+------------------------------------------------------------------+
double jarquebera_jbtbl10(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;

   result=0;
   if(s<=1.2000)
     {
      x=2*(s-0.000000)/1.200000-1.;
      tj=1.;
      tj1=x;
      jarquebera_jbcheb(x, -4.590993e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -6.562730e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -2.353934e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -4.069933e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -1.849151e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 8.931406e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 3.636295e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 1.178340e-05, tj, tj1, result);
      jarquebera_jbcheb(x,-8.917749e-05, tj, tj1, result);
      if(result>0.)
        {
         result=0.;
        }
      return result;
     }
   if(s<=2.0000)
     {
      x=2*(s-1.200000)/0.800000-1.;
      tj=1.;
      tj1=x;
      jarquebera_jbcheb(x, -2.537658e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -9.962401e-01, tj, tj1, result);
      jarquebera_jbcheb(x, 1.838715e-01, tj, tj1, result);
      jarquebera_jbcheb(x, 1.055792e-02, tj, tj1, result);
      jarquebera_jbcheb(x,-2.580316e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.781701e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 3.770362e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -4.838983e-04, tj, tj1, result);
      jarquebera_jbcheb(x, -6.999052e-04, tj, tj1, result);
      if(result>0.)
        {
         result=0.;
        }
      return result;
     }
   if(s<=7.0000)
     {
      x=2*(s-2.000000)/5.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -5.337524e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.877029e+00, tj, tj1, result);
      jarquebera_jbcheb(x,4.734650e-02,tj,tj1,result);
      jarquebera_jbcheb(x,-4.249254e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 3.320250e-03, tj, tj1, result);
      jarquebera_jbcheb(x,-6.432266e-03, tj, tj1, result);
      if(result>0.) //result>0.)
         result=0.;
      return result;
     }
   result=-8.711035e-01*(s-7.000000e+00)-7.212811e+00;
   return result;
  }
//+------------------------------------------------------------------+
//|               Jarquebera tabulated11                             |
//+------------------------------------------------------------------+
double jarquebera_jbtbl11(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;

   result=0;
   if(s<=1.2000)
     {
      x=2*(s-0.000000)/1.200000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -4.339517e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -6.051558e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -2.000992e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -3.022547e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -9.808401e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 5.592870e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 3.575081e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 2.086173e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 6.089011e-05, tj, tj1, result);
      if(result>0.)
         result=0;
      return result;
     }
   if(s<=2.2500)
     {
      x=2*(s-1.200000)/1.050000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -2.523221e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.068388e+00, tj, tj1, result);
      jarquebera_jbcheb(x,2.179661e-01,tj,tj1,result);
      jarquebera_jbcheb(x, -1.555524e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -3.238964e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 7.364320e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 4.895771e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -1.762774e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -8.201340e-04, tj, tj1, result);
      if(result>0.)
         result=0;
      return result;
     }
   if(s<=8.0000)
     {
      x=2*(s-2.250000)/5.750000-1.;
      tj=1.;
      tj1=x;
      jarquebera_jbcheb(x, -5.212179e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.684579e+00, tj, tj1, result);
      jarquebera_jbcheb(x,8.299519e-02,tj,tj1,result);
      jarquebera_jbcheb(x,-3.606261e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 7.310869e-03, tj, tj1, result);
      jarquebera_jbcheb(x,-3.320115e-03, tj, tj1, result);
      if(result>0.)
         result=0;
      return result;
     }
   result=-5.715445e-01*(s-8.000000e+00)-6.845834e+00;
   return result;
  }
//+------------------------------------------------------------------+
//|               Jarquebera tabulated12                             |
//+------------------------------------------------------------------+
double jarquebera_jbtbl12(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;

   result=0;
   if(s<=1.0000)
     {
      x=2*(s-0.000000)/1.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -2.736742e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -3.657836e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -1.047209e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -1.319599e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -5.545631e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 9.280445e-05, tj, tj1, result);
      jarquebera_jbcheb(x, 2.815679e-05, tj, tj1, result);
      jarquebera_jbcheb(x,-2.213519e-05, tj, tj1, result);
      jarquebera_jbcheb(x, 1.256838e-05, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=3.0000)
     {
      x=2*(s-1.000000)/2.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -2.573947e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.515287e+00, tj, tj1, result);
      jarquebera_jbcheb(x,3.611880e-01,tj,tj1,result);
      jarquebera_jbcheb(x, -3.271311e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -6.495815e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 4.141186e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 7.180886e-04, tj, tj1, result);
      jarquebera_jbcheb(x,-1.388211e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 4.890761e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 3.233175e-03, tj, tj1, result);
      jarquebera_jbcheb(x,-2.946156e-03, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=12.0000)
     {
      x=2*(s-3.000000)/9.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -5.947819e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -2.034157e+00, tj, tj1, result);
      jarquebera_jbcheb(x,6.878986e-02,tj,tj1,result);
      jarquebera_jbcheb(x,-4.078603e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 6.990977e-03, tj, tj1, result);
      jarquebera_jbcheb(x,-2.866215e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 3.897866e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 2.512252e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 2.073743e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 3.022621e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 1.501343e-03, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   result=-2.877243e-01*(s-1.200000e+01)-7.936839e+00;
   return result;
  }
//+------------------------------------------------------------------+
//|                 Jarquebera tabulated13                           |
//+------------------------------------------------------------------+
double jarquebera_jbtbl13(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;

   result=0;
   if(s<=1.0000)
     {
      x=2*(s-0.000000)/1.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -2.713276e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -3.557541e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -9.459092e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -1.044145e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -2.546132e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 1.002374e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 2.349456e-05, tj, tj1, result);
      jarquebera_jbcheb(x, -7.025669e-05, tj, tj1, result);
      jarquebera_jbcheb(x, -1.590242e-05, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=3.0000)
     {
      x=2*(s-1.000000)/2.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -2.454383e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.467539e+00, tj, tj1, result);
      jarquebera_jbcheb(x,3.270774e-01,tj,tj1,result);
      jarquebera_jbcheb(x, -8.075763e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -6.611647e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 2.990785e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 8.109212e-03, tj, tj1, result);
      jarquebera_jbcheb(x,-1.135031e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 5.915919e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 3.522390e-03, tj, tj1, result);
      jarquebera_jbcheb(x,-1.144701e-03, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=13.0000)
     {
      x=2*(s-3.000000)/10.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -5.736127e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.920809e+00, tj, tj1, result);
      jarquebera_jbcheb(x,1.175858e-01,tj,tj1,result);
      jarquebera_jbcheb(x,-4.002049e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.158966e-02, tj, tj1, result);
      jarquebera_jbcheb(x,-3.157781e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 2.762172e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 5.780347e-04, tj, tj1, result);
      jarquebera_jbcheb(x, -1.193310e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -2.442421e-05, tj, tj1, result);
      jarquebera_jbcheb(x,2.547756e-03,tj,tj1,result);
      if(result>0.)
         result=0.;
      return result;
     }
   result=-2.799944e-01*(s-1.300000e+01)-7.566269e+00;
   return result;
  }
//+------------------------------------------------------------------+
//|                   Jarquebera tabulated14                         |
//+------------------------------------------------------------------+
double jarquebera_jbtbl14(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;

   result=0;
   if(s<=1.0000)
     {
      x=2*(s-0.000000)/1.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -2.698527e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -3.479081e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -8.640733e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -8.466899e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -1.469485e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 2.150009e-05, tj, tj1, result);
      jarquebera_jbcheb(x, 1.965975e-05, tj, tj1, result);
      jarquebera_jbcheb(x, -4.710210e-05, tj, tj1, result);
      jarquebera_jbcheb(x, -1.327808e-05, tj, tj1, result);
      if(result>0.)
         result=0;
      return result;
     }
   if(s<=3.0000)
     {
      x=2*(s-1.000000)/2.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -2.350359e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.421365e+00, tj, tj1, result);
      jarquebera_jbcheb(x, 2.960468e-01, tj, tj1, result);
      jarquebera_jbcheb(x, 1.149167e-02, tj, tj1, result);
      jarquebera_jbcheb(x,-6.361109e-02,tj, tj1, result);
      jarquebera_jbcheb(x, 1.976022e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.082700e-02,tj, tj1, result);
      jarquebera_jbcheb(x, -8.563328e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -1.453123e-03, tj, tj1, result);
      jarquebera_jbcheb(x,2.917559e-03,tj,tj1,result);
      jarquebera_jbcheb(x,-1.151067e-05,tj,tj1,result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=15.0000)
     {
      x=2*(s-3.000000)/12.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -5.746892e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -2.010441e+00, tj, tj1, result);
      jarquebera_jbcheb(x,1.566146e-01,tj,tj1,result);
      jarquebera_jbcheb(x,-5.129690e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.929724e-02, tj, tj1, result);
      jarquebera_jbcheb(x,-2.524227e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 3.192933e-03, tj, tj1, result);
      jarquebera_jbcheb(x,-4.254730e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 1.620685e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 7.289618e-04, tj, tj1, result);
      jarquebera_jbcheb(x,-2.112350e-03, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   result=-2.590621e-01*(s-1.500000e+01)-7.632238e+00;
   return result;
  }
//+------------------------------------------------------------------+
//|                  Jarquebera tabulated15                          |
//+------------------------------------------------------------------+
double jarquebera_jbtbl15(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;

   result=0;
   if(s<=2.0000)
     {
      x=2*(s-0.000000)/2.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -1.043660e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.361653e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -3.009497e-01, tj, tj1, result);
      jarquebera_jbcheb(x, 4.951784e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 4.377903e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.003253e-02, tj, tj1, result);
      jarquebera_jbcheb(x,-1.271309e-03, tj, tj1, result);
      if(result>0.)
         result=0;
      return result;
     }
   if(s<=5.0000)
     {
      x=2*(s-2.000000)/3.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -3.582778e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -8.349578e-01, tj, tj1, result);
      jarquebera_jbcheb(x,9.476514e-02,tj,tj1,result);
      jarquebera_jbcheb(x,-2.717385e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.222591e-02, tj, tj1, result);
      jarquebera_jbcheb(x,-6.635124e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 2.815993e-03, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=17.0000)
     {
      x=2*(s-5.000000)/12.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -6.115476e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.655936e+00, tj, tj1, result);
      jarquebera_jbcheb(x,8.404310e-02,tj,tj1,result);
      jarquebera_jbcheb(x,-2.663794e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 8.868618e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 1.381447e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 9.444801e-04, tj, tj1, result);
      jarquebera_jbcheb(x, -1.581503e-04, tj, tj1, result);
      jarquebera_jbcheb(x, -9.468696e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 1.728509e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 1.206470e-03, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   result=-1.927937e-01*(s-1.700000e+01)-7.700983e+00;
   return result;
  }
//+------------------------------------------------------------------+
//|                Jarquebera tabulated16                            |
//+------------------------------------------------------------------+
double jarquebera_jbtbl16(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;

   result=0;
   if(s<=2.0000)
     {
      x=2*(s-0.000000)/2.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -1.002570e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.298141e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -2.832803e-01, tj, tj1, result);
      jarquebera_jbcheb(x, 3.877026e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 3.539436e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 8.439658e-03, tj, tj1, result);
      jarquebera_jbcheb(x,-4.756911e-04, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=5.0000)
     {
      x=2*(s-2.000000)/3.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -3.486198e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -8.242944e-01, tj, tj1, result);
      jarquebera_jbcheb(x,1.020002e-01,tj,tj1,result);
      jarquebera_jbcheb(x,-3.130531e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.512373e-02, tj, tj1, result);
      jarquebera_jbcheb(x,-8.054876e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 3.556839e-03, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=20.0000)
     {
      x=2*(s-5.000000)/15.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -6.241608e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.832655e+00, tj, tj1, result);
      jarquebera_jbcheb(x,1.340545e-01,tj,tj1,result);
      jarquebera_jbcheb(x,-3.361143e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.283219e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 3.484549e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 1.805968e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -2.057243e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -1.454439e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -2.177513e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -1.819209e-03, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   result=-2.391580e-01*(s-2.000000e+01)-7.963205e+00;
   return result;
  }
//+------------------------------------------------------------------+
//|                 Jarquebera tabulated17                           |
//+------------------------------------------------------------------+
double jarquebera_jbtbl17(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;

   result=0;
   if(s<=3.0000)
     {
      x=2*(s-0.000000)/3.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -1.566973e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.810330e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -4.840039e-02, tj, tj1, result);
      jarquebera_jbcheb(x,2.337294e-01,tj,tj1,result);
      jarquebera_jbcheb(x, -5.383549e-04, tj, tj1, result);
      jarquebera_jbcheb(x, -5.556515e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -8.656965e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 1.404569e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 6.447867e-03, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=6.0000)
     {
      x=2*(s-3.000000)/3.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -3.905684e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -6.222920e-01, tj, tj1, result);
      jarquebera_jbcheb(x,4.146667e-02,tj,tj1,result);
      jarquebera_jbcheb(x,-4.809176e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 1.057028e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -1.211838e-04, tj, tj1, result);
      jarquebera_jbcheb(x, -4.099683e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 1.161105e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 2.225465e-04, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=24.0000)
     {
      x=2*(s-6.000000)/18.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -6.594282e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.917838e+00, tj, tj1, result);
      jarquebera_jbcheb(x,1.455980e-01,tj,tj1,result);
      jarquebera_jbcheb(x,-2.999589e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 5.604263e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -3.484445e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -1.819937e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -2.930390e-03, tj, tj1, result);
      jarquebera_jbcheb(x,2.771761e-04,tj,tj1,result);
      jarquebera_jbcheb(x, -6.232581e-04, tj, tj1, result);
      jarquebera_jbcheb(x, -7.029083e-04, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   result=-2.127771e-01*(s-2.400000e+01)-8.400197e+00;
   return result;
  }
//+------------------------------------------------------------------+
//|                  Jarquebera tabulated18                          |
//+------------------------------------------------------------------+
double jarquebera_jbtbl18(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;

   result=0;
   if(s<=3.0000)
     {
      x=2*(s-0.000000)/3.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -1.526802e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.762373e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -5.598890e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 2.189437e-01, tj, tj1, result);
      jarquebera_jbcheb(x, 5.971721e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -4.823067e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -1.064501e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.014932e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 5.953513e-03, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=6.0000)
     {
      x=2*(s-3.000000)/3.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -3.818669e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -6.070918e-01, tj, tj1, result);
      jarquebera_jbcheb(x,4.277196e-02,tj,tj1,result);
      jarquebera_jbcheb(x,-4.879817e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 6.887357e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 1.638451e-05, tj, tj1, result);
      jarquebera_jbcheb(x, 1.502800e-04, tj, tj1, result);
      jarquebera_jbcheb(x,-3.165796e-05, tj, tj1, result);
      jarquebera_jbcheb(x, 5.034960e-05, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=20.0000)
     {
      x=2*(s-6.000000)/14.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -6.010656e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.496296e+00, tj, tj1, result);
      jarquebera_jbcheb(x,1.002227e-01,tj,tj1,result);
      jarquebera_jbcheb(x,-2.338250e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 4.137036e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -2.586202e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -9.736384e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 1.332251e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 1.877982e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -1.160963e-05, tj, tj1, result);
      jarquebera_jbcheb(x, -2.547247e-03, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   result=-1.684623e-01*(s-2.000000e+01)-7.428883e+00;
   return result;
  }
//+------------------------------------------------------------------+
//|                  Jarquebera tabulated19                          |
//+------------------------------------------------------------------+
double jarquebera_jbtbl19(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;

   result=0;
   if(s<=3.0000)
     {
      x=2*(s-0.000000)/3.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -1.490213e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.719633e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -6.459123e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 2.034878e-01, tj, tj1, result);
      jarquebera_jbcheb(x, 1.113868e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -4.030922e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -1.054022e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 7.525623e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 5.277360e-03, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=6.0000)
     {
      x=2*(s-3.000000)/3.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -3.744750e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -5.977749e-01, tj, tj1, result);
      jarquebera_jbcheb(x,4.223716e-02,tj,tj1,result);
      jarquebera_jbcheb(x,-5.363889e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 5.711774e-04, tj, tj1, result);
      jarquebera_jbcheb(x,-5.557257e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 4.254794e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 9.034207e-05, tj, tj1, result);
      jarquebera_jbcheb(x, 5.498107e-05, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=20.0000)
     {
      x=2*(s-6.000000)/14.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -5.872768e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.430689e+00, tj, tj1, result);
      jarquebera_jbcheb(x,1.136575e-01,tj,tj1,result);
      jarquebera_jbcheb(x,-1.726627e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 3.421110e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -1.581510e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -5.559520e-04, tj, tj1, result);
      jarquebera_jbcheb(x, -6.838208e-04, tj, tj1, result);
      jarquebera_jbcheb(x,8.428839e-04,tj,tj1,result);
      jarquebera_jbcheb(x, -7.170682e-04, tj, tj1, result);
      jarquebera_jbcheb(x, -6.006647e-04, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   result=-1.539373e-01*(s-2.000000e+01)-7.206941e+00;
   return result;
  }
//+------------------------------------------------------------------+
//|                  Jarquebera tabulated20                          |
//+------------------------------------------------------------------+
double jarquebera_jbtbl20(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;

   result=0;
   if(s<=4.0000)
     {
      x=2*(s-0.000000)/4.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -1.854794e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.948947e+00, tj, tj1, result);
      jarquebera_jbcheb(x, 1.632184e-01, tj, tj1, result);
      jarquebera_jbcheb(x, 2.139397e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -1.006237e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -3.810031e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 3.573620e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 9.951242e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -1.274092e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -3.464196e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 4.882139e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 1.575144e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -1.822804e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -7.061348e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 5.908404e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 1.978353e-04, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=15.0000)
     {
      x=2*(s-4.000000)/11.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -5.030989e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.327151e+00, tj, tj1, result);
      jarquebera_jbcheb(x,1.346404e-01,tj,tj1,result);
      jarquebera_jbcheb(x,-2.840051e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 7.578551e-03, tj, tj1, result);
      jarquebera_jbcheb(x,-9.813886e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 5.905973e-05, tj, tj1, result);
      jarquebera_jbcheb(x, -5.358489e-04, tj, tj1, result);
      jarquebera_jbcheb(x, -3.450795e-04, tj, tj1, result);
      jarquebera_jbcheb(x, -6.941157e-04, tj, tj1, result);
      jarquebera_jbcheb(x, -7.432418e-04, tj, tj1, result);
      jarquebera_jbcheb(x, -2.070537e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 9.375654e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 5.367378e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 9.890859e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 6.679782e-04, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=25.0000)
     {
      x=2*(s-15.000000)/10.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -7.015854e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -7.487737e-01, tj, tj1, result);
      jarquebera_jbcheb(x,2.244254e-02,tj,tj1,result);
      if(result>0.)
         result=0.;
      return result;
     }
   result=-1.318007e-01*(s-2.500000e+01)-7.742185e+00;
   return result;
  }
//+------------------------------------------------------------------+
//|                 Jarquebera tabulated30                           |
//+------------------------------------------------------------------+
double jarquebera_jbtbl30(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;

   result=0;
   if(s<=4.0000)
     {
      x=2*(s-0.000000)/4.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -1.630822e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.724298e+00, tj, tj1, result);
      jarquebera_jbcheb(x, 7.872756e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.658268e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -3.573597e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -2.994157e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 5.994825e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 7.394303e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -5.785029e-04, tj, tj1, result);
      jarquebera_jbcheb(x, -1.990264e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -1.037838e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 6.755546e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 1.774473e-04, tj, tj1, result);
      jarquebera_jbcheb(x, -2.821395e-04, tj, tj1, result);
      jarquebera_jbcheb(x, -1.392603e-04, tj, tj1, result);
      jarquebera_jbcheb(x,1.353313e-04,tj,tj1,result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=15.0000)
     {
      x=2*(s-4.000000)/11.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -4.539322e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.197018e+00, tj, tj1, result);
      jarquebera_jbcheb(x,1.396848e-01,tj,tj1,result);
      jarquebera_jbcheb(x,-2.804293e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 6.867928e-03, tj, tj1, result);
      jarquebera_jbcheb(x,-2.768758e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 5.211792e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 4.925799e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 5.046235e-04, tj, tj1, result);
      jarquebera_jbcheb(x, -9.536469e-05, tj, tj1, result);
      jarquebera_jbcheb(x, -6.489642e-04, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=25.0000)
     {
      x=2*(s-15.000000)/10.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -6.263462e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -6.177316e-01, tj, tj1, result);
      jarquebera_jbcheb(x,2.590637e-02,tj,tj1,result);
      if(result>0.)
         result=0.;
      return result;
     }
   result=-1.028212e-01*(s-2.500000e+01)-6.855288e+00;
   return result;
  }
//+------------------------------------------------------------------+
//|                  Jarquebera tabulated50                          |
//+------------------------------------------------------------------+
double jarquebera_jbtbl50(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;

   result=0;
   if(s<=4.0000)
     {
      x=2*(s-0.000000)/4.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -1.436279e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.519711e+00, tj, tj1, result);
      jarquebera_jbcheb(x, 1.148699e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.001204e-01, tj, tj1, result);
      jarquebera_jbcheb(x, -3.207620e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -1.034778e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -1.220322e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 1.033260e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 2.588280e-04, tj, tj1, result);
      jarquebera_jbcheb(x, -1.851653e-04, tj, tj1, result);
      jarquebera_jbcheb(x, -1.287733e-04, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=15.0000)
     {
      x=2*(s-4.000000)/11.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -4.234645e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.189127e+00, tj, tj1, result);
      jarquebera_jbcheb(x,1.429738e-01,tj,tj1,result);
      jarquebera_jbcheb(x,-3.058822e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 9.086776e-03, tj, tj1, result);
      jarquebera_jbcheb(x,-1.445783e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 1.311671e-03, tj, tj1, result);
      jarquebera_jbcheb(x,-7.261298e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 6.496987e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 2.605249e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 8.162282e-04, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=25.0000)
     {
      x=2*(s-15.000000)/10.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -5.921095e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -5.888603e-01, tj, tj1, result);
      jarquebera_jbcheb(x,3.080113e-02,tj,tj1,result);
      if(result>0.)
         result=0.;
      return result;
     }
   result=-9.313116e-02*(s-2.500000e+01)-6.479154e+00;
   return result;
  }
//+------------------------------------------------------------------+
//|               Jarquebera tabulated65                             |
//+------------------------------------------------------------------+
double jarquebera_jbtbl65(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;

   result=0;
   if(s<=4.0000)
     {
      x=2*(s-0.000000)/4.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -1.360024e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.434631e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -6.514580e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 7.332038e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.158197e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -5.121233e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -1.051056e-03, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=15.0000)
     {
      x=2*(s-4.000000)/11.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -4.148601e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.214233e+00, tj, tj1, result);
      jarquebera_jbcheb(x,1.487977e-01,tj,tj1,result);
      jarquebera_jbcheb(x,-3.424720e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.116715e-02, tj, tj1, result);
      jarquebera_jbcheb(x,-4.043152e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 1.718149e-03, tj, tj1, result);
      jarquebera_jbcheb(x,-1.313701e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 3.097305e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 2.181031e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 1.256975e-04, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=25.0000)
     {
      x=2*(s-15.000000)/10.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -5.858951e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -5.895179e-01, tj, tj1, result);
      jarquebera_jbcheb(x,2.933237e-02,tj,tj1,result);
      if(result>0.)
         result=0.;
      return result;
     }
   result=-9.443768e-02*(s-2.500000e+01)-6.419137e+00;
   return result;
  }
//+------------------------------------------------------------------+
//|              Jarquebera tabulated100                             |
//+------------------------------------------------------------------+
double jarquebera_jbtbl100(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;

   result=0;
   if(s<=4.0000)
     {
      x=2*(s-0.000000)/4.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -1.257021e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.313418e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.628931e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 4.264287e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.518487e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -1.499826e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -4.836044e-04, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=15.0000)
     {
      x=2*(s-4.000000)/11.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -4.056508e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.279690e+00, tj, tj1, result);
      jarquebera_jbcheb(x,1.665746e-01,tj,tj1,result);
      jarquebera_jbcheb(x,-4.290012e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.487632e-02, tj, tj1, result);
      jarquebera_jbcheb(x,-5.704465e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 2.211669e-03, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=25.0000)
     {
      x=2*(s-15.000000)/10.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -5.866099e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -6.399767e-01, tj, tj1, result);
      jarquebera_jbcheb(x,2.498208e-02,tj,tj1,result);
      if(result>0.)
         result=0.;
      return result;
     }
   result=-1.080097e-01*(s-2.500000e+01)-6.481094e+00;
   return result;
  }
//+------------------------------------------------------------------+
//|                   Jarquebera tabulated130                        |
//+------------------------------------------------------------------+
double jarquebera_jbtbl130(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;

   result=0;
   if(s<=4.0000)
     {
      x=2*(s-0.000000)/4.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -1.207999e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.253864e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.618032e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 3.112729e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.210546e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -4.732602e-04, tj, tj1, result);
      jarquebera_jbcheb(x, -2.410527e-04, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=15.0000)
     {
      x=2*(s-4.000000)/11.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -4.026324e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.331990e+00, tj, tj1, result);
      jarquebera_jbcheb(x,1.779129e-01,tj,tj1,result);
      jarquebera_jbcheb(x,-4.674749e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.669077e-02, tj, tj1, result);
      jarquebera_jbcheb(x,-5.679136e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 8.833221e-04, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=25.0000)
     {
      x=2*(s-15.000000)/10.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -5.893951e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -6.475304e-01, tj, tj1, result);
      jarquebera_jbcheb(x,3.116734e-02,tj,tj1,result);
      if(result>0.)
         result=0.;
      return result;
     }
   result=-1.045722e-01*(s-2.500000e+01)-6.510314e+00;
   return result;
  }
//+------------------------------------------------------------------+
//|                 Jarquebera tabulated200                          |
//+------------------------------------------------------------------+
double jarquebera_jbtbl200(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;

   result=0;
   if(s<=4.0000)
     {
      x=2*(s-0.000000)/4.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -1.146155e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.177398e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.297970e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.869745e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.717288e-04, tj, tj1, result);
      jarquebera_jbcheb(x,-1.982108e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 6.427636e-05, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=15.0000)
     {
      x=2*(s-4.000000)/11.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -4.034235e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.455006e+00, tj, tj1, result);
      jarquebera_jbcheb(x,1.942996e-01,tj,tj1,result);
      jarquebera_jbcheb(x,-4.973795e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.418812e-02, tj, tj1, result);
      jarquebera_jbcheb(x,-3.156778e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 4.896705e-05, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=25.0000)
     {
      x=2*(s-15.000000)/10.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -6.086071e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -7.152176e-01, tj, tj1, result);
      jarquebera_jbcheb(x,3.725393e-02,tj,tj1,result);
      if(result>0.)
         result=0.;
      return result;
     }
   result=-1.132404e-01*(s-2.500000e+01)-6.764034e+00;
   return result;
  }
//+------------------------------------------------------------------+
//|                Jarquebera tabulated301                           |
//+------------------------------------------------------------------+
double jarquebera_jbtbl301(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;

   result=0;
   if(s<=4.0000)
     {
      x=2*(s-0.000000)/4.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -1.104290e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.125800e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -9.595847e-03, tj, tj1, result);
      jarquebera_jbcheb(x, 1.219666e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.502210e-04, tj, tj1, result);
      jarquebera_jbcheb(x,-6.414543e-05, tj, tj1, result);
      jarquebera_jbcheb(x, 6.754115e-05, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=15.0000)
     {
      x=2*(s-4.000000)/11.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -4.065955e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.582060e+00, tj, tj1, result);
      jarquebera_jbcheb(x,2.004472e-01,tj,tj1,result);
      jarquebera_jbcheb(x,-4.709092e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.105779e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 1.197391e-03, tj, tj1, result);
      jarquebera_jbcheb(x,-8.386780e-04, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=25.0000)
     {
      x=2*(s-15.000000)/10.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -6.311384e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -7.918763e-01, tj, tj1, result);
      jarquebera_jbcheb(x,3.626584e-02,tj,tj1,result);
      if(result>0.)
         result=0.;
      return result;
     }
   result=-1.293626e-01*(s-2.500000e+01)-7.066995e+00;
   return result;
  }
//+------------------------------------------------------------------+
//|                  Jarquebera tabulated501                         |
//+------------------------------------------------------------------+
double jarquebera_jbtbl501(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;

   result=0;
   if(s<=4.0000)
     {
      x=2*(s-0.000000)/4.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -1.067426e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.079765e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -5.463005e-03, tj, tj1, result);
      jarquebera_jbcheb(x,6.875659e-03,tj,tj1,result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=15.0000)
     {
      x=2*(s-4.000000)/11.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -4.127574e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.740694e+00, tj, tj1, result);
      jarquebera_jbcheb(x,2.044502e-01,tj,tj1,result);
      jarquebera_jbcheb(x,-3.746714e-02, tj, tj1, result);
      jarquebera_jbcheb(x, 3.810594e-04, tj, tj1, result);
      jarquebera_jbcheb(x, 1.197111e-03, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=25.0000)
     {
      x=2*(s-15.000000)/10.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -6.628194e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -8.846221e-01, tj, tj1, result);
      jarquebera_jbcheb(x,4.386405e-02,tj,tj1,result);
      if(result>0.)
         result=0.;
      return result;
     }
   result=-1.418332e-01*(s-2.500000e+01)-7.468952e+00;
   return result;
  }
//+------------------------------------------------------------------+
//|                Jarquebera tabulated701                           |
//+------------------------------------------------------------------+
double jarquebera_jbtbl701(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;

   result=0;
   if(s<=4.0000)
     {
      x=2*(s-0.000000)/4.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -1.050999e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.059769e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -3.922680e-03, tj, tj1, result);
      jarquebera_jbcheb(x,4.847054e-03,tj,tj1,result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=15.0000)
     {
      x=2*(s-4.000000)/11.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -4.192182e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.860007e+00, tj, tj1, result);
      jarquebera_jbcheb(x,1.963942e-01,tj,tj1,result);
      jarquebera_jbcheb(x, -2.838711e-02, tj, tj1, result);
      jarquebera_jbcheb(x, -2.893112e-04, tj, tj1, result);
      jarquebera_jbcheb(x,2.159788e-03,tj,tj1,result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=25.0000)
     {
      x=2*(s-15.000000)/10.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -6.917851e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -9.817020e-01, tj, tj1, result);
      jarquebera_jbcheb(x,5.383727e-02,tj,tj1,result);
      if(result>0.)
         result=0.;
      return result;
     }
   result=-1.532706e-01*(s-2.500000e+01)-7.845715e+00;
   return result;
  }
//+------------------------------------------------------------------+
//|               Jarquebera tabulated401                            |
//+------------------------------------------------------------------+
double jarquebera_jbtbl1401(double s)
  {
   double x;
   double tj;
   double tj1;
   double result;

   result=0;
   if(s<=4.0000)
     {
      x=2*(s-0.000000)/4.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -1.026266e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.030061e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.259222e-03, tj, tj1, result);
      jarquebera_jbcheb(x,2.536254e-03,tj,tj1,result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=15.0000)
     {
      x=2*(s-4.000000)/11.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -4.329849e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -2.095443e+00, tj, tj1, result);
      jarquebera_jbcheb(x,1.759363e-01,tj,tj1,result);
      jarquebera_jbcheb(x, -7.751359e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -6.124368e-03, tj, tj1, result);
      jarquebera_jbcheb(x, -1.793114e-03, tj, tj1, result);
      if(result>0.)
         result=0.;
      return result;
     }
   if(s<=25.0000)
     {
      x=2*(s-15.000000)/10.000000-1;
      tj=1;
      tj1=x;
      jarquebera_jbcheb(x, -7.544330e+00, tj, tj1, result);
      jarquebera_jbcheb(x, -1.225382e+00, tj, tj1, result);
      jarquebera_jbcheb(x,5.392349e-02,tj,tj1,result);
      if(result>0.)
         result=0.;
      return result;
     }
   result=-2.019375e-01*(s-2.500000e+01)-8.715788e+00;
   return result;
  }
//+------------------------------------------------------------------+
//|                     Sturges function                             |
//+------------------------------------------------------------------+
int Sturges(int y)
/*
   Function for determining the number of class intervals using Sturges' rule.
   Variables: 
     y is the number of sampling observations.
   Return value:
     number of class intervals.
*/
  {
   double s; // Return value
   s=1.+log2(y);
// Empirical rule
   if(s>15)
      s=15;
   return(int) floor(s);
  }
//+------------------------------------------------------------------+
//|                     Allocate function                            |
//+------------------------------------------------------------------+
void  Allocate(double &data[],int y,double &f[],double &b[],int k)
/*
	Function for allocation of observations to classes.
	Symbols:
	data  initial sample,
	y  sample size,
	f  calculated array of observations allocated to classes,
	b  array of class midpoints,
	k  number of classes.
	Return value: no
*/
  {
   int i,j; // Loop counter
   double t,c;       // Auxiliary variable
   t=data[ArrayMinimum(data)];// Array minimum
   t=t>0 ? t*0.99 : t*1.01;
   c=data[ArrayMaximum(data)];// Array maximum
   c=c>0 ? c*1.01 : c*0.99;
   c=(c-t)/k/2;// Half of the class interval
   b[0]=t+c;// Array of class interval midpoints
   f[0]= 0;
   for(i=1; i<k; i++)
     {
      b[i] = b[i - 1] + c + c;
      f[i] = 0;
     }
// Grouping
   for(i=0; i<y; i++)
      for(j=0; j<k; j++)
         if(data[i]>b[j]-c && data[i]<=b[j]+c)
           {
            f[j]++;
            break;
           }
  }
//+------------------------------------------------------------------+
//|         expFrequency function for any distribution               |
//+------------------------------------------------------------------+
void expFrequency(double &ebins[],double &f[],double &b[],int y,int k,Dist_type Dist)
/*
  E(i) is the expected frequency for bin i. 
  The expected frequency is calculated by E(i) = N*(F(Y(u) - F(Y(l)),
  where F is the cumulative Distribution function for the distribution 
  being tested, Yu is the upper limit for class i, Yl is the lower limit
  for class i, and N is the sample size. 
   Variables:
   1) ebins - array of expected frequencies;
   2) f  calculated array of observations allocated to classes;
   3) b  array of class midpoints;
   4) y - number of observations;
   5) k  number of classes;
   6) Dist - distribution type;
*/
  {
   double distn,    // distance between the class midpoints
   bounds[][2];     // lower and upper class boundaries
   distn=b[1]-b[0];
   ArrayResize(bounds,k);ArrayResize(ebins,k);
   for(int i=0;i<k;i++)
     {
      bounds[i][1]=b[i]+distn/2;  // upper class boundary
      bounds[i][0]=b[i]-distn/2;  // lower class boundary
/* 
   1)  Normal,
   2)  Lognormal,
   3)  Cauchy,
   4)  Hypersec,
   5)  Studentt,
   6)  Logistic,
   7)  Exponential,
   8)  Gamma,
   9)  Beta,
   10) Laplace,
   11) Binomial, 
   12) Poisson   
*/
      switch(Dist)
        {
         case 0:
           {
            CNormaldist N;
            ebins[i]=y*(N.cdf(bounds[i][1])-N.cdf(bounds[i][0]));
            break;
           }
         case 1:
           {
            CLognormaldist N;
            ebins[i]=y*(N.cdf(bounds[i][1])-N.cdf(bounds[i][0]));
            break;
           }
         case 2:
           {
            CCauchydist N;
            ebins[i]=y*(N.cdf(bounds[i][1])-N.cdf(bounds[i][0]));
            break;
           }
         case 3:
           {
            CHypersecdist N;
            ebins[i]=y*(N.cdf(bounds[i][1])-N.cdf(bounds[i][0]));
            break;
           }
         case 4:
           {
            CStudenttdist N;
            ebins[i]=y*(N.cdf(bounds[i][1])-N.cdf(bounds[i][0]));
            break;
           }
         case 5:
           {
            CLogisticdist N;
            ebins[i]=y*(N.cdf(bounds[i][1])-N.cdf(bounds[i][0]));
            break;
           }
         case 6:
           {
            CExpondist N;
            ebins[i]=y*(N.cdf(bounds[i][1])-N.cdf(bounds[i][0]));
            break;
           }
         case 7:
           {
            CGammadist N;
            ebins[i]=y*(N.cdf(bounds[i][1])-N.cdf(bounds[i][0]));
            break;
           }
         case 8:
           {
            CBetadist N;
            ebins[i]=y*(N.cdf(bounds[i][1])-N.cdf(bounds[i][0]));
            break;
           }
         case 9:
           {
            CLaplacedist N;
            ebins[i]=y*(N.cdf(bounds[i][1])-N.cdf(bounds[i][0]));
            break;
           }
         case 10:
           {
            CBinomialdist N;
            ebins[i]=y*(N.cdf((int)bounds[i][1])-N.cdf((int)bounds[i][0]));
            break;
           }
         case 11:
           {
            CPoissondist N;
            ebins[i]=y*(N.cdf((int)bounds[i][1])-N.cdf((int)bounds[i][0]));
            break;
           }
        }
     }
  }
//+------------------------------------------------------------------+
//|          expFrequency function for Normal Distribution           |
//+------------------------------------------------------------------+
void expFrequency(double &ebins[],double &f[],double &b[],int y,int k,CNormaldist &N)
/*
  Variables:
   1) ebins - array of expected frequencies;
   2) f  calculated array of observations allocated to classes;
   3) b  array of class midpoints;
   4) y - number of observations;
   5) k  number of classes;
   6) N - sample from the normal distribution;
*/
  {
   double distn,    // distance between the class midpoints
   bounds[][2];     // lower and upper class boundaries
   distn=b[1]-b[0];
   ArrayResize(bounds,k);ArrayResize(ebins,k);
   for(int i=0;i<k;i++)
     {
      bounds[i][1]=b[i]+distn/2;  // upper class boundary
      bounds[i][0]=b[i]-distn/2;  // lower class boundary
      ebins[i]=y*(N.cdf(bounds[i][1])-N.cdf(bounds[i][0]));
     }
  }
//+------------------------------------------------------------------+
//|         expFrequency function for Lognormal Distribution         |
//+------------------------------------------------------------------+
void expFrequency(double &ebins[],double &f[],double &b[],int y,int k,CLognormaldist &N)
/*
  Variables:
   1) ebins - array of expected frequencies;
   2) f  calculated array of observations allocated to classes;
   3) b  array of class midpoints;
   4) y - number of observations;
   5) k  number of classes;
   6) N - sample from the lognormal distribution;
*/
  {
   double distn,    // distance between the class midpoints
   bounds[][2];     // lower and upper class boundaries
   distn=b[1]-b[0];
   ArrayResize(bounds,k);ArrayResize(ebins,k);
   for(int i=0;i<k;i++)
     {
      bounds[i][1]=b[i]+distn/2;  // upper class boundary
      bounds[i][0]=b[i]-distn/2;  // lower class boundary
      ebins[i]=y*(N.cdf(bounds[i][1])-N.cdf(bounds[i][0]));
     }
  }
//+------------------------------------------------------------------+
//|         expFrequency function for Cauchy Distribution            |
//+------------------------------------------------------------------+
void expFrequency(double &ebins[],double &f[],double &b[],int y,int k,CCauchydist &N)
/*
  Variables:
   1) ebins - array of expected frequencies;
   2) f  calculated array of observations allocated to classes;
   3) b  array of class midpoints;
   4) y - number of observations;
   5) k  number of classes;
   6) N - sample from the Cauchy distribution;
*/
  {
   double distn,    // distance between the class midpoints
   bounds[][2];     // lower and upper class boundaries
   distn=b[1]-b[0];
   ArrayResize(bounds,k);ArrayResize(ebins,k);
   for(int i=0;i<k;i++)
     {
      bounds[i][1]=b[i]+distn/2;  // upper class boundary
      bounds[i][0]=b[i]-distn/2;  // lower class boundary
      ebins[i]=y*(N.cdf(bounds[i][1])-N.cdf(bounds[i][0]));
     }
  }
//+------------------------------------------------------------------+
//|      expFrequency function for Hypersec Distribution             |
//+------------------------------------------------------------------+
void expFrequency(double &ebins[],double &f[],double &b[],int y,int k,CHypersecdist &N)
/*
  Variables:
   1) ebins - array of expected frequencies;
   2) f  calculated array of observations allocated to classes;
   3) b  array of class midpoints;
   4) y - number of observations;
   5) k  number of classes;
   6) N - sample from the hyperbolic secant distribution;
*/
  {
   double distn,    // distance between the class midpoints
   bounds[][2];     // lower and upper class boundaries
   distn=b[1]-b[0];
   ArrayResize(bounds,k);ArrayResize(ebins,k);
   for(int i=0;i<k;i++)
     {
      bounds[i][1]=b[i]+distn/2;  // upper class boundary
      bounds[i][0]=b[i]-distn/2;  // lower class boundary
      ebins[i]=y*(N.cdf(bounds[i][1])-N.cdf(bounds[i][0]));
     }
  }
//+------------------------------------------------------------------+
//|      expFrequency function for Student-t Distribution            |
//+------------------------------------------------------------------+
void expFrequency(double &ebins[],double &f[],double &b[],int y,int k,CStudenttdist &N)
/*
  Variables:
   1) ebins - array of expected frequencies;
   2) f  calculated array of observations allocated to classes;
   3) b  array of class midpoints;
   4) y - number of observations;
   5) k  number of classes;
   6) N - sample from the Student's t-distribution;
*/
  {
   double distn,    // distance between the class midpoints
   bounds[][2];     // lower and upper class boundaries
   distn=b[1]-b[0];
   ArrayResize(bounds,k);ArrayResize(ebins,k);
   for(int i=0;i<k;i++)
     {
      bounds[i][1]=b[i]+distn/2;  // upper class boundary
      bounds[i][0]=b[i]-distn/2;  // lower class boundary
      ebins[i]=y*(N.cdf(bounds[i][1])-N.cdf(bounds[i][0]));
     }
  }
//+------------------------------------------------------------------+
//|      expFrequency function for Logistic Distribution             |
//+------------------------------------------------------------------+
void expFrequency(double &ebins[],double &f[],double &b[],int y,int k,CLogisticdist &N)
/*
  Variables:
   1) ebins - array of expected frequencies;
   2) f  calculated array of observations allocated to classes;
   3) b  array of class midpoints;
   4) y - number of observations;
   5) k  number of classes;
   6) N - sample from the logistic distribution;
*/
  {
   double distn,    // distance between the class midpoints
   bounds[][2];     // lower and upper class boundaries
   distn=b[1]-b[0];
   ArrayResize(bounds,k);ArrayResize(ebins,k);
   for(int i=0;i<k;i++)
     {
      bounds[i][1]=b[i]+distn/2;  // upper class boundary
      bounds[i][0]=b[i]-distn/2;  // lower class boundary
      ebins[i]=y*(N.cdf(bounds[i][1])-N.cdf(bounds[i][0]));
     }
  }
//+------------------------------------------------------------------+
//|      expFrequency function for Exponential Distribution          |
//+------------------------------------------------------------------+
void expFrequency(double &ebins[],double &f[],double &b[],int y,int k,CExpondist &N)
/*
  Variables:
   1) ebins - array of expected frequencies;
   2) f  calculated array of observations allocated to classes;
   3) b  array of class midpoints;
   4) y - number of observations;
   5) k  number of classes;
   6) N - sample from the exponential distribution;
*/
  {
   double distn,    // distance between the class midpoints
   bounds[][2];     // lower and upper class boundaries
   distn=b[1]-b[0];
   ArrayResize(bounds,k);ArrayResize(ebins,k);
   for(int i=0;i<k;i++)
     {
      bounds[i][1]=b[i]+distn/2;  // upper class boundary
      bounds[i][0]=b[i]-distn/2;  // lower class boundary
      ebins[i]=y*(N.cdf(bounds[i][1])-N.cdf(bounds[i][0]));
     }
  }
//+------------------------------------------------------------------+
//|        expFrequency function for Gamma Distribution              |
//+------------------------------------------------------------------+
void expFrequency(double &ebins[],double &f[],double &b[],int y,int k,CGammadist &N)
/*
  Variables:
   1) ebins - array of expected frequencies;
   2) f  calculated array of observations allocated to classes;
   3) b  array of class midpoints;
   4) y - number of observations;
   5) k  number of classes;
   6) N - sample from the gamma distribution;
*/
  {
   double distn,    // distance between the class midpoints
   bounds[][2];     // lower and upper class boundaries
   distn=b[1]-b[0];
   ArrayResize(bounds,k);ArrayResize(ebins,k);
   for(int i=0;i<k;i++)
     {
      bounds[i][1]=b[i]+distn/2;  // upper class boundary
      bounds[i][0]=b[i]-distn/2;  // lower class boundary
      ebins[i]=y*(N.cdf(bounds[i][1])-N.cdf(bounds[i][0]));
     }
  }
//+------------------------------------------------------------------+
//|        expFrequency function for Beta Distribution               |
//+------------------------------------------------------------------+
void expFrequency(double &ebins[],double &f[],double &b[],int y,int k,CBetadist &N)
/*
  Variables:
   1) ebins - array of expected frequencies;
   2) f  calculated array of observations allocated to classes;
   3) b  array of class midpoints;
   4) y - number of observations;
   5) k  number of classes;
   6) N - sample from the beta distribution;
*/
  {
   double distn,    // distance between the class midpoints
   bounds[][2];     // lower and upper class boundaries
   distn=b[1]-b[0];
   ArrayResize(bounds,k);ArrayResize(ebins,k);
   for(int i=0;i<k;i++)
     {
      if((i+1)==k)
         bounds[i][1]=.99999999999;  // upper boundary of the last class
      else
         bounds[i][1]=b[i]+distn/2;  // upper class boundary
      bounds[i][0]=b[i]-distn/2;  // lower class boundary
      ebins[i]=y*(N.cdf(bounds[i][1])-N.cdf(bounds[i][0]));
     }
  }
//+------------------------------------------------------------------+
//|        expFrequency function for Laplace Distribution            |
//+------------------------------------------------------------------+
void expFrequency(double &ebins[],double &f[],double &b[],int y,int k,CLaplacedist &N)
/*
  Variables:
   1) ebins - array of expected frequencies;
   2) f  calculated array of observations allocated to classes;
   3) b  array of class midpoints;
   4) y - number of observations;
   5) k  number of classes;
   6) N - sample from the Laplace distribution;
*/
  {
   double distn,    // distance between the class midpoints
   bounds[][2];     // lower and upper class boundaries
   distn=b[1]-b[0];
   ArrayResize(bounds,k);ArrayResize(ebins,k);
   for(int i=0;i<k;i++)
     {
      bounds[i][1]=b[i]+distn/2;  // upper class boundary
      bounds[i][0]=b[i]-distn/2;  // lower class boundary
      ebins[i]=y*(N.cdf(bounds[i][1])-N.cdf(bounds[i][0]));
     }
  }
//+------------------------------------------------------------------+
//|      expFrequency function for Binomial Distribution             |
//+------------------------------------------------------------------+
void expFrequency(double &ebins[],double &f[],double &b[],int y,int k,CBinomialdist &N)
/*
  Variables:
   1) ebins - array of expected frequencies;
   2) f  calculated array of observations allocated to classes;
   3) b  array of class midpoints;
   4) y - number of observations;
   5) k  number of classes;
   6) N - sample from the binomial distribution;
*/
  {
   double distn,    // distance between the class midpoints
   bounds[][2];     // lower and upper class boundaries
   distn=b[1]-b[0];
   ArrayResize(bounds,k);ArrayResize(ebins,k);
   for(int i=0;i<k;i++)
     {
      bounds[i][1]=b[i]+distn/2;  // upper class boundary
      bounds[i][0]=b[i]-distn/2;  // lower class boundary
      ebins[i]=y*(N.cdf((int)bounds[i][1])-N.cdf((int)bounds[i][0]));
     }
  }
//+------------------------------------------------------------------+
//|      expFrequency function for Poisson Distribution              |
//+------------------------------------------------------------------+
void expFrequency(double &ebins[],double &f[],double &b[],int y,int k,CPoissondist &N)
/*
  Variables:
   1) ebins - array of expected frequencies;
   2) f  calculated array of observations allocated to classes;
   3) b  array of class midpoints;
   4) y - number of observations;
   5) k  number of classes;
   6) N - sample from the binomial distribution;
*/
  {
   double distn,    // distance between the class midpoints
   bounds[][2];     // lower and upper class boundaries
   distn=b[1]-b[0];
   ArrayResize(bounds,k);ArrayResize(ebins,k);
   for(int i=0;i<k;i++)
     {
      bounds[i][1]=b[i]+distn/2;  // upper class boundary
      bounds[i][0]=b[i]-distn/2;  // lower class boundary
      ebins[i]=y*(N.cdf((int)bounds[i][1])-N.cdf((int)bounds[i][0]));
     }
  }
//+------------------------------------------------------------------+
//|               Chi-Square Goodness-of-Fit Test                    |
//+------------------------------------------------------------------+
void chsone(double &bins[],double &ebins[],double &df,
            double &chsq,double &prob,const int knstrn=1)
/*
   1) bins  array of observations allocated to classes;   
   2) ebins - array of expected frequencies;
   3) df - number of degrees of freedom; 
   3) chsq  chi-square statistic;
   4) prob - probability of accepting a true null hypothesis;
   5) knstrn  constraint.           
*/
  {
   CGamma gam;
   int j,nbins=ArraySize(bins),q,g;
   double temp;
   df=nbins-knstrn;
   chsq=0.0;
   q=nbins/2;
   g=nbins-1;

   for(j=0;j<q;j++) //passing through the left side of the histogram
     {
      if(ebins[j]<0.0 || (ebins[j]==0. && bins[j]>0.))
         Alert("Bad expected number in chsone!");
      if(ebins[j]<=5.0)
        {
         --df;
         ebins[j+1]+=ebins[j];//starting with the first class
         bins[j+1]+=bins[j];
        }
      else
        {
         temp=bins[j]-ebins[j];
         chsq+=pow(temp,2)/ebins[j];
        }
     }
   for(j=nbins-1;j>q-1;j--) //passing through the right side of the histogram
     {
      if(ebins[j]<0.0 || (ebins[j]==0. && bins[j]>0.))
         Alert("Bad expected number in chsone!");
      if(ebins[j]<=5.0)
        {
         --df;
         ebins[j-1]+=ebins[j];//starting with the last class
         bins[j-1]+=bins[j];
        }
      else
        {
         temp=bins[j]-ebins[j];
         chsq+=pow(temp,2)/ebins[j];
        }
     }
   if(df<1)df=1; //compensate
   prob=gam.gammq(0.5*df,0.5*chsq);
  }
//+------------------------------------------------------------------+
//|                     log2 function                                |
//+------------------------------------------------------------------+
double log2(double n)
//returns logarithm to base 2
  {
   return(log(n)/log(2));
  }
//+------------------------------------------------------------------+
//|               Save histogram function                            |
//+------------------------------------------------------------------+
void histogramSave(double &f[],double &b[])
/*
   f  calculated array of observations allocated to classes;
	b  array of class midpoints.
*/
  {
   int fhandle;
   string title,str;
   title="var title=\""+"Histogram"+"\";";
   ResetLastError();
   fhandle=FileOpen("dataHist.txt",FILE_WRITE|FILE_TXT|FILE_ANSI);
   if(fhandle<0){Print("File open failed, error ",GetLastError());return;}
   str="var data=[";
   int Len=ArraySize(f);
   for(int i=0;i<Len-1;i++)
      str+="["+DoubleToString(NormalizeDouble(b[i],2),2)+","+DoubleToString(NormalizeDouble(f[i],1),1)+"],";
   str+="["+DoubleToString(NormalizeDouble(b[Len-1],2),2)+","+DoubleToString(NormalizeDouble(f[Len-1],1),1)+"]];";
   FileWriteString(fhandle,title+"\n");
   FileWriteString(fhandle,str+"\n");
   FileClose(fhandle);
  }
//+------------------------------------------------------------------+
//|                      Median function                             |
//+------------------------------------------------------------------+
int Median(double &a[],int n,double &m,double &rm)
/*
	This function calculates parameters of the median.
	Symbols:
	a  initial sample,
	n  sample size,
	m  median,
	rm  median error.
	Return value:
	0 if the calculation completed normally,
	 1 in case of memory deficiency.
*/
  {
   double data[]; // Ranked series
   if(ArrayResize(data,n)<0)
      return -1;
   ArrayCopy(data,a);
   ArraySort(data);
   if(!isEven(n))
      m=data[n/2];
   else
      m=(data[n/2-1]+data[n/2])/2;
   rm=sqrt(Cov(a,a)*M_PI_2/n);
   return 0;
  }
//+------------------------------------------------------------------+
//|                     Even function                                |
//+------------------------------------------------------------------+
bool isEven(int n)
/*
  Function for integer even parity.
  Symbols:
  n  number.
  Return value:
  false, if the number is odd,
  true, if the number is even.
*/
  {
   if(n/2*2==n)
      return true;  // n  even
   else
      return false;  // n  odd
  }
//+------------------------------------------------------------------+
//|                    Kurtosis function                             |
//+------------------------------------------------------------------+
void Kurtosis(double &a[],double &es,double &me)
/*
  This function calculates the kurtosis parameters.
  Symbols:
  a  initial sample,
  n  sample size,
  es  kurtosis,
  me  kurtosis error.
  Return value:
  no.
*/
  {
   double xm=0.; // Dummy variable
   int n=ArraySize(a);
/////////////////////
// Kurtosis parameters
   es = Moment (4,a,0,xm) / Cov (a,a) - 3;
   me = 2.0 * sqrt (6.0 / (n + 3));
  }
//+------------------------------------------------------------------+
//|                    Moment function                               |
//+------------------------------------------------------------------+
double Moment(int index,double &x[],int sw,double xm)
/*
  Distribution moment calculation function.
  Symbols:
   index  order of the distribution moment,
   x  initial sample,
   sw  type of the distribution moment:
     sw = 0  central moment calculation, no need to set xm,
     sw = 1  conditional moment calculation, set xm = C (C - arbitrary number),
          calculation of the moment about zero, set xm = 0,
     xm  calculated value of the mean (when sw = 0),
  n  sample size.
  Return value:
  distribution moment value.
*/
  {
   int i,j; // Counters
   int n=ArraySize(x);
   double s=0,// Initial value of the sum
   temp;      // Auxiliary value
              // Calculation of the mean
   if(sw==0)
      xm=mean(x);
// Calculation of the moment
   for(i=0; i<n; i++)
     {
      temp=x[i]-xm;
      for(j=1; j<index; j++)
         temp*=x[i]-xm;
      s+=temp;
     }
   return s/n;
  }
//+------------------------------------------------------------------+
//|                    Variance function                             |
//+------------------------------------------------------------------+
void Variance(double &a[],double &v2,double &vm)
/*
  This function calculates the variance parameters.
  Symbols:
    a  initial sample,
    n  sample size,
    v2  variance,
    vm  variance error.
  Return value:
  no.
*/
  {
   int n=ArraySize(a);
   v2 = Cov (a,a);
   vm = v2 * sqrt (2 / n);
  }
//+------------------------------------------------------------------+
//|                     Log function                                 |
//+------------------------------------------------------------------+
double Log(double x,double a) // logarithm of  to base 
  {
   return(MathLog(x)/MathLog(a));
  }
//+------------------------------------------------------------------+
//|        Lognormal distribution parameter estimator function       |
//+------------------------------------------------------------------+
void paramEstimator(CExpStatistics &E,CLognormaldist &N)
//The maximum likelihood estimates
  {
   int n;
   double Mu=0.,Sig=0.,Arr[];
   E.setArrays(true,Arr,n);
   for(int i=0;i<n;i++)
     {
      Mu=Mu+log(Arr[i]);
      if(IS_DEBUG_MODE)
         if(!MathIsValidNumber(log(Arr[i])))
            Print("i="+IntegerToString(i)+", Arr[i]="+DoubleToString(Arr[i],4)+", log(Arr[i])="+DoubleToString(log(Arr[i]),4));
     }
   Mu=Mu/n;
   N.mu=Mu;
   for(int i=0;i<n;i++)
      Sig=Sig+pow(log(Arr[i])-Mu,2.);
   Sig=sqrt(Sig/n);
   N.sig=Sig;
  }
//+------------------------------------------------------------------+
//|        Cauchy distribution parameter estimator function          |
//+------------------------------------------------------------------+
void paramEstimator(CExpStatistics &E,CCauchydist &Cau)
  {
   int n;
   double Sig,med,Arr[];
   E.setArrays(true,Arr,n);
   med=E.median(true);       //? estimate
   Cau.mu=med;
   Sig=E.interqtlRange(true)/2.;//? estimate
   Cau.sig=Sig;
  }
//+------------------------------------------------------------------+
//|       Exponential distribution parameter estimator function      |
//+------------------------------------------------------------------+
void paramEstimator(CExpStatistics &E,CExpondist &Ex)
  {
   int n;
   double mm,Arr[];
   E.setArrays(true,Arr,n);
   mm=E.mean(true);
   Ex.lambda=1/mm;
  }
//+------------------------------------------------------------------+
//|         Gamma distribution parameter estimator function          |
//+------------------------------------------------------------------+
void paramEstimator(CExpStatistics &E,CGammadist &G)
  {
   int n;
   double mm,ss,std,Alph,Bet,Arr[];
   E.setArrays(true,Arr,n);
   mm=E.mean(true);
   ss=E.expSampleVariance(true);
   std=sqrt(ss);
   Alph=pow(mm,2.)/ss;
   Bet=1./(mm/ss);
   G.setCGammadist(Alph,Bet);
  }
//+------------------------------------------------------------------+
//|          Beta distribution parameter estimator function          |
//+------------------------------------------------------------------+
void paramEstimator(CExpStatistics &E,CBetadist &BetD)
  {
   double Alph,Bet,mm,svar;
   mm=E.mean(true);
   svar=E.expSampleVariance(true);
   Alph=mm*(((mm*(1.-mm))/svar)-1.); //http://www.xycoon.com/beta.htm
   Bet=(1.-mm)*(((mm*(1.-mm))/svar)-1.);
   BetD.setCBetadist(Alph,Bet);
  }
//+------------------------------------------------------------------+
//|                Estimate distribution function                    |
//+------------------------------------------------------------------+
void  estimateDistribution(CExpStatistics &E,Dist_type Dist,double &ebins[],double &f[],double &b[],int y,int intervals)
  {
   switch(Dist)
     {
      case 0:
        {
         CNormaldist N;
         N.mu=E.mean(true);
         N.sig=E.expStddev(true);
         expFrequency(ebins,f,b,y,intervals,N);
         Print("Normal distribution: X~Nor("+DoubleToString(N.mu,2)+", "+DoubleToString(N.sig,2)+");");
         break;
        }
      case 1:
        {
         CLognormaldist Nl;
         paramEstimator(E,Nl);
         expFrequency(ebins,f,b,y,intervals,Nl);
         Print("Lognormal distribution: X~Logn("+DoubleToString(Nl.mu,2)+", "+DoubleToString(Nl.sig,2)+");");
         break;
        }

      case 2:
        {
         CCauchydist Cau;
         paramEstimator(E,Cau);
         expFrequency(ebins,f,b,y,intervals,Cau);
         Print("Cauchy distribution: X~Cau("+DoubleToString(Cau.mu,2)+", "+DoubleToString(Cau.sig,2)+");");
         break;
        }
      case 3:
        {
         CHypersecdist Hy;
         Hy.mu=E.mean(true);
         Hy.sig=E.expStddev(true);
         expFrequency(ebins,f,b,y,intervals,Hy);
         Print("Hyperbolic Secant distribution: X~HS("+DoubleToString(Hy.mu,2)+", "+DoubleToString(Hy.sig,2)+");");
         break;
        }
/*case 4:
        {
         CStudenttdist N;N.nu=nn;N.mu=mm;N.sig=sqrt(ss);
         break;
        }*/
      case 5:
        {
         CLogisticdist Lo;
         Lo.alph=E.mean(true);
         Lo.bet=E.expStddev(true);
         expFrequency(ebins,f,b,y,intervals,Lo);
         Print("Logistic distribution: X~Logi("+DoubleToString(Lo.alph,2)+", "+DoubleToString(Lo.bet,2)+");");
         break;
        }
      case 6:
        {
         CExpondist Ex;
         paramEstimator(E,Ex);
         expFrequency(ebins,f,b,y,intervals,Ex);
         Print("Exponential distribution: X~Exp("+DoubleToString(Ex.lambda,2)+");");
         break;
        }
      case 7:
        {
         CGammadist Ga;
         paramEstimator(E,Ga);
         expFrequency(ebins,f,b,y,intervals,Ga);
         Print("Gamma distribution: X~Gam("+DoubleToString(Ga.alph,2)+", "+DoubleToString(Ga.bet,2)+");");
         break;
        }
      case 8:
        {
         CBetadist Be;
         paramEstimator(E,Be);
         expFrequency(ebins,f,b,y,intervals,Be);
         Print("Beta distribution: X~Beta("+DoubleToString(Be.alph,2)+", "+DoubleToString(Be.bet,2)+");");
         break;
        }
      case 9:
        {
         CLaplacedist Lap;
         Lap.alph=E.mean(true);
         Lap.bet=E.expStddev(true);
         expFrequency(ebins,f,b,y,intervals,Lap);
         Print("Laplace distribution: X~Lap("+DoubleToString(Lap.alph,2)+", "+DoubleToString(Lap.bet,2)+");");
         break;
        }
      case 10:
        {
         CBinomialdist Bin;
         double mm,pi;
         int nq;
         mm=E.mean(true);
         nq=E.get_arr_N();
         pi=mm/nq;
         Bin.setCBinomialdist(nq,pi);
         expFrequency(ebins,f,b,y,intervals,Bin);
         Print("Binomial distribution: k~Bin("+IntegerToString(Bin.n)+", "+DoubleToString(Bin.pe,2)+");");
         break;
        }
      case 11:
        {
         CPoissondist Po;
         Po.lambda=E.mean(true);
         expFrequency(ebins,f,b,y,intervals,Po);
         Print("Binomial distribution: k~Pois("+DoubleToString(Po.lambda)+");");
         break;
        }
     }
  }
//-----------------------------------------------------------------------------------
// Save file for histogram, ebins
//-----------------------------------------------------------------------------------  
void histogramSaveE(double &f[],double &b[],int y,double &ebins[],Dist_type Dist)
/*
   f  calculated array of observations allocated to classes;
	b  array of class midpoints;
	y - sample size;
	E - ebins - array of expected frequencies;
	Dist - distribution type.
*/
  {
   int fhandle;
   string title,str,str1;
   title="var title=\""+"Histogram: observed vs. expected for "+EnumToString(Dist)+" Distribution\";";
   ResetLastError();
   fhandle=FileOpen("dataHist2.txt",FILE_WRITE|FILE_TXT|FILE_ANSI);
   if(fhandle<0){Print("File open failed, error ",GetLastError());return;}
   str="var data=[";
   int len1=ArraySize(f);
   for(int i=0;i<len1-1;i++)
      str+="["+DoubleToString(NormalizeDouble(b[i],2),2)+","+DoubleToString(NormalizeDouble(f[i]/y,5),5)+"],";
   str+="["+DoubleToString(NormalizeDouble(b[len1-1],2),2)+","+DoubleToString(NormalizeDouble(f[len1-1]/y,5),5)+"]];";
   FileWriteString(fhandle,title+"\n");
   FileWriteString(fhandle,str+"\n");
//---ebins
   str1="var pdf=[";
   int len2=ArraySize(ebins);
   for(int i=0;i<len2-1;i++)
      str1+="["+DoubleToString(NormalizeDouble(b[i],2),2)+","+DoubleToString(NormalizeDouble(ebins[i]/y,3),3)+"],";
   str1+="["+DoubleToString(NormalizeDouble(b[len2-1],2),2)+","+DoubleToString(NormalizeDouble(ebins[len2-1]/y,3),3)+"]];";
   FileWriteString(fhandle,str1+"\n");
   FileClose(fhandle);
  }
//+------------------------------------------------------------------+
