input double    Lots = 0.1;
//+------------------------------------------------------------------+
// Connect the DLL adapter, through which we are going to use a DLL neuronet created using NeuroSolutions
#import "NeuroSolutionsAdapter.dll"
int CalcNeuralNet(string dllPath, string weightsPath, double& inputs[], double& outputs[]);
#import 
//+------------------------------------------------------------------+
class CNeuroSolutionsNeuralNet
{
private:
   string dllPath;     // Path to a DLL neuronet created in NeuroSolutions
   string weightsPath; // Path to a file of balances of the net
public:
   double in[20]; // Net inputs - OHLC of 5 bars
   double out[1]; // Net outputs- Close of a current bar

   CNeuroSolutionsNeuralNet();
   bool Calc();
};
//+------------------------------------------------------------------+
void CNeuroSolutionsNeuralNet::CNeuroSolutionsNeuralNet()
{
   string terminal = TerminalInfoString(TERMINAL_PATH);
   dllPath     = terminal + "\\MQL5\\Files\\NeuroSolutions\\WeekPattern.dll";
   weightsPath = terminal + "\\MQL5\\Files\\NeuroSolutions\\WeekPattern.nsw";
}
//+------------------------------------------------------------------+
bool CNeuroSolutionsNeuralNet::Calc()
  {
   // Get current quotes for the neuronet
   MqlRates rates[], rate;
   CopyRates(Symbol(), Period(), 0, 6, rates);
   ArraySetAsSeries(rates, true);
      
   // Fill the array of input data of the neuronet
   double zlevel=0;   
   for (int bar=0; bar<=5; bar++)
     {
      rate = rates[bar];
      // 0 bar is not taken for input
      if (bar==0) zlevel=rate.open; // level of price calculation
      // 1-5 are inputed to the net
      else
        {
         int i=(bar-1)*4; // entry number
         in[i  ] = rate.open -zlevel;
         in[i+1] = rate.high -zlevel;
         in[i+2] = rate.low  -zlevel;
         in[i+3] = rate.close-zlevel;
        }
     }
 
   // Calculate the net in NeuroSolutions DLL (though the DLL adapter)
   int res = CalcNeuralNet(dllPath, weightsPath, in, out);
   switch (res)
     {
      case 1: Print("Error of creating neuronet from DLL  \"", dllPath, "\""); return (false);
      case 2: Print("Error of loading balances in neuronet from the file \"", weightsPath, "\""); return (false);
      case 3: Print("Error of neuronet calculation");  return (false);
     }
     
   // Output of the neuronet has appeared in the array out, you shouldn't do anything with it

   return (true);
  }
//+------------------------------------------------------------------+

CNeuroSolutionsNeuralNet NN;
double Prognoze;

//+------------------------------------------------------------------+
#include <Trade\Trade.mqh>
//+------------------------------------------------------------------+
void OnTick() 
  {
   // Get price prediction from the neuronet
   if (NN.Calc()) Prognoze = NN.out[0];
   else           Prognoze = 0;

   // Perform necessary trade actions
   Trade();
  }
//+------------------------------------------------------------------+
void Trade() 
  {

   // Close an open position if it is against the prediction

   if(PositionSelect(_Symbol)) 
     {
      long type=PositionGetInteger(POSITION_TYPE);
      bool close=false;
      if((type == POSITION_TYPE_BUY)  && (Prognoze <= 0)) close = true;
      if((type == POSITION_TYPE_SELL) && (Prognoze >= 0)) close = true;
      if(close) 
        {
         CTrade trade;
         trade.PositionClose(_Symbol);
        }
     }

   // If there is no position, open one according to the prediction

   if((Prognoze!=0) && (!PositionSelect(_Symbol))) 
     {
      CTrade trade;
      if(Prognoze > 0) trade.Buy (Lots);
      if(Prognoze < 0) trade.Sell(Lots);
     }
  }
//+------------------------------------------------------------------+
