//+------------------------------------------------------------------+
//|                                                      ProjectName |
//|                                      Copyright 2012, CompanyName |
//|                                       http://www.companyname.net |
//+------------------------------------------------------------------+
/*+------------------------------------------------------------------+
//|                                                otimIndi_Publ.mq4 |
//|                                                      Gooly, 2016 |
//|                              https://www.mql5.com/en/users/gooly |
   1)  We disable "Genetic Algorithm" to test every combination.
   2)  set the "Optimized parameter" to Custom. This shows us more interesting pictures in the Optimization Graph.
   3)  We choose symbol EURUSD.
   4)  Period is set to H1 (here from 2014.08.16 to 2015.12.19).
   5)  Model is set to "Open Price only".
   6)  Don't forget to enable "Optimization".
   7)  Set PER: 2, 1, 90 = 89 <= fom step to
   8)  Set PRC: 0, 1, 6  =  7 <= Close .. Weighted
   9)  Set LIM: 4, 1, 90 = 87 <= in total 89*7*87 = 54,201 passes estimated time ~ 25 min on my laptop from 2007
   10) Don't forget to delete the cache file in \tester\cache\otimIndi_Publ.EURUSD60 (EA-name.SymbolTF)!!
   11) If it is blocked close the Strategy Tester of the terminal and restart it: press twice CTRL-r!
   After the Strategy Tester has completed the optimization and we find the resulting csv-file in ..\tester\files\.
//+------------------------------------------------------------------*/
#property copyright "Gooly, 2016"
#property link      "https://www.mql5.com/en/users/gooly"
#property version   "1.00"
#property strict

extern int                 PER   = 22;             // Adx Period
extern ENUM_APPLIED_PRICE  PRC   = PRICE_TYPICAL;  // Adx Price
extern double              LIM   = 14.0;           // Limit for Adx' mail line
extern string            fName   = "";             // file name in \tester\files, "" => no csv-file!



//+------------------------------------------------------------------+
//| calcOptVal calc OptVal to be returne to the Stratgy Tester       |
//| and its coefficients for the evaluation                          |
//+------------------------------------------------------------------+
// Coeff. for SwitchesAtan, number of switches:
double SwHigh=1.0,SwCoeff=0.01,SwMin=150;
// Coeff. for BrAtan, num. of bars:
double BrHigh=1.0,BrCoeff=0.5,BrMin=2.0;
// Coeff. for RangesAtan, TrendRange/FlatRange:
double RgHigh=1.0,RgCoeff=0.7,RgMin=1.0;
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double calcOptVal() 
  {
   if(FlatNum*TrndNum>0) 
     {
      SwitchesRaw  = TrndNum+FlatNum;
      SwitchesAtan = SwHigh*atan( SwCoeff*(SwitchesRaw-SwMin))/M_PI_2;

      FlatBarsAvg  = FlatBars/FlatNum;
      TrndBarsAvg  = TrndBars/TrndNum;
      BrRaw        = fmin(FlatBarsAvg,TrndBarsAvg);
      BrAtan       = BrHigh*atan( BrCoeff*(BrRaw-BrMin))/M_PI_2;

      FlatRange    = FlatRangHL / FlatNum;
      TrndRange    = TrndRangHL / TrndNum;
      RangesRaw    = FlatRange>0 ? TrndRange/FlatRange : 0.0;
      RangesAtan   = FlatRange>0 ? RgHigh*atan( RgCoeff*(RangesRaw-RgMin))/M_PI_2 : 0.0;
      return(fmax(0.0,SwitchesAtan) * fmax(0.0,BrAtan) * fmax(0.0,RangesAtan));
     }
   return(0.0);
  }
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
// write the header-line of the Calc.-Sheet
   if(StringLen(fName)>0) 
     {
      if( StringFind(fName,".csv", StringLen(fName)-5) < 0 ) fName = fName+".csv";    //  check the file name
      if( !FileIsExist(fName) ) 
        {                                                     // write the column headers of a new file
         int fH = FileOpen(fName,FILE_WRITE);
         if( fH == INVALID_HANDLE ) Print("ERROR open ",fName,": ",_LastError);
         string hdr=StringFormat("Name;OptVal;RangesRaw;PER;PRC;LIM;FlatNum;FlatBars;FlatBarsAvg;FlatRgHL;FlatRgCls;FlatRange;"+
                                 "TrendNum;TrendBars;TrendBarsAvg;TrendRgHL;TrendRgCl;TrendRange;"+
                                 "SwitchesRaw;SwitchesAtan;BrRaw;BrAtan;RangesRaw;RangesAtan;FlatHoursAvg;TrendHoursAvg;Bars;"+
                                 "Switches: %.1f %.1f %.f, Hours: %.1f %.1f %.1f, Range: %.1f %.1f %.1f\n",
                                 SwHigh,SwCoeff,SwMin,BrHigh,BrCoeff,BrMin,RgHigh,RgCoeff,RgMin);
         FileWriteString(fH,hdr,StringLen(hdr));
         FileClose(fH);
        }
     }
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---

  }

//+------------------------------------------------------------------+
//| Global variable definition                                       |
//+------------------------------------------------------------------+
double   OptVal,           // this value is returend by OnTester() and its value canbe found in the OnTerster()-Tab of the Strateg-Tester
TrndHi,           // highest High of the actual trend market
TrndLo,           // lowest Low of the acttual trend market
TrndBeg,          // price at the begin of a trend market
TrndRangHL,       // sum of highest high - lowest low of the trend markets
TrndRangCl,       // last close - first close of trend market (left but not used)
TrndNum,          // number of trend market
TrndBars=0.0,     // number of bars of the trend market
TrndBarsAvg=0.0,  // avg bars in rrend market
FlatBarsAvg=0.0,  // avg bars in flat market
FlatHi,           // highest High of the actual flat market
FlatLo,           // lowest Low of the actual flat market
FlatBeg,          // price at the begin of a flat market
FlatRangHL,       // sum of highest High - lowest Low of the flat marketes
FlatRangCl,       // last close - first close of a flat market (left but not used)
FlatNum,          // number of flat market
FlatBars=0.0,     // number of bars of the flat market
FlatRange,        // tmp FlatRangHL / FlatNum
TrndRange,        // tmp TrndRangHL / TrndNum
SwitchesRaw,      // num of switches
SwitchesAtan,     // Atan of num of switches
BrRaw,            // Min of hours of either flart or trend market (more is better)
BrAtan,           // Atan of BrRaw
RangesRaw,        // Range of trend market devided by range of flat markets (the bigger the better)
RangesAtan;       // Atan of (TrndRange/FlatRange)
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
enum __Mkt // 3 state of the markets 
  {
   UNDEF,
   FLAT,
   TREND
  };
__Mkt MARKET = UNDEF;      // start state of the market.
string iName;              // indicator name
double main1,main2;        // values of the Adx main line
//+------------------------------------------------------------------+
//| OnTick calc the Indi, determin the market state                  |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   static datetime tNewBar=0;
   if(tNewBar<Time[0])
     {
      tNewBar=Time[0];
      main1 = iADX(_Symbol,_Period,PER,PRC,  MODE_MAIN, 1); // ADX
      main2 = iADX(_Symbol,_Period,PER,PRC,  MODE_MAIN, 2); // ADX)
      iName = "ADX";

      // set the var. that the appropriate market state is defined
      if(MARKET==UNDEF)
        {
         if(main1<LIM) main2=LIM+10.0*_Point; // MARKET becomes FLAT
         else if(main1>LIM) main2=LIM-10.0*_Point; // MARKET becomes TREND
         FlatHi  = High[0];
         FlatLo  = Low[0];
         FlatBeg=Close[2];//
         TrndHi  = High[0];
         TrndLo  = Low[0];
         TrndBeg=Close[2];//
        }

      // do we enter a flat market?
      if(MARKET!=FLAT && main2>LIM && main1<LIM) // ADX
        {
         //finalize trend market
         TrndRangCl += fabs(Close[2] - TrndBeg)/_Point;
         TrndRangHL += fabs(TrndHi - TrndLo)/_Point;

         // update relevant values
         OptVal=calcOptVal();

         //set the new flat market
         MARKET  = FLAT;
         FlatHi  = High[0];
         FlatLo  = Low[0];
         FlatBeg=Close[1];//
         ++FlatNum;
         if(IsVisualMode())
           {
            if(!drawArrow("Flat "+TimeToStr(Time[0]),Time[0],Open[0]-(High[1]-Low[1]),243,clrDarkBlue)) // 39:candle market sleeps
               Print("Error drawError ",__LINE__," ",_LastError);
           }
        }
      else if(MARKET==TREND) // update the current trend market
        {
         TrndHi = fmax(TrndHi,High[0]);
         TrndLo = fmin(TrndLo,Low[0]);
         TrndBars++;
        }

      // do we enter a trend market?
      if(MARKET!=TREND && main2<LIM && main1>LIM)
        {
         // finalize flat market
         FlatRangCl += fabs(Close[2] - FlatBeg)/_Point;
         FlatRangHL += fabs(FlatHi - FlatLo)/_Point;

         // update relevant values
         OptVal=calcOptVal();

         // set the new trend market
         MARKET  = TREND;
         TrndHi  = High[0];
         TrndLo  = Low[0];
         TrndBeg=Close[1];//
         ++TrndNum;
         TrndBars++;
         if(IsVisualMode())
           {
            if(!drawArrow("Trend "+TimeToStr(Time[0]),Time[0],Open[0]-(High[1]-Low[1]),244,clrRed)) // 119:kl Diamond
               Print("Error drawError ",__LINE__," ",_LastError);
           }
        }
      else if(MARKET==FLAT) // update the current flat market
        {
         FlatHi = fmax(FlatHi,High[0]);
         FlatLo = fmin(FlatLo,Low[0]);
         FlatBars++;
        }

     }
   if(IsVisualMode())  // in VisualMode show the actual situation
     {
      string lne=StringFormat("%s  PER: %i    PRC: %s    LIM: %.2f\nMarket  #   BarsAvg  RangeAvg"+
                              "\nFlat:    %03.f    %06.2f         %.1f\nTrend: %03.f    %06.2f         %.1f   =>  %.2f",
                              iName,PER,EnumToString(PRC),LIM,FlatNum,FlatBarsAvg,FlatRange,
                              TrndNum,TrndBarsAvg,TrndRange,(FlatRange>Point?TrndRange/FlatRange:0.0)
                              );
      Comment(TimeToString(tNewBar),"  ",EnumToString(MARKET),"  Adx: ",DoubleToString(main1,3),
              "  Adx-Lim:",DoubleToString(main1-LIM,3),"\n",lne);
     }
  }
//+------------------------------------------------------------------+
//| Tester function, writing csv-file, returning OptVal              |
//+------------------------------------------------------------------+
double OnTester()
  {
// check the knock out limit: at least one switches
   if(FlatNum*TrndNum<=1) return(0.0);  // either one is 0 => skip senseless results

                                        // now finalize the last market: flat
   if(MARKET==FLAT)
     {
      TrndRangCl += fabs(Close[2] - TrndBeg)/_Point;
      TrndRangHL += fabs(TrndHi - TrndLo)/_Point;

      // update relevant values
      OptVal=calcOptVal();

     }
   else if(MARKET==TREND) // .. and trend
     {
      FlatRangCl += fabs(Close[2] - FlatBeg)/_Point;
      FlatRangHL += fabs(FlatHi - FlatLo)/_Point;

      // update OptVal
      OptVal=calcOptVal();
     }

// write the values to the csv-file
   if(StringLen(fName)>0)
     {
      string row=StringFormat("%s;%.5f;%.3f;%i;%i;%.2f;%.0f;%.0f;%.1f;%.0f;%.0f;%.2f;%.2f;%.0f;%.0f;%.1f;%.0f;%.0f;%.2f;%.2f;%.0f;%.5f;%.6f;%.5f;%.6f;%.5f;%.2f;%.2f;%.0f\n",
                              iName,OptVal,RangesRaw,PER,PRC,LIM,
                              FlatNum,FlatBars,FlatBarsAvg,FlatRangHL,FlatRangCl,FlatRange,
                              TrndNum,TrndBars,TrndBarsAvg,TrndRangHL,TrndRangCl,TrndRange,
                              SwitchesRaw,SwitchesAtan,BrRaw,BrAtan,RangesRaw,RangesAtan,
                              FlatBarsAvg*_Period/60.0,TrndBarsAvg*_Period/60.0,
                              (FlatBars+TrndBars)
                              );

      int fH = FileOpen(fName,FILE_READ|FILE_WRITE);
      if( fH == INVALID_HANDLE ) Print("ERROR open ",fName,": ",_LastError);
      FileSeek(fH,0,SEEK_END);
      FileWriteString(fH,row,StringLen(row));
      FileClose(fH);
     }
// return 0.0 instead of neg. values! They mess up the Optimization Graph in our case.
   return( fmax(0.0,OptVal) );
  }
//+------------------------------------------------------------------+
//| drawArrows when the market state changes - onlyin visual mode    |
//+------------------------------------------------------------------+
bool drawArrow(string n,datetime xTme,double xPrc,int typeArrow,color clr=DimGray,string dscr="")
  {
   if(ObjectFind(n)>=0) ObjectDelete(n);
   if(!ObjectCreate(n, OBJ_ARROW, 0, xTme, xPrc) ) return(false);
   bool ok=ObjectSet(n,OBJPROP_ARROWCODE,typeArrow);
   ok = ok && ObjectSet(n, OBJPROP_COLOR, clr);
   ok = ok && ObjectSetText(n,dscr,12);
   return(ok);
  }
//+------------------------------------------------------------------+
