//=====================================================================
//	The library for displaying of a text information on the screen.
//=====================================================================

//---------------------------------------------------------------------
#property copyright 	"Dima S., 2010 ."
#property link      	"dimascub@mail.com"
//---------------------------------------------------------------------

//---------------------------------------------------------------------
#import		"user32.dll"
int		GetSystemMetrics(int _index);
#import
//---------------------------------------------------------------------
#define		SM_CXSCREEN				0
#define		SM_CYSCREEN				1
#define		SM_CXFULLSCREEN		16
#define		SM_CYFULLSCREEN		17
//---------------------------------------------------------------------


//---------------------------------------------------------------------
//	Connected libraries:
//---------------------------------------------------------------------
#include	<ChartObjects\ChartObjectsTxtControls.mqh>
#include	<Arrays\List.mqh>
//---------------------------------------------------------------------


//---------------------------------------------------------------------
//	Field for displaying header:
//---------------------------------------------------------------------
class TTitleDisplay : public CChartObjectLabel
{
protected:
	long		chart_id;
	int			sub_window;
	long		chart_width;																							// chart width in pixels
	long		chart_height;																							// chart height in pixels
	long		chart_width_step;																						// horizontal step of the grid of coordinates
	long		chart_height_step;																					// vertical step of the grid of coordinates
	int			columns_number;																					// number of columns
	int			lines_number;																						// number of rows
	int			curr_column;
	int			curr_row;

private:
	void		SetParams(long _chart_id, int _window, int _cols, int _lines);// set object parameters

public:
	string	GetUniqName();																							// get a unique name
	bool		Create(long _chart_id, int _window, int _cols, int _lines, int _col, int _row);
	void		RecalcAndRedraw();																					// recalculate coordinates and redraw

	
public:
	void		TTitleDisplay();																						// constructor
	void		~TTitleDisplay();																					   // destructor

};
//---------------------------------------------------------------------

//---------------------------------------------------------------------
//	Constructor:
//---------------------------------------------------------------------
void	TTitleDisplay::TTitleDisplay()
{
}

//---------------------------------------------------------------------
//	Destructor:
//---------------------------------------------------------------------
void	TTitleDisplay::~TTitleDisplay()
{
}

//---------------------------------------------------------------------
//	Create object:
//---------------------------------------------------------------------
bool	TTitleDisplay::Create(long _chart_id, int _window, int _cols, int _lines, int _col, int _row)
{
	this.curr_column = _col;
	this.curr_row = _row;
	SetParams(_chart_id, _window, _cols, _lines);

	return(this.Create(this.chart_id, this.GetUniqName(), this.sub_window, (int)(_col * this.chart_width_step), (int)(_row * this.chart_height_step)));
}

//---------------------------------------------------------------------
//	Set object parameters:
//---------------------------------------------------------------------
void	TTitleDisplay::SetParams(long _chart_id, int _window, int _cols, int _lines)
{
	this.chart_id = _chart_id;
	this.sub_window = _window;
	this.columns_number = _cols;
	this.lines_number = _lines;

//	Determine the window size in pixels:
	this.chart_width = GetSystemMetrics(SM_CXFULLSCREEN);
	this.chart_height = GetSystemMetrics(SM_CYFULLSCREEN);

//	Calculate step of the grid of coordinates:
	this.chart_width_step = this.chart_width / _cols;
	this.chart_height_step = this.chart_height / _lines;
}

//---------------------------------------------------------------------
//	Recalculate object parameters:
//---------------------------------------------------------------------
void	TTitleDisplay::RecalcAndRedraw()
{
//	Determine the window size in pixels:
	long	width = GetSystemMetrics(SM_CXFULLSCREEN);
	long	height = GetSystemMetrics(SM_CYFULLSCREEN);
	if(width == this.chart_width && height == this.chart_height)
	{
		return;
	}

	this.chart_width = width;
	this.chart_height = height;

//	Calculate step of the grid of coordinates:
	this.chart_width_step = this.chart_width / this.columns_number;
	this.chart_height_step = this.chart_height / this.lines_number;

//	Move the objects to new coordinates:
	this.X_Distance((int)(this.curr_column * this.chart_width_step));
	this.Y_Distance((int)(this.curr_row * this.chart_height_step));
}

//---------------------------------------------------------------------
//	Get a unique name:
//---------------------------------------------------------------------
string	TTitleDisplay::GetUniqName()
{
	static uint	prev_count = 0;

	uint		count = GetTickCount();
	while(1)
	{
		if(prev_count == UINT_MAX)
		{
			prev_count = 0;
		}
		if(count <= prev_count)
		{
			prev_count++;
			count = prev_count;
		}
		else
		{
			prev_count = count;
		}

//	Check if an object with the same name already exists:
		string		name = TimeToString(TimeGMT(), TIME_DATE | TIME_MINUTES | TIME_SECONDS) + " " + DoubleToString(count, 0);
		if(ObjectFind(0, name) < 0)
		{
			return(name);
		}
	}

	return(NULL);
}
//---------------------------------------------------------------------


//---------------------------------------------------------------------
//	Field for displaying dynamic inforamtion:
//---------------------------------------------------------------------
class TFieldDisplay : public CChartObjectEdit
{
protected:
	long		chart_id;
	int			sub_window;
	long		chart_width;																							// chart width in pixels
	long		chart_height;																							// chart height in pixels
	long		chart_width_step;																						// horizontal step of the grid of coordinates
	long		chart_height_step;																					// vertical step of the grid of coordinates
	int			columns_number;																					// number of columns
	int			lines_number;																						// number of rows
	int			curr_column;
	int			curr_row;

private:
	int			type;																									// type of output field (string, integer)

private:
	void		SetParams(long _chart_id, int _window, int _cols, int _lines);// set object parameters

public:
	string	GetUniqName();																							// get a unique name
	bool		Create(long _chart_id, int _window, int _cols, int _lines, int _col, int _row);
	void		RecalcAndRedraw();																					// recalculate coordinates and redraw
	
public:
	void		TFieldDisplay();																						// constructor
	void		~TFieldDisplay();																					   // destructor
};
//---------------------------------------------------------------------

//---------------------------------------------------------------------
//	Constructor:
//---------------------------------------------------------------------
void	TFieldDisplay::TFieldDisplay()
{
}

//---------------------------------------------------------------------
//	Destructor:
//---------------------------------------------------------------------
void	TFieldDisplay::~TFieldDisplay()
{
}

//---------------------------------------------------------------------
//	Create object:
//---------------------------------------------------------------------
bool	TFieldDisplay::Create(long _chart_id, int _window, int _cols, int _lines, int _col, int _row)
{
	this.curr_column = _col;
	this.curr_row = _row;
	SetParams(_chart_id, _window, _cols, _lines);

	return(this.Create(this.chart_id, this.GetUniqName(), this.sub_window, (int)(_col * this.chart_width_step), (int)(_row * this.chart_height_step)));
}

//---------------------------------------------------------------------
//	Set object parameters:
//---------------------------------------------------------------------
void	TFieldDisplay::SetParams(long _chart_id, int _window, int _cols, int _lines)
{
	this.chart_id = _chart_id;
	this.sub_window = _window;
	this.columns_number = _cols;
	this.lines_number = _lines;

//	Determine the window size in pixels:
	this.chart_width = GetSystemMetrics(SM_CXFULLSCREEN);
	this.chart_height = GetSystemMetrics(SM_CYFULLSCREEN);

//	Calculate step of the grid of coordinates:
	this.chart_width_step = this.chart_width / _cols;
	this.chart_height_step = this.chart_height / _lines;
}

//---------------------------------------------------------------------
//	Recalculate object parameters:
//---------------------------------------------------------------------
void	TFieldDisplay::RecalcAndRedraw()
{
//	Determine the window size in pixels:
	long	width = GetSystemMetrics(SM_CXFULLSCREEN);
	long	height = GetSystemMetrics(SM_CYFULLSCREEN);
	if(width == this.chart_width && height == this.chart_height)
	{
		return;
	}

	this.chart_width = width;
	this.chart_height = height;

//	Calculate step of the grid of coordinates:
	this.chart_width_step = this.chart_width / this.columns_number;
	this.chart_height_step = this.chart_height / this.lines_number;

//	Move the objects to new coordinates:
	this.X_Distance((int)(this.curr_column * this.chart_width_step));
	this.Y_Distance((int)(this.curr_row * this.chart_height_step));
}

//---------------------------------------------------------------------
//	Get a unique name:
//---------------------------------------------------------------------
string	TFieldDisplay::GetUniqName()
{
	static uint	prev_count = 0;

	uint			count = GetTickCount();
	while(1)
	{
		if(prev_count == UINT_MAX)
		{
			prev_count = 0;
		}
		if(count <= prev_count)
		{
			prev_count++;
			count = prev_count;
		}
		else
		{
			prev_count = count;
		}

//	Check if an object with the same name already exists:
		string		name = TimeToString(TimeGMT(), TIME_DATE | TIME_MINUTES | TIME_SECONDS) + " " + DoubleToString(count, 0);
		if(ObjectFind(0, name) < 0)
		{
			return(name);
		}
	}

	return(NULL);
}
//---------------------------------------------------------------------


//---------------------------------------------------------------------
//	Organization of the list of text graphical objects:
//---------------------------------------------------------------------
class TableDisplay : public CList
{
protected:
	long		chart_id;
	int			sub_window;
	ENUM_BASE_CORNER	corner;

public:
	void		SetParams(long _chart_id, int _window, ENUM_BASE_CORNER _corner = CORNER_LEFT_UPPER);
	int			AddTitleObject(int _cols, int _lines, int _col, int _row, string _title, color _color, string _fontname = "Arial", int _fontsize = 10);
	int			AddFieldObject(int _cols, int _lines, int _col, int _row, color _color, string _fontname = "Arial", int _fontsize = 10);
	bool		SetColor(int _index, color _color);
	bool		SetFont(int _index, string _fontname, int _fontsize);
	bool		SetText(int _index, string _text);
	bool		SetAnchor(int _index, ENUM_ANCHOR_POINT _anchor);

public:
	void		TableDisplay();
	void		~TableDisplay();
};
//---------------------------------------------------------------------

//---------------------------------------------------------------------
//	Constructor:
//---------------------------------------------------------------------
void	TableDisplay::TableDisplay()
{
	this.chart_id = 0;
	this.sub_window = 0;
	this.corner = CORNER_LEFT_UPPER;
}

//---------------------------------------------------------------------
//	Destructor:
//---------------------------------------------------------------------
void	TableDisplay::~TableDisplay()
{
//	Delete all objects:
////	this.Clear();
}

//---------------------------------------------------------------------
//	Set common parameters for the graphical objects of the list:
//---------------------------------------------------------------------
void	TableDisplay::SetParams(long _chart_id, int _window, ENUM_BASE_CORNER _corner)
{
	this.chart_id = _chart_id;
	this.sub_window = _window;
	this.corner = _corner;
}

//---------------------------------------------------------------------
//	Add an object of the "Header" type with specified parameters to the list:
//---------------------------------------------------------------------
int		TableDisplay::AddTitleObject(int _cols, int _lines, int _col, int _row, string _title, color _color, string _fontname, int _fontsize)
{
	TTitleDisplay*		title = new TTitleDisplay();
	title.Create(this.chart_id, this.sub_window, _cols, _lines, _col, _row);
	title.Description(_title);
	title.Color(_color);
	title.Font(_fontname);
	title.FontSize(_fontsize);
	title.Corner(this.corner);
	return(this.Add(title));
}

//---------------------------------------------------------------------
//	Add an object of the "Output field" type with specified parameters to the list:
//---------------------------------------------------------------------
int		TableDisplay::AddFieldObject(int _cols, int _lines, int _col, int _row, color _color, string _fontname, int _fontsize)
{
	TFieldDisplay*		field = new TFieldDisplay();
	field.Create(this.chart_id, this.sub_window, _cols, _lines, _col, _row);
	field.Description("");
	field.Color(_color);
	field.Font(_fontname);
	field.FontSize(_fontsize);
	field.Corner(this.corner);
	return(this.Add(field));
}

//---------------------------------------------------------------------
//	Set anchor point of the object:
//---------------------------------------------------------------------
bool	TableDisplay::SetAnchor(int _index, ENUM_ANCHOR_POINT _anchor)
{
	CChartObjectText*	object = GetNodeAtIndex(_index);
	if(object == NULL)
	{
		return(false);
	}
	return(object.Anchor(_anchor));
}

//---------------------------------------------------------------------
//	Set color of the graphical text object:
//---------------------------------------------------------------------
bool	TableDisplay::SetColor(int _index, color _color)
{
	CChartObjectText*	object = GetNodeAtIndex(_index);
	if(object == NULL)
	{
		return(false);
	}
	return(object.Color(_color));
}
//---------------------------------------------------------------------
//	Set font parameters for the graphical text object:
//---------------------------------------------------------------------
bool	TableDisplay::SetFont(int _index, string _fontname, int _fontsize)
{
	CChartObjectText*	object = GetNodeAtIndex(_index);
	if(object == NULL)
	{
		return(false);
	}

	if(object.Font(_fontname) == false)
	{
		return(false);
	}
	return(object.FontSize(_fontsize));
}

//---------------------------------------------------------------------
//	Set text for the graphical text object:
//---------------------------------------------------------------------
bool	TableDisplay::SetText(int _index, string _text)
{
	CChartObjectText*	object = GetNodeAtIndex(_index);
	if(object == NULL)
	{
		return(false);
	}
	return(object.Description(_text));
}
//---------------------------------------------------------------------
