//+------------------------------------------------------------------+
//|                                                SpinnerDemoEA.mq5 |
//|                                      Copyright 2010, Investeo.pl |
//|                                           http://www.investeo.pl |
//+------------------------------------------------------------------+
#property copyright "Copyright 2010, Investeo.pl"
#property link      "http://www.investeo.pl"
#property version   "1.00"

#include <ChartObjectExtControls.mqh>

CChartObjectSpinner spinner,spinner2,spinner3;
CChartObjectLabel label;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   spinner.Create(0, "spinner1", 0, 10, 10, 200, 40, 0.0, 0.4);
   spinner.SetMin(0);
   spinner.SetMax(100);

   spinner2.Create(0, "spinner2", 0, 10, 70, 250, 50, 0.0, 1.0, 0.0);
   spinner2.SetMin(0);
   spinner2.SetMax(200);
//spinner2.SetValue(0);

   spinner3.Create(0, "spinner3", 0, 10, 140, 450, 25, 0.0, 0.123456789, 8);
   spinner3.SetMin(0.0);
   spinner3.SetMax(10);
//spinner3.SetValue(0);
//ChartRedraw();
   label.Create(0, "label", 0, 20, 200);
   label.Color(WhiteSmoke);
   label.FontSize(48);
   label.Description(DoubleToString(spinner.GetValue()+spinner2.GetValue()+spinner3.GetValue()));


//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---

  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---

  }
//+------------------------------------------------------------------+

void OnChartEvent(const int id,
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
  {
//--- Check the event by pressing a mouse button
   if(id==CHARTEVENT_OBJECT_CLICK)
     {

      if(sparam=="spinner1_up") spinner.Inc();
      if(sparam=="spinner1_down") spinner.Dec();
      if(sparam=="spinner2_up") spinner2.Inc();
      if(sparam=="spinner2_down") spinner2.Dec();
      if(sparam=="spinner3_up") spinner3.Inc();
      if(sparam=="spinner3_down") spinner3.Dec();

      label.Description(DoubleToString(NormalizeDouble(spinner.GetValue()+spinner2.GetValue()+spinner3.GetValue(),10),10));

      ChartRedraw();
      //};
     }
  }
//+------------------------------------------------------------------+
