//+------------------------------------------------------------------+
//|                                                   EURUSD DRS.mq5 |
//|                                  Copyright 2024, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2024, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"

//+------------------------------------------------------------------+
//| System constants                                                 |
//+------------------------------------------------------------------+
#define HORIZON 10
#define MA_PERIOD 5
#define MA_SHIFT 0
#define MA_MODE MODE_SMA
#define TRADING_VOLUME SymbolInfoDouble(Symbol(),SYMBOL_VOLUME_MIN)

//+------------------------------------------------------------------+
//| System dependencies                                              |
//+------------------------------------------------------------------+
#resource "\\Files\\DRS\\EURUSD RF D1 T DRS.onnx" as uchar onnx_proto[]   //Our Trend Model
#resource "\\Files\\DRS\\EURUSD RF D1 M DRS.onnx" as uchar onnx_proto_2[] //Our Mean Reverting Model

//+------------------------------------------------------------------+
//| System libraries                                                 |
//+------------------------------------------------------------------+
#include <Trade/Trade.mqh>
CTrade Trade;

//+------------------------------------------------------------------+
//| Technical Indicators                                             |
//+------------------------------------------------------------------+
int    ma_o_handle,ma_c_handle,atr_handle;
double ma_o[],ma_c[],atr[];
double bid,ask;
int    holding_period;

//+------------------------------------------------------------------+
//| Global variables                                                 |
//+------------------------------------------------------------------+
long onnx_model,onnx_model_2;

//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   if(!setup()) return(INIT_FAILED);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
   release();
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   static datetime time_stamp;
   datetime current_time = iTime(Symbol(),PERIOD_D1,0);

   if(time_stamp != current_time)
     {
      time_stamp = current_time;
      update_variables();

      if(PositionsTotal() == 0)
        {
         find_setup();
        }

      else
         if(PositionsTotal() > 0)
           {
            manage_setup();
           }
     }
  }
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| Attempt To Setup Our System Variables                            |
//+------------------------------------------------------------------+
bool setup(void)
  {

   atr_handle = iATR(Symbol(),PERIOD_CURRENT,14);
   ma_c_handle = iMA(Symbol(),PERIOD_CURRENT,MA_PERIOD,MA_SHIFT,MA_MODE,PRICE_CLOSE);
   ma_o_handle = iMA(Symbol(),PERIOD_CURRENT,MA_PERIOD,MA_SHIFT,MA_MODE,PRICE_OPEN);
   holding_period = 0;

   onnx_model = OnnxCreateFromBuffer(onnx_proto,ONNX_DEFAULT);
   onnx_model_2 = OnnxCreateFromBuffer(onnx_proto_2,ONNX_DEFAULT);

   if(onnx_model == INVALID_HANDLE)
     {
      Comment("Failed to load Trend DRS model");
      return(false);
     }

   if(onnx_model_2 == INVALID_HANDLE)
     {
      Comment("Failed to load Mean Reverting DRS model");
      return(false);
     }


   ulong input_shape[] = {1,10};
   ulong output_shape[] = {1,1};

   if(!OnnxSetInputShape(onnx_model,0,input_shape))
     {
      Comment("Failed to set Trend DRS Model input shape");
      return(false);
     }

   if(!OnnxSetInputShape(onnx_model_2,0,input_shape))
     {
      Comment("Failed to set Mean Reverting DRS Model input shape");
      return(false);
     }

   if(!OnnxSetOutputShape(onnx_model,0,output_shape))
     {
      Comment("Failed to set Trend DRS Model output shape");
      return(false);
     }

   if(!OnnxSetOutputShape(onnx_model_2,0,output_shape))
     {
      Comment("Failed to set Mean Reverting DRS Model output shape");
      return(false);
     }
   return(true);
  }

//+------------------------------------------------------------------+
//| Free up system resources                                         |
//+------------------------------------------------------------------+
void release(void)
  {
   IndicatorRelease(ma_c_handle);
   IndicatorRelease(ma_o_handle);
   OnnxRelease(onnx_model);
   OnnxRelease(onnx_model_2);
  }

//+------------------------------------------------------------------+
//| Update our system variables                                      |
//+------------------------------------------------------------------+
void update_variables(void)
  {
   bid = SymbolInfoDouble(Symbol(),SYMBOL_BID);
   ask = SymbolInfoDouble(Symbol(),SYMBOL_ASK);
   CopyBuffer(ma_c_handle,0,1,(HORIZON*2),ma_c);
   CopyBuffer(ma_o_handle,0,1,(HORIZON*2),ma_o);
   CopyBuffer(atr_handle,0,0,1,atr);
   ArraySetAsSeries(ma_c,true);
   ArraySetAsSeries(ma_o,true);
  }

//+------------------------------------------------------------------+
//| Manage The Trade We Have Open                                    |
//+------------------------------------------------------------------+
void manage_setup(void)
  {
   if((PositionsTotal() > 0) && (holding_period < (HORIZON-1)))
      holding_period +=1;

   else
      if((PositionsTotal() > 0) && (holding_period == (HORIZON - 1)))
         Trade.PositionClose(Symbol());
  }

//+------------------------------------------------------------------+
//| Find A Trading Oppurtunity For Our Strategy                      |
//+------------------------------------------------------------------+
void find_setup(void)
  {
   vectorf model_inputs   = vectorf::Zeros(10);
   vectorf model_outputs  = vectorf::Zeros(1);
   vectorf model_2_outputs  = vectorf::Zeros(1);
   holding_period = 0;
   int i = 0;

   model_inputs[0] = (float) iOpen(Symbol(),PERIOD_CURRENT,0);
   model_inputs[1] = (float) iHigh(Symbol(),PERIOD_CURRENT,0);
   model_inputs[2] = (float) iLow(Symbol(),PERIOD_CURRENT,0);
   model_inputs[3] = (float) iClose(Symbol(),PERIOD_CURRENT,0);
   model_inputs[4] = (float)(iOpen(Symbol(),PERIOD_CURRENT,0) - iOpen(Symbol(),PERIOD_CURRENT,HORIZON));
   model_inputs[5] = (float)(iHigh(Symbol(),PERIOD_CURRENT,0) - iHigh(Symbol(),PERIOD_CURRENT,HORIZON));
   model_inputs[6] = (float)(iLow(Symbol(),PERIOD_CURRENT,0) - iLow(Symbol(),PERIOD_CURRENT,HORIZON));
   model_inputs[7] = (float)(iClose(Symbol(),PERIOD_CURRENT,0) - iClose(Symbol(),PERIOD_CURRENT,HORIZON));
   model_inputs[8] = (float) ma_c[0];
   model_inputs[9] = (float)(ma_c[0] - ma_c[HORIZON]);

   if(!OnnxRun(onnx_model,ONNX_DEFAULT,model_inputs,model_outputs))
     {
      Comment("Failed to run the ONNX model correctly.");
     }

   if(!OnnxRun(onnx_model_2,ONNX_DEFAULT,model_inputs,model_2_outputs))
     {
      Comment("Failed to run the ONNX model correctly.");
     }

   if(model_outputs[0] > 0)
     {
      if(ma_c[0] < ma_o[0])
        {
         if(iClose(Symbol(),PERIOD_CURRENT,0) > ma_c[0])
            Trade.Buy(TRADING_VOLUME,Symbol(),ask,0,0,"");
        }

      else
         if(ma_c[0] > ma_o[0])
           {
            if(iClose(Symbol(),PERIOD_CURRENT,0) < ma_c[0])
               Trade.Sell(TRADING_VOLUME,Symbol(),bid,0,0,"");
           }
     }

   else
      if(model_2_outputs[0] > 0)
        {
         if(ma_c[0] < ma_o[0])
           {
            if(iClose(Symbol(),PERIOD_CURRENT,0) < ma_c[0])
               Trade.Buy(TRADING_VOLUME,Symbol(),ask,0,0,"");
           }

         if(ma_c[0] > ma_o[0])
           {
            if(iClose(Symbol(),PERIOD_CURRENT,0) > ma_c[0])
               Trade.Sell(TRADING_VOLUME,Symbol(),bid,0,0,"");
           }
        }

   Comment("0: ",model_outputs[0],"1: ",model_2_outputs[0]);
  }

//+------------------------------------------------------------------+
//| Undefine system constants                                        |
//+------------------------------------------------------------------+
#undef HORIZON
#undef MA_MODE
#undef MA_PERIOD
#undef MA_SHIFT
#undef TRADING_VOLUME
//+------------------------------------------------------------------+