//+------------------------------------------------------------------+
//|                                                      Average.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_minimum 0
#property indicator_maximum 100

#property indicator_level1 33
#property indicator_level2 67

#property indicator_type1  DRAW_LINE
#property indicator_label1 "Average"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

input ushort iPeriod=24;//Indicator period
ushort period=3;
int array[][2],size=1,cnt=1;
double buffer[],price[][2];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   ArraySetAsSeries(buffer,true);

   IndicatorSetInteger(INDICATOR_DIGITS,1);

   period=MathMax(period,iPeriod);
   ArrayResize(price,period);

   ArrayResize(array,size,period);
   ArrayInitialize(array,0);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   if(rates_total>prev_calculated)
     {
      ArraySetAsSeries(open,true);

      int bars=prev_calculated>0? rates_total-prev_calculated-1:rates_total-period-1;

      for(int i=bars;i>=0;i--)
        {
         double ma=0;
         for(int j=0;j<period;j++)
           {
            ma=ma+open[i+j];
            price[j][0]=ma/(j+1);
            price[j][1]=j;
           }

         ArraySort(price);

         int sum=0;
         for(int j=0;j<period;j++)
            sum=sum+(int)MathRound(MathAbs(price[j][1]-j));

         int indx=ArrayBsearch(array,sum);
         if(array[indx][0]==sum)
            array[indx][1]++;
         else
           {
            ArrayResize(array,size+1);
            array[size][0]=sum;
            array[size][1]=1;
            size++;
            ArraySort(array);
            indx=ArrayBsearch(array,sum);
           }

         int cdf=0;
         for(int j=indx;j>=0;j--)
            cdf=cdf+array[j][1];

         cnt++;

         buffer[i]=100.*cdf/cnt;
        }
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
