//+------------------------------------------------------------------+
//|                                                       Abbe 3.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 2
#property indicator_plots   2

#property indicator_minimum 0
#property indicator_maximum 100

#property indicator_level1 33
#property indicator_level2 67

#property indicator_type1  DRAW_LINE
#property indicator_label1 "Abbe"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

#property indicator_type2  DRAW_LINE
#property indicator_label2 "Direct."
#property indicator_color2 clrRed
#property indicator_width2 1
#property indicator_style2 STYLE_SOLID

input ushort iPeriod=24;//Indicator period
ushort period=3;
int c;
double buffer1[],buffer2[],price[],max=0,min=DBL_MAX;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer1,INDICATOR_DATA);
   ArraySetAsSeries(buffer1,true);

   SetIndexBuffer(1,buffer2,INDICATOR_DATA);
   ArraySetAsSeries(buffer2,true);

   IndicatorSetInteger(INDICATOR_DIGITS,1);

   period=MathMax(period,iPeriod);
   ArrayResize(price,period);

   c=period*(period-1)/2;
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   if(rates_total>prev_calculated)
     {
      ArraySetAsSeries(open,true);

      int bars=prev_calculated>0? rates_total-prev_calculated-1:rates_total-period-1;

      for(int i=bars;i>=0;i--)
        {
         for(int j=0;j<period;j++)
            price[j]=open[i+j];

         int curtrend=0;
         double dist=0,sum=0;
         for(int j=period-2;j>=0;j--)
           {
            for(int h=j+1;h<period;h++)
              {
               if(price[j]>price[h])
                  curtrend++;
               if(price[j]<price[h])
                  curtrend--;
              }

            dist=dist+MathAbs(price[j]-price[j+1]);
            if(dist>0)
               sum=sum+MathAbs(price[j]-price[period-1])/dist;
           }

         max=MathMax(max,sum);
         min=MathMin(min,sum);

         buffer1[i]=max>min? 100*(sum-min)/(max-min):EMPTY_VALUE;
         buffer2[i]=50.*(curtrend+c)/c;
        }
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
