#include <CPriceBuffer.mqh>

// Global price buffer
CPriceBuffer* g_priceBuffer = NULL;

void OnInit()
{
   // Initialize the price buffer
   g_priceBuffer = new CPriceBuffer(5000);
}

void OnTick()
{
   // Add current price to the buffer
   double price = SymbolInfoDouble(_Symbol, SYMBOL_BID);
   g_priceBuffer.Add(price);
   
   // Calculate moving averages
   double sma20 = g_priceBuffer.SMA(20);
   double sma50 = g_priceBuffer.SMA(50);
   
   // Trading logic based on moving averages...
}

void OnDeinit(const int reason)
{
   // Clean up
   delete g_priceBuffer;
   g_priceBuffer = NULL;
}