//+------------------------------------------------------------------+
//| MemoryProfiler class for tracking memory usage                   |
//+------------------------------------------------------------------+
class CMemoryProfiler
{
private:
   ulong m_startMemory;
   ulong m_peakMemory;
   string m_profileName;
   
public:
   // Constructor
   CMemoryProfiler(string profileName)
   {
      m_profileName = profileName;
      m_startMemory = TerminalInfoInteger(TERMINAL_MEMORY_AVAILABLE);
      m_peakMemory = m_startMemory;
      
      Print("Memory profiling started for: ", m_profileName);
      Print("Initial available memory: ", m_startMemory, " bytes");
   }
   
   // Update peak memory usage
   void UpdatePeak()
   {
      ulong currentMemory = TerminalInfoInteger(TERMINAL_MEMORY_AVAILABLE);
      if(currentMemory < m_peakMemory)
         m_peakMemory = currentMemory;
   }
   
   // Get memory usage
   ulong GetUsedMemory()
   {
      return m_startMemory - TerminalInfoInteger(TERMINAL_MEMORY_AVAILABLE);
   }
   
   // Get peak memory usage
   ulong GetPeakUsage()
   {
      return m_startMemory - m_peakMemory;
   }
   
   // Print memory usage report
   void PrintReport()
   {
      ulong currentUsage = GetUsedMemory();
      ulong peakUsage = GetPeakUsage();
      
      Print("Memory profile report for: ", m_profileName);
      Print("Current memory usage: ", currentUsage, " bytes");
      Print("Peak memory usage: ", peakUsage, " bytes");
   }
   
   // Destructor
   ~CMemoryProfiler()
   {
      PrintReport();
   }
};