//US500 M30
#include <Trade/Trade.mqh>
CTrade trade;

input int Magic = 0;
input double lot = 0.1;

int barsTotal = 0;
int handleMa;
int handleMaFast;
int handleRsi;
const int Max = 5;
const int Min = 95;
const int MaPeriods = 200;
const int MaPeriodsFast = 5;
const double slp = 0.0015;

int OnInit()
  {
   trade.SetExpertMagicNumber(Magic);
   handleMa =iMA(_Symbol,PERIOD_CURRENT,MaPeriods,0,MODE_SMA,PRICE_CLOSE);
   handleMaFast = iMA(_Symbol,PERIOD_CURRENT,MaPeriodsFast,0,MODE_SMA,PRICE_CLOSE);
   handleRsi = iRSI(_Symbol,PERIOD_CURRENT,2,PRICE_CLOSE);
   return(INIT_SUCCEEDED);
  }

void OnDeinit(const int reason)
  {
  }
  

void OnTick()
  {
  int bars = iBars(_Symbol,PERIOD_CURRENT);
  
  if (barsTotal!= bars){
     barsTotal = bars;
     bool NotInPosition = true;
     double ma[];
     double ma_fast[];
     double rsi[];
     CopyBuffer(handleMa,BASE_LINE,1,1,ma);
     CopyBuffer(handleMaFast,BASE_LINE,1,1,ma_fast);
     CopyBuffer(handleRsi,0,1,1,rsi);
     double lastClose = iClose(_Symbol, PERIOD_CURRENT, 1);
     for(int i = PositionsTotal()-1; i>=0; i--){
         ulong pos = PositionGetTicket(i);
         string symboll = PositionGetSymbol(i);
         if(PositionGetInteger(POSITION_MAGIC) == Magic&&symboll== _Symbol){
            NotInPosition = false;
            if((PositionGetInteger(POSITION_TYPE) == POSITION_TYPE_BUY&&(lastClose>ma_fast[0]||lastClose<ma[0]))
            ||(PositionGetInteger(POSITION_TYPE) == POSITION_TYPE_SELL&&(lastClose<ma_fast[0]||lastClose>ma[0])))trade.PositionClose(pos);  
            }}
     if(rsi[0]<Max&&NotInPosition&&lastClose>ma[0])executeBuy();
     if(rsi[0]>Min&&NotInPosition&&lastClose<ma[0])executeSell();
    }
 }

void executeSell() {      
       double bid = SymbolInfoDouble(_Symbol, SYMBOL_BID);
       bid = NormalizeDouble(bid,_Digits);
       double sl = bid*(1+slp);
       sl = NormalizeDouble(sl, _Digits);
       trade.Sell(lot,_Symbol,bid,sl);    
}
    
void executeBuy() {
       double ask = SymbolInfoDouble(_Symbol, SYMBOL_ASK);
       ask = NormalizeDouble(ask,_Digits);
       double sl = ask*(1-slp);
       sl = NormalizeDouble(sl, _Digits);
       trade.Buy(lot,_Symbol,ask,sl);
}
