//+------------------------------------------------------------------+
//|                                                 New Function.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_type1  DRAW_ARROW
#property indicator_label1 "New Func."
#property indicator_color1 clrBlue
#property indicator_width1 5
#property indicator_style1 STYLE_SOLID

enum type {Rademacher,Walsh,RadSmooth,Hartley};

input type Type=Rademacher;
input uchar N=3,
            P=3,
            Shift=0;

struct func {int c[];};
func array[];
int period,size;
double buffer[],weight[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   ArraySetAsSeries(buffer,true);

   period=(int)MathPow(2,MathMax(1,MathMin(N,12)));
   int max_p=period-1;

   if(Type==Rademacher || Type==RadSmooth)
      max_p=N;

   size=MathMin(P,max_p)+1;

   ArrayResize(array,size);
   ArrayResize(weight,size);

   for(int i=0;i<size;i++)
     {
      ArrayResize(array[i].c,period);

      if(Type==Rademacher)
         for(int j=0;j<period;j++)
            array[i].c[j]=sign(MathSin(MathPow(2,i)*(j+0.5)*M_PI/period));

      if(Type==Walsh)
        {
         for(int j=0;j<period;j++)
           {
            if(MathMod(i,2)==0)
               array[i].c[j]=sign(MathCos(i*(j+0.5)*M_PI/period));
            else
               array[i].c[j]=sign(MathSin((i+1)*(j+0.5)*M_PI/period));
           }
        }

      if(Type==RadSmooth)
         for(int j=0;j<period;j++)
            array[i].c[j]=sign(MathCos(2*i*(j+0.5)*M_PI/period));

      if(Type==Hartley)
         for(int j=0;j<period;j++)
            array[i].c[j]=sign(MathCos(2*i*j*M_PI/period)+MathSin(2*i*j*M_PI/period));
     }
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   if(rates_total>prev_calculated)
     {
      ArraySetAsSeries(open,true);
      ArrayInitialize(buffer,EMPTY_VALUE);

      for(int i=0;i<size;i++)
        {
         weight[i]=0;
         for(int j=0;j<period;j++)
            weight[i]=weight[i]+array[i].c[j]*open[j+Shift];
         weight[i]=weight[i]/period;
        }

      for(int i=0;i<period;i++)
        {
         double res=0;
         for(int j=0;j<size;j++)
            res=res+weight[j]*array[j].c[i];
         buffer[i+Shift]=res;
        }
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
char sign(double x)
  {
//---
   if(x>0)
      return(1);
   if(-x>0)
      return(-1);
   return(0);
//---
  }
//+------------------------------------------------------------------+
