//+------------------------------------------------------------------+
//|                                             NEURAL NETWORK CLASS.|
//|                                                       NOV., 2024 |
//+------------------------------------------------------------------+
#property version   "1.00"
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CLayer
{
protected:
public:
   matrix               weights;
   vector               biases;
   matrix               gradients;
   vector               deltas;
   vector               activations;
   ENUM_ACTIVATION_FUNCTION af_type;

   void                 CLayer(ulong Neurons, ENUM_ACTIVATION_FUNCTION AF = AF_RELU)
   {  biases.Init(Neurons);
      biases.Fill(0.0);
      //
      activations.Init(Neurons);
      activations.Fill(0.0);
   };
   void                 ~CLayer() {};
   void                 AddWeights(ulong LastNeurons)
   {  weights.Init(biases.Size(), LastNeurons);
      weights.Fill(0.0);
      for(int ii = 0; ii < int(biases.Size()); ii++)
      {  for(int iii = 0; iii < int(LastNeurons); iii++)
         {  weights[ii][iii] += 0.0025 * fabs((ii + iii)-int(round(0.5*(biases.Size()+LastNeurons-2))));
         }
      }
      deltas.Init(LastNeurons);
      deltas.Fill(0.0);
      gradients.Init(biases.Size(), LastNeurons);
      gradients.Fill(0.0);
   };
};
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CNeuralNetwork
{
protected:
   
   matrix               TransposeToCol(vector &V);
   matrix               TransposeToRow(vector &V);
   
public:
   CLayer               *layers[];
   double               m_learning_rate;
   ENUM_LOSS_FUNCTION   m_loss;
   void                 AddDenseLayer(ulong Neurons, ENUM_ACTIVATION_FUNCTION AF = AF_RELU, ulong LastNeurons = 0)
   {  ArrayResize(layers, layers.Size() + 1);
      layers[layers.Size() - 1] = new CLayer(Neurons, AF);
      if(LastNeurons  != 0)
      {  layers[layers.Size() - 1].AddWeights(LastNeurons);
      }
      else if(layers.Size() - 1 > 0)
      {  layers[layers.Size() - 1].AddWeights(layers[layers.Size() - 2].activations.Size());
      }
   };
   void                 Init(double LearningRate, ENUM_LOSS_FUNCTION LF)
   {  m_loss = LF;
      m_learning_rate = LearningRate;
   };
   
   vector               Forward(vector& Data);
   void                 Backward(vector& LabelAnswer);
   
   void                 CNeuralNetwork(){};
   void                 ~CNeuralNetwork()
   {  if(layers.Size() > 0)
      {  for(int i = 0; i < int(layers.Size()); i++)
         {  delete layers[i];
         }
      }
   };
};
//+------------------------------------------------------------------+
//| Vector to Matrix-Row Tranposer                                   |
//+------------------------------------------------------------------+
matrix CNeuralNetwork::TransposeToRow(vector &V)
{  matrix _m;
   _m.Init(1, V.Size());
   _m.Fill(0.0);
   for(int i = 0; i < int(V.Size()); i++)
   {  _m[0][i] = V[i];
   }
   return(_m);
}
//+------------------------------------------------------------------+
//| Vector to Matrix-Column Tranposer                                |
//+------------------------------------------------------------------+
matrix CNeuralNetwork::TransposeToCol(vector &V)
{  matrix _m;
   _m.Init(V.Size(), 1);
   _m.Fill(0.0);
   for(int i = 0; i < int(V.Size()); i++)
   {  _m[i][0] = V[i];
   }
   return(_m);
}
//+------------------------------------------------------------------+
//| FORWARD PROPAGATION THROUGH THE MULTI-LAYER-PERCEPTRON.          |
//+------------------------------------------------------------------+
vector CNeuralNetwork::Forward(vector& Data)
{  for(int h = 0; h < int(layers.Size()); h++)
   {  layers[h].activations.Fill(0.0);
      if(h == 0)
      {  (layers[h].weights.MatMul(Data) + layers[h].biases).Activation(layers[h].activations, layers[h].af_type);
      }
      if(h > 0)
      {  (layers[h].weights.MatMul(layers[h - 1].activations) + layers[h].biases).Activation(layers[h].activations, layers[h].af_type);
      }
   }
   return(layers[layers.Size()-1].activations);
}
//+------------------------------------------------------------------+
//| BACKWARD PROPAGATION OF THE MULTI-LAYER-PERCEPTRON.              |
//+------------------------------------------------------------------+
void CNeuralNetwork::Backward(vector& LabelAnswer)
{  for(int h = int(layers.Size()) - 1; h >= 0;  h--)
   {  //COMPUTE DELTAS
      vector _derivative;
      layers[h].activations.MatMul(layers[h].weights).Derivative(_derivative, layers[h].af_type);
      vector _loss;
      if(h == int(layers.Size()) - 1)
      {  _loss = LabelAnswer.MatMul(layers[h].weights);
      }
      else
      {  _loss = layers[h + 1].deltas.MatMul(layers[h].weights);
      }
      layers[h].deltas = _loss * _derivative;
      //COMPUTE GRADIENTS
      layers[h].gradients = TransposeToCol(layers[h].activations).MatMul(TransposeToRow(layers[h].deltas));
      //UPDATE WEIGHTS AND BIASES
      layers[h].weights -= m_learning_rate * layers[h].gradients;
      layers[h].biases -= m_learning_rate * (layers[h].gradients.MatMul(layers[h].deltas));
   }
}
//+------------------------------------------------------------------+
