//+------------------------------------------------------------------+
//|                                          Ex_Timer_SleepOrNot.mq4 |
//|                                    (c) 2008 by Sergey A. Gridnev |
//|                                                                * |
//+------------------------------------------------------------------+
#property copyright "(c) 2008 by Sergey A. Gridnev"
#property link      "*"
// --
#include "include/ExLib_Timer.mqh"
// --
//---- input parameters
extern bool Use_Sleep = false;
// =true  -   "Sleep()"
// =false -  
//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
{
   timer_Init();
   if ( Use_Sleep )
      Print("init(). *   Sleep() *");
   else
      Print("init(). *   *");
   timer_StartWaitable(101, 10);
   timer_StartStopwatch(102);
   return(0);
}
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
{
   timer_DeleteAll();
   Comment("");
   return(0);
}
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
{
   Comment("Waitable:",timer_GetCounter(101)," / Stopwatch:",timer_GetCounter(102));
   Print("start() -   -");
// --
   if ( Use_Sleep )
   {
      //  -   "Sleep()" -
      Sleep( 10000 ); //  10 
      //  ,       
      Print("start() -     -");
   }
   else
   {
      //  -   -
      if ( timer_GetType(101) == 0 )
         timer_StartWaitable(101, 10); //  10 
         
      if ( timer_GetCounter(101) == 0 )
      {
         //  ,        
         timer_Delete(101);
         Print("start() -     -");
      }
   }
// --
   Print("start() -   -");
   return(0);
}
//+------------------------------------------------------------------+