//+------------------------------------------------------------------+
//|                             Ex_Timer_OrderSend_wMinTimeLimit.mq4 |
//|                                    (c) 2008 by Sergey A. Gridnev |
//|                                                                * |
//+------------------------------------------------------------------+
#property copyright "(c) 2008 by Sergey A. Gridnev"
#property link      "*"
// --
// OrderSend   1       
// --
#include "include/ExLib_Timer.mqh"
// --
#define  COUNTERID_TRADINGTIMEOUT   1   // ID   
#define  COUNTERID_SENDORDERTIMEOUT 2   // ID     
//    
extern int  MagicNumber=0;       //     MagicNumber
extern int  BUY_Enable=true;     //  BUY 
extern int  SELL_Enable=true;    //  SELL 
extern int  SL_Distance=50;      //   SL
extern int  TP_Distance=50;      //   TP
//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
{
   timer_Init();
   return(0);
} //init
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
{
   timer_DeleteAll();
   return(0);
} //deinit
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start()
{
   int      ErrorCode;
   int      type;
   int      ArrowColor;
   double   priceOpen,priceClose,TP,SL;
   
   if ( ! IsDemo() )
      return(0);
   
   if ( OrdersTotal() > 0 )
      return(0);

   if ( timer_GetCounter(COUNTERID_SENDORDERTIMEOUT) == 0 )
   {
      if ( TimeSeconds(TimeLocal()) % 2 == 0 )
      {
         type  = OP_BUY;   // BUY     
         ArrowColor  = MediumBlue;
         priceOpen   = Ask;
         priceClose  = Bid;
         TP = NormalizeDouble( priceClose + TP_Distance * Point, Digits );
         SL = NormalizeDouble( priceClose - SL_Distance * Point, Digits );
      }
      else
      {
         type  = OP_SELL;  // SELL     
         ArrowColor  = OrangeRed;
         priceOpen   = Bid;
         priceClose  = Ask;
         TP = NormalizeDouble( priceClose - TP_Distance * Point, Digits );
         SL = NormalizeDouble( priceClose + SL_Distance * Point, Digits );
      }
      
      if ( timer_GetCounter(COUNTERID_TRADINGTIMEOUT) == 0 )
      {
         if ( timer_GetCounter(COUNTERID_SENDORDERTIMEOUT) == 0 )
         {
            if ( OrderSend(Symbol(),type,0.1,priceOpen,3,SL,TP,"* Order for test *",MagicNumber,0,ArrowColor) > 0 )
            {  //   ,  
               // : OrderSend   1       
               if ( ! timer_StartWaitable(COUNTERID_SENDORDERTIMEOUT, Period() * 60) )
                  Print("!    timer_StartWaitable:   !");
            }
            else
            {
               ErrorCode   = GetLastError();
               Print("!    OrderSend!  : ",ErrorCode);
               Print(" ! STOPLEVEL * Point = ",MarketInfo(Symbol(),MODE_STOPLEVEL) * Point);
               Print(" ! FREEZELEVEL * Point = ",MarketInfo(Symbol(),MODE_FREEZELEVEL) * Point);
               //         60 .
               //         ,
               //      
               if ( ! timer_StartWaitable(COUNTERID_TRADINGTIMEOUT,60) )
                  Print("!    timer_StartWaitable:   !");
            }
         }
      }
   }
   
   return(0);
} //start
//+------------------------------------------------------------------+