//+------------------------------------------------------------------+
//|                                                  ExLib_Timer.mq4 |
//|                                    (c) 2008 by Sergey A. Gridnev |
//|                                                                * |
//+------------------------------------------------------------------+
#property copyright "(c) 2008 by Sergey A. Gridnev"
#property link      "*"
#property library
//+------------------------------------------------------------------+
#define  TIMER_MAXCOUNTERS     100 //  
// --
#define  TIMER_TYPE_STOPWATCH    1 // 
#define  TIMER_TYPE_WAITABLE    -1 //  
// --
#define  ID_TIMER_ID             0 // ID
#define  ID_TIMER_TYPEID         1 // 
#define  ID_TIMER_COUNTER        2 // 
//+------------------------------------------------------------------+
static int  timer_array[TIMER_MAXCOUNTERS][3]; // ID / (TYPE) / (COUNTER)
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
void timer_Init()
{
   ArrayInitialize(timer_array,0);
} //timer_Init
//+------------------------------------------------------------------+
int timer_NumberTotal()
{
   return( ArrayRange(timer_array,0) );
} //timer_NumberUsed
//+------------------------------------------------------------------+
int timer_NumberUsed()
{  
   int   res=0;
   int   indx;
   for ( indx=0; indx < TIMER_MAXCOUNTERS; indx++ )
      if ( timer_array[indx][ID_TIMER_ID] != 0 )
         res++;
   return(res);
} //timer_NumberUsed
//+------------------------------------------------------------------+
int timer_NumberFree()
{  
   int   res=0;
   int   indx;
   for ( indx=0; indx < TIMER_MAXCOUNTERS; indx++ )
      if ( timer_array[indx][ID_TIMER_ID] == 0 )
         res++;
   return(res);
} //timer_NumberFree
//+------------------------------------------------------------------+
void timer_ResetAll()
{
   int indx;
   for ( indx=0; indx < TIMER_MAXCOUNTERS; indx++ )
   {
      timer_array[indx][ID_TIMER_TYPEID]  = 0;
      timer_array[indx][ID_TIMER_COUNTER] = 0;
   }
} //timer_ResetAll
//+------------------------------------------------------------------+
bool timer_Reset(int CounterID)
{
   bool  res=false;
   int indx;
   for ( indx=0; indx < TIMER_MAXCOUNTERS; indx++ )
      if ( timer_array[indx][ID_TIMER_ID] == CounterID )
      {
         timer_array[indx][ID_TIMER_TYPEID]  = 0;
         timer_array[indx][ID_TIMER_COUNTER] = 0;
         res   = true;
         break;
      }
   return(res);
} //timer_Reset
//+------------------------------------------------------------------+
void timer_DeleteAll()
{  
   int   indx;
   for ( indx=0; indx < TIMER_MAXCOUNTERS; indx++ )
   {
      timer_array[indx][ID_TIMER_ID]      = 0;
      timer_array[indx][ID_TIMER_TYPEID]  = 0;
      timer_array[indx][ID_TIMER_COUNTER] = 0;
   }
} //timer_DeleteAll
//+------------------------------------------------------------------+
bool timer_Delete(int CounterID)
{  
   bool  res=false;
   int   indx;
   for ( indx=0; indx < TIMER_MAXCOUNTERS; indx++ )
      if ( timer_array[indx][ID_TIMER_ID] == CounterID )
      {
         timer_array[indx][ID_TIMER_ID]      = 0;
         timer_array[indx][ID_TIMER_TYPEID]  = 0;
         timer_array[indx][ID_TIMER_COUNTER] = 0;
         res   = true;
         break;
      }
   return(res);
} //timer_Delete
//+------------------------------------------------------------------+
bool timer_Start(int TypeID, int CounterID, int timeslice=0)
{
   bool  res=false;
   int   indx;
   
   for ( indx=0; indx < TIMER_MAXCOUNTERS; indx++ )
      if ( timer_array[indx][ID_TIMER_ID] == CounterID )
      {
         res   = true;
         break;
      }
      
   if ( ! res )
   {
      for ( indx=0; indx < TIMER_MAXCOUNTERS; indx++ )
         if ( timer_array[indx][ID_TIMER_ID] == 0 )
         {
            timer_array[indx][ID_TIMER_ID]  = CounterID;
            res   = true;
            break;
         }
   }
   
   if ( res )
   {
      timer_array[indx][ID_TIMER_TYPEID]  = TypeID;
      timer_array[indx][ID_TIMER_COUNTER] = TimeLocal() + timeslice;
   }
   return(res);
} //timer_Start
//+------------------------------------------------------------------+
bool timer_StartWaitable(int CounterID, int timeslice)
{
   return(timer_Start(TIMER_TYPE_WAITABLE,CounterID,timeslice));
} //timer_StartWaitable
//+------------------------------------------------------------------+
bool timer_StartStopwatch(int CounterID)
{
   return(timer_Start(TIMER_TYPE_STOPWATCH,CounterID));
} //timer_StartStopwatch
//+------------------------------------------------------------------+
int timer_GetCounterIDbyPOS(int CounterPOS)
{  
   int   res=0;
   int   indx;
   for ( indx=0; CounterPOS >= 0 && indx < TIMER_MAXCOUNTERS; indx++ )
      if ( timer_array[indx][ID_TIMER_ID] != 0 )
      {
         if ( CounterPOS == 0 )
         {
            res   = timer_array[indx][ID_TIMER_ID];
            break;
         }
         CounterPOS--;
      }
   return(res);
} //timer_GetCounterIDbyPOS
//+------------------------------------------------------------------+
int timer_GetCounter(int CounterID)
{  
   int   res=-1;
   int   indx;
   for ( indx=0; indx < TIMER_MAXCOUNTERS; indx++ )
      if ( timer_array[indx][ID_TIMER_ID] == CounterID )
      {
         if ( timer_array[indx][ID_TIMER_TYPEID] == TIMER_TYPE_WAITABLE )
            res   = MathMax(0,timer_array[indx][ID_TIMER_COUNTER] - TimeLocal());
         else if ( timer_array[indx][ID_TIMER_TYPEID] == TIMER_TYPE_STOPWATCH )
            res   = MathMax(0,TimeLocal() - timer_array[indx][ID_TIMER_COUNTER]);
         break;
      }
   return(res);
} //timer_GetCounter
//+------------------------------------------------------------------+
int timer_GetType(int CounterID)
{
   int   res=0;
   int   indx;
   for ( indx=0; indx < TIMER_MAXCOUNTERS; indx++ )
      if ( timer_array[indx][ID_TIMER_ID] == CounterID )
      {
         res   = timer_array[indx][ID_TIMER_TYPEID];
         break;
      }
   return(res);
} //timer_GetType
//+------------------------------------------------------------------+