//+------------------------------------------------------------------+
//|                                                SignalNAS.mqh |
//|                   Copyright 2009-2017, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#include <Expert\ExpertSignal.mqh>
#include <My\Network.mqh>
#define __PI 245850922/78256779
#define __PHI 0.61803398874989
// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signals based on eigen vector NAS                          |
//| Type=SignalAdvanced                                              |
//| Name=NAS                                                         |
//| ShortName=NAS                                                    |
//| Class=CSignalNAS                                                 |
//| Page=signal_nas                                                  |
//| Parameter=TrainSet,int,30,Training Set                           |
//| Parameter=Epochs,int,6,Epochs                                    |
//| Parameter=LearningRate,double,0.005,LearningRate                 |
//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+
//| Class CSignalNAS.                                                |
//| Purpose: Class of eigen vector NAS.                              |
//|            Derives from class CExpertSignal.                     |
//+------------------------------------------------------------------+
#define __LAYERS 9
#define __SIZES 4
#define __INPUTS 4
#define __OUTPUTS 1
int                              __SETTINGS[__LAYERS]

   =

//{  __INPUTS, __SIZES, __SIZES, __SIZES, __SIZES,  __OUTPUTS
//};

{  __INPUTS, __SIZES, __SIZES, __SIZES, __SIZES,  __SIZES,  __SIZES,  __SIZES,  __OUTPUTS
};
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CSignalNAS                 : public CExpertSignal
{
protected:

   int                           m_train_set;                           // Epochs
   int                           m_epochs;                              // Epochs
   double                        m_learning_rate;                       // Epsilon

   double                        m_train_deposit;
   double                        m_train_criteria;

public:
   CSignalNAS(void);
   ~CSignalNAS(void);

   //--- method of verification of settings
   virtual bool                  ValidationSettings(void);
   //--- method of creating the indicator and timeseries
   virtual bool                  InitIndicators(CIndicators *indicators);
   //--- methods of checking if the market models are formed
   virtual int                   LongCondition(void);
   virtual int                   ShortCondition(void);
   //---
   void                          TrainSet(int value)
   {  m_train_set = value;
   }
   void                          Epochs(int value)
   {  m_epochs = value;
   }
   void                          LearningRate(double value)
   {  m_learning_rate = value;
   }


protected:
   double                        GetOutput();
   void                          SetOutput();

   Cnetwork                      *N;

};
//+------------------------------------------------------------------+
//| Constructor                                                      |
//+------------------------------------------------------------------+
void CSignalNAS::CSignalNAS(void)  :    m_train_set(390),
   m_epochs(30),
   m_learning_rate(0.005)
{
//--- initialization of protected data
   m_used_series = USE_SERIES_OPEN + USE_SERIES_HIGH + USE_SERIES_LOW + USE_SERIES_CLOSE + USE_SERIES_SPREAD + USE_SERIES_TIME;
}
//+------------------------------------------------------------------+
//| Destructor                                                       |
//+------------------------------------------------------------------+
void CSignalNAS::~CSignalNAS(void)
{  //write best weights
   //SetOutput();
   delete N;
}
//+------------------------------------------------------------------+
//| Validation settings protected data.                              |
//+------------------------------------------------------------------+
bool CSignalNAS::ValidationSettings(void)
{  if(!CExpertSignal::ValidationSettings())
      return(false);
//--- initial data checks
   if(m_epochs < 1)
   {  printf(__FUNCSIG__ + " epochs size should at least be 1! ");
      return(false);
   }
   if(m_learning_rate < 0.0)
   {  printf(__FUNCSIG__ + " learning rate should be greater than 0.0! ");
      return(false);
   }
   N = new Cnetwork(__SETTINGS, 0.1, 0.01);
   m_train_deposit = AccountInfoDouble(ACCOUNT_BALANCE);
   m_train_criteria = 0.0;
   //read best weights
   //datetime _version;
   //N.Get(m_symbol.Name()+"_"+EnumToString(m_period), m_train_criteria, _version);
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| Create indicators.                                               |
//+------------------------------------------------------------------+
bool CSignalNAS::InitIndicators(CIndicators *indicators)
{
//--- check pointer
   if(indicators == NULL)
      return(false);
//--- initialization of indicators and timeseries of additional filters
   if(!CExpertSignal::InitIndicators(indicators))
      return(false);
//--- ok
   return(true);
}
//+------------------------------------------------------------------+
//| "Voting" that price will grow.                                   |
//+------------------------------------------------------------------+
int CSignalNAS::LongCondition(void)
{  int result = 0;
   double _cond = GetOutput();
   _cond *= 100.0;
   if(_cond > 50.0)
   {  result = 100;//int(2.0*(_cond - 50.0));
   }
   return(result);
}
//+------------------------------------------------------------------+
//| "Voting" that price will fall.                                   |
//+------------------------------------------------------------------+
int CSignalNAS::ShortCondition(void)
{  int result = 0;
   double _cond = GetOutput();
   _cond *= 100.0;
   if(_cond < 50.0)
   {  result = 100;//int(2.0*(50.0 - _cond));
   }
   return(result);
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double CSignalNAS::GetOutput()
{  double _output = 0.0;
   for(int i = m_train_set; i >= 0; i--)
   {  vector _in, _out;
      vector _in_new, _out_new, _in_old, _out_old;
      _in_new.CopyRates(m_symbol.Name(), m_period, 8, i + 1, __INPUTS);
      _in_old.CopyRates(m_symbol.Name(), m_period, 8, i + 1 + 1, __INPUTS);
      _in = Norm(_in_new, _in_old);
      N.Set(_in);
      N.Forward();
      if(i > 0)// train
      {  _out_new.CopyRates(m_symbol.Name(), m_period, 8, i, __OUTPUTS);
         _out_old.CopyRates(m_symbol.Name(), m_period, 8, i + 1, __OUTPUTS);
         _out = Norm(_out_new, _out_old);
         N.Get(_out);
         N.Backward(m_learning_rate);
      }
      else
      {  _output = N.output[0];
      }
   }
   return(_output);
}
//+------------------------------------------------------------------+
//| Weights & Biases exporting function for network                  |
//+------------------------------------------------------------------+
void CSignalNAS::SetOutput(void)
{  if(AccountInfoDouble(ACCOUNT_EQUITY) - m_train_deposit > m_train_criteria && m_train_criteria >= 0.0)
   {  N.Set(m_symbol.Name() + "_" + EnumToString(m_period), AccountInfoDouble(ACCOUNT_EQUITY) - m_train_deposit);
   }
}
//+------------------------------------------------------------------+
//| Normalization                                                    |
//+------------------------------------------------------------------+
vector Norm(vector &A, vector &B)
{  vector _n;
   _n.Init(A.Size());
   if(A.Size() > 0 && B.Size() > 0 && A.Size() == B.Size() && A.Min() > 0.0 && B.Min() > 0.0)
   {  int _size = int(A.Size());
      _n.Fill(0.5);
      for(int i = 0; i < _size; i++)
      {  if(A[i] > B[i])
         {  _n[i] += (0.5*((A[i] - B[i])/A[i]));
         }
         else if(A[i] < B[i])
         {  _n[i] -= (0.5*((B[i] - A[i])/B[i]));
         }
      }
   }
   return(_n);
}
//+------------------------------------------------------------------+
